/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.core.swt.renderer;

import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.edit.internal.swt.util.PreSetValidationListeners;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.alignment.model.AlignmentType;
import org.eclipse.emf.ecp.view.template.style.alignment.model.VTAlignmentStyleProperty;
import org.eclipse.emf.ecp.view.template.style.textControlEnablement.model.VTTextControlEnablementStyleProperty;
import org.eclipse.emf.ecp.view.template.style.unsettable.model.ButtonPlacementType;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationService;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationServiceRunnable;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TextControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private final EMFFormsEditSupport emfFormsEditSupport;

    @Inject
    public TextControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.emfFormsEditSupport = emfFormsEditSupport;
    }

    @Override
    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        EStructuralFeature structuralFeature = (EStructuralFeature)this.getModelValue().getValueType();
        UpdateValueStrategy targetToModelUpdateStrategy = this.withPreSetValidation((UpdateValueStrategy)new TargetToModelUpdateStrategy(structuralFeature.isUnsettable()));
        ModelToTargetUpdateStrategy modelToTargetUpdateStrategy = new ModelToTargetUpdateStrategy(false);
        Binding binding = this.bindValue(control, this.getModelValue(), this.getDataBindingContext(), targetToModelUpdateStrategy, (UpdateValueStrategy)modelToTargetUpdateStrategy);
        Binding tooltipBinding = this.createTooltipBinding(control, this.getModelValue(), this.getDataBindingContext(), targetToModelUpdateStrategy, (UpdateValueStrategy)new ModelToTargetUpdateStrategy(true));
        return new Binding[]{binding, tooltipBinding};
    }

    @Override
    protected Control createSWTControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(composite);
        final Text text = new Text(composite, this.getTextWidgetStyle());
        text.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getTextVariantID());
        text.setMessage(this.getTextMessage());
        try {
            PreSetValidationListeners.create().verify(text, this.getFeature(), this.getVElement());
            PreSetValidationListeners.create().focus(text, this.getFeature(), new PreSetValidationServiceRunnable(){

                public void run(PreSetValidationService service) {
                    try {
                        boolean isBoundValueValid;
                        EDataType attributeType = ((EAttribute)TextControlSWTRenderer.this.getFeature()).getEAttributeType();
                        String textFieldText = TextControlSWTRenderer.this.getTextFromTextField(text, attributeType);
                        Object convertedValue = TextControlSWTRenderer.this.convert(text, attributeType, textFieldText);
                        Diagnostic textDiag = service.validate(TextControlSWTRenderer.this.getFeature(), convertedValue);
                        Diagnostic boundDiag = service.validate(TextControlSWTRenderer.this.getFeature(), TextControlSWTRenderer.this.getModelValue().getValue());
                        boolean isEnteredValueValid = textDiag.getSeverity() == 0;
                        boolean bl = isBoundValueValid = boundDiag.getSeverity() == 0;
                        if (TextControlSWTRenderer.this.getModelValue().getValue() != null && !isEnteredValueValid && isBoundValueValid) {
                            ((VControl)TextControlSWTRenderer.this.getVElement()).setDiagnostic(null);
                            TextControlSWTRenderer.this.getDataBindingContext().updateTargets();
                        }
                    }
                    catch (DatabindingFailedException attributeType) {
                    }
                    catch (IllegalArgumentException ex) {
                        ((VControl)TextControlSWTRenderer.this.getVElement()).setDiagnostic(null);
                        TextControlSWTRenderer.this.getDataBindingContext().updateTargets();
                        return;
                    }
                }
            }, new Runnable(){

                @Override
                public void run() {
                    text.selectAll();
                }
            });
        }
        catch (DatabindingFailedException databindingFailedException) {
            // empty catch block
        }
        GridDataFactory gdf = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).span(1, 1);
        EMFFormsEditSupport editSupport = this.getEMFFormsEditSupport();
        if (editSupport.isMultiLine(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel())) {
            gdf.hint(50, 200);
        }
        gdf.applyTo((Control)text);
        return composite;
    }

    protected Object convert(Text text, EDataType attributeType, String value) throws DatabindingFailedException {
        return EcoreUtil.createFromString((EDataType)attributeType, (String)value);
    }

    protected String getTextMessage() {
        try {
            return (String)this.getEMFFormsLabelProvider().getDisplayName(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel()).getValue();
        }
        catch (NoLabelFoundException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return "";
        }
    }

    protected Binding bindValue(Control text, IObservableValue modelValue, DataBindingContext dataBindingContext, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        Control controlToObserve = ((Composite)Composite.class.cast(text)).getChildren()[0];
        boolean useOnModifyDatabinding = this.useOnModifyDatabinding();
        ISWTObservableValue value = useOnModifyDatabinding ? WidgetProperties.text((int)24).observeDelayed(250, (Widget)controlToObserve) : WidgetProperties.text((int)16).observe((Widget)controlToObserve);
        Binding binding = dataBindingContext.bindValue((IObservableValue)value, modelValue, targetToModel, modelToTarget);
        return binding;
    }

    protected boolean useOnModifyDatabinding() {
        VElement viewCandidate = this.getViewModelContext().getViewModel();
        if (!VView.class.isInstance(viewCandidate)) {
            return false;
        }
        VViewModelProperties properties = ((VView)VView.class.cast(viewCandidate)).getLoadingProperties();
        if (properties == null) {
            return false;
        }
        return "true".equalsIgnoreCase((String)properties.get("useOnModifyDatabinding"));
    }

    protected Binding createTooltipBinding(Control text, IObservableValue modelValue, DataBindingContext dataBindingContext, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        ISWTObservableValue toolTip = WidgetProperties.tooltipText().observe((Widget)text);
        return dataBindingContext.bindValue((IObservableValue)toolTip, modelValue, targetToModel, modelToTarget);
    }

    protected int getTextWidgetStyle() {
        int textStyle = 2052;
        EMFFormsEditSupport editSupport = this.getEMFFormsEditSupport();
        if (editSupport.isMultiLine(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel())) {
            textStyle = 2882;
        }
        return textStyle |= this.getAlignment();
    }

    protected EMFFormsEditSupport getEMFFormsEditSupport() {
        return this.emfFormsEditSupport;
    }

    private int getAlignment() {
        if (this.getVTViewTemplateProvider() == null) {
            return this.getDefaultAlignment();
        }
        Set styleProperties = this.getVTViewTemplateProvider().getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTAlignmentStyleProperty.class.isInstance(styleProperty)) continue;
            if (((VTAlignmentStyleProperty)VTAlignmentStyleProperty.class.cast(styleProperty)).getType() == AlignmentType.LEFT) {
                return 16384;
            }
            if (((VTAlignmentStyleProperty)VTAlignmentStyleProperty.class.cast(styleProperty)).getType() != AlignmentType.RIGHT) continue;
            return 131072;
        }
        return this.getDefaultAlignment();
    }

    protected int getDefaultAlignment() {
        return 16384;
    }

    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_string";
    }

    @Override
    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        if (this.isDisableRenderedAsEditable() && (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE && gridCell.getColumn() == 1 || this.hasLeftLabelAlignment() && gridCell.getColumn() == 2)) {
            Control controlToUnset = control;
            controlToUnset = this.isControlUnsettable() ? ((Composite)Composite.class.cast(((Composite)Composite.class.cast(this.getControlCompositeFromControl(control))).getChildren()[0])).getChildren()[0] : ((Composite)Composite.class.cast(control)).getChildren()[0];
            ((Text)Text.class.cast(controlToUnset)).setEditable(enabled);
        } else if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE && gridCell.getColumn() == 1 || this.hasLeftLabelAlignment() && gridCell.getColumn() == 2) {
            super.setControlEnabled(gridCell, this.getControlCompositeFromControl(control), enabled);
        } else {
            super.setControlEnabled(gridCell, control, enabled);
        }
    }

    private boolean isControlUnsettable() {
        IValueProperty valueProperty;
        try {
            valueProperty = this.getEMFFormsDatabinding().getValueProperty(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return false;
        }
        EStructuralFeature feature = (EStructuralFeature)valueProperty.getValueType();
        boolean unsettable = feature.isUnsettable();
        return unsettable;
    }

    private boolean isDisableRenderedAsEditable() {
        VTViewTemplateProvider vtViewTemplateProvider = this.getVTViewTemplateProvider();
        if (vtViewTemplateProvider == null) {
            return false;
        }
        Set styleProperties = vtViewTemplateProvider.getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTTextControlEnablementStyleProperty.class.isInstance(styleProperty)) continue;
            return ((VTTextControlEnablementStyleProperty)VTTextControlEnablementStyleProperty.class.cast(styleProperty)).isRenderDisableAsEditable();
        }
        return false;
    }

    protected String getTextFromTextField(Text text, EDataType attributeType) {
        return text.getText();
    }

    @Override
    protected String getUnsetText() {
        return LocalizationServiceHelper.getString(TextControlSWTRenderer.class, (String)"StringControl_NoTextSetClickToSetText");
    }

    @Override
    protected void setValidationColor(Control control, Color validationColor) {
        super.setValidationColor(this.getControlCompositeFromControl(control), validationColor);
    }

    @Override
    protected void setValidationForegroundColor(Control control, Color validationColor) {
        super.setValidationForegroundColor(this.getControlCompositeFromControl(control), validationColor);
    }

    protected boolean isUnsetButtonLeftOfControlComposite() {
        return this.isControlUnsettable() && this.getUnsettableStyleProperty().getButtonPlacement() == ButtonPlacementType.LEFT_OF_LABEL;
    }

    protected Control getControlCompositeFromControl(Control control) {
        if (this.isUnsetButtonLeftOfControlComposite()) {
            return ((Composite)Composite.class.cast(control)).getChildren()[1];
        }
        return ((Composite)Composite.class.cast(control)).getChildren()[0];
    }

    class EMFUpdateConvertValueStrategy
    extends EMFUpdateValueStrategy {
        EMFUpdateConvertValueStrategy() {
        }

        public Object convert(Object value) {
            return this.convertValue(value);
        }

        protected Object convertValue(Object value) {
            return super.convert(value);
        }
    }

    protected class ModelToTargetUpdateStrategy
    extends EMFUpdateConvertValueStrategy {
        private final boolean tooltip;

        public ModelToTargetUpdateStrategy(boolean tooltip) {
            this.tooltip = tooltip;
        }

        @Override
        public Object convert(Object value) {
            Object converted = this.convertValue(value);
            if (this.tooltip && String.class.isInstance(converted)) {
                IObservableValue observableValue;
                try {
                    observableValue = TextControlSWTRenderer.this.getModelValue();
                }
                catch (DatabindingFailedException ex) {
                    TextControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return converted;
                }
                InternalEObject internalEObject = (InternalEObject)((IObserving)observableValue).getObserved();
                if (internalEObject != null) {
                    EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
                    return ECPTooltipModifierHelper.modifyString((String)((String)String.class.cast(converted)), (EStructuralFeature.Setting)internalEObject.eSetting(structuralFeature));
                }
            }
            return converted;
        }
    }

    protected class TargetToModelUpdateStrategy
    extends EMFUpdateConvertValueStrategy {
        private final boolean unsetable;

        public TargetToModelUpdateStrategy(boolean unsettable) {
            this.unsetable = unsettable;
        }

        @Override
        public Object convert(Object value) {
            if ("".equals(value)) {
                value = null;
            }
            if (value == null && this.unsetable) {
                return SetCommand.UNSET_VALUE;
            }
            return this.convertValue(value);
        }
    }
}

