/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.domainexpander.defaultheuristic;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.common.RankingHelper;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="EMFFormsDomainExpanderImpl")
public class EMFFormsDomainExpanderImpl
implements EMFFormsDomainExpander {
    private final Set<EMFFormsDMRExpander> emfFormsDMRExpanders = new CopyOnWriteArraySet<EMFFormsDMRExpander>();
    private static final RankingHelper<EMFFormsDMRExpander> RANKING_HELPER = new RankingHelper(EMFFormsDMRExpander.class, EMFFormsDMRExpander.NOT_APPLICABLE.doubleValue(), EMFFormsDMRExpander.NOT_APPLICABLE);

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addEMFFormsDMRExpander(EMFFormsDMRExpander emfFormsDMRExpander) {
        this.emfFormsDMRExpanders.add(emfFormsDMRExpander);
    }

    protected void removeEMFFormsDMRExpander(EMFFormsDMRExpander emfFormsDMRExpander) {
        this.emfFormsDMRExpanders.remove(emfFormsDMRExpander);
    }

    public void prepareDomainObject(final VDomainModelReference domainModelReference, EObject domainObject) throws EMFFormsExpandingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        EMFFormsDMRExpander bestDMRExpander = (EMFFormsDMRExpander)RANKING_HELPER.getHighestRankingElement(this.emfFormsDMRExpanders, (RankingHelper.RankTester)new RankingHelper.RankTester<EMFFormsDMRExpander>(){

            public double getRank(EMFFormsDMRExpander dmrExpander) {
                return dmrExpander.isApplicable(domainModelReference);
            }
        });
        if (bestDMRExpander == null) {
            throw new EMFFormsExpandingFailedException("There is no suitable EMFFormsDMRExpander for the given domain model reference.");
        }
        bestDMRExpander.prepareDomainObject(domainModelReference, domainObject);
    }
}

