/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.style.tab.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TabType implements Enumerator
{
    BOTTOM(0, "BOTTOM", "BOTTOM"),
    TOP(1, "TOP", "TOP");

    public static final int BOTTOM_VALUE = 0;
    public static final int TOP_VALUE = 1;
    private static final TabType[] VALUES_ARRAY;
    public static final List<TabType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TabType[]{BOTTOM, TOP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TabType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TabType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TabType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TabType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TabType get(int value) {
        switch (value) {
            case 0: {
                return BOTTOM;
            }
            case 1: {
                return TOP;
            }
        }
        return null;
    }

    private TabType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

