/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.swt;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.internal.swt.Activator;
import org.eclipse.emf.ecp.view.internal.swt.ECPSWTViewImpl;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelLoadingProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.InvalidGridDescriptionReport;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ECPSWTViewRendererImpl
implements ECPSWTViewRenderer {
    private final EMFFormsRendererFactory factory = Activator.getDefault().getEMFFormsRendererFactory();

    @Override
    public ECPSWTView render(Composite parent, EObject domainObject) throws ECPRendererException {
        return this.render(parent, domainObject, ViewProviderHelper.getView((EObject)domainObject, null));
    }

    @Override
    public ECPSWTView render(Composite parent, EObject domainObject, VView viewModel) throws ECPRendererException {
        ViewModelContext viewContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)viewModel, domainObject);
        return this.render(parent, viewContext);
    }

    @Override
    public ECPSWTView render(Composite parent, ViewModelContext viewModelContext) throws ECPRendererException {
        AbstractSWTRenderer renderer;
        try {
            renderer = this.factory.getRendererInstance(viewModelContext.getViewModel(), viewModelContext);
        }
        catch (EMFFormsNoRendererException ex) {
            throw new ECPRendererException(ex.getMessage());
        }
        ReportService reportService = Activator.getDefault().getReportService();
        SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
        if (gridDescription.getGrid().size() != 1) {
            reportService.report((AbstractReport)new InvalidGridDescriptionReport("Invalid number of cells, expected exactly one cell!"));
        }
        ECPSWTViewImpl swtView = null;
        try {
            Composite composite = (Composite)renderer.render((SWTGridCell)gridDescription.getGrid().get(0), parent);
            renderer.finalizeRendering(parent);
            GridData gridData = new GridData(4, 4, true, true);
            composite.setLayoutData((Object)gridData);
            swtView = new ECPSWTViewImpl(composite, viewModelContext);
        }
        catch (NoRendererFoundException e) {
            reportService.report((AbstractReport)new RenderingFailedReport(e));
        }
        catch (NoPropertyDescriptorFoundExeption e) {
            reportService.report((AbstractReport)new RenderingFailedReport(e));
        }
        return swtView;
    }

    @Override
    @Deprecated
    public ECPSWTView render(Composite parent, EObject domainObject, Map<String, Object> context) throws ECPRendererException {
        VViewModelLoadingProperties properties = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            properties.addNonInheritableProperty(entry.getKey(), entry.getValue());
        }
        return this.render(parent, domainObject, (VViewModelProperties)properties);
    }

    @Override
    public ECPSWTView render(Composite parent, EObject domainObject, VViewModelProperties properties) throws ECPRendererException {
        if (properties == null) {
            properties = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
        }
        VView view = ViewProviderHelper.getView((EObject)domainObject, (VViewModelProperties)properties);
        return this.render(parent, domainObject, view);
    }
}

