/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.rule.model.IterateCondition;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;

public final class RuleConditionDmrUtil {
    private RuleConditionDmrUtil() {
    }

    public static Optional<EClass> getDmrRootEClass(EMFFormsDatabindingEMF databinding, ReportService reportService, EObject owner) {
        EObject testObject = owner.eContainer();
        LinkedList<IterateCondition> iterateConditions = new LinkedList<IterateCondition>();
        while (!VView.class.isInstance(testObject) && testObject != null) {
            if (testObject instanceof IterateCondition) {
                iterateConditions.add((IterateCondition)testObject);
            }
            testObject = testObject.eContainer();
        }
        if (testObject instanceof VView) {
            Collections.reverse(iterateConditions);
            EClass currentRoot = ((VView)VView.class.cast(testObject)).getRootEClass();
            for (IterateCondition condition : iterateConditions) {
                VDomainModelReference iterateDmr = condition.getItemReference();
                try {
                    IEMFValueProperty valueProperty = databinding.getValueProperty(iterateDmr, currentRoot);
                    if (valueProperty.getValueType() instanceof EReference) {
                        currentRoot = ((EReference)EReference.class.cast(valueProperty.getValueType())).getEReferenceType();
                        continue;
                    }
                    return Optional.empty();
                }
                catch (DatabindingFailedException ex) {
                    reportService.report(new AbstractReport((Throwable)ex, "Could not determine root EClass for the DMR of Condition {0}.", new Object[]{owner}));
                    return Optional.empty();
                }
            }
            return Optional.of(currentRoot);
        }
        return Optional.empty();
    }

    public static List<EObject> getDmrRootObject(EMFFormsDatabindingEMF databinding, ReportService reportService, EObject domainRoot, EObject owner) {
        EObject testObject = owner.eContainer();
        LinkedList<IterateCondition> iterateConditions = new LinkedList<IterateCondition>();
        while (!VView.class.isInstance(testObject) && testObject != null) {
            if (testObject instanceof IterateCondition) {
                iterateConditions.add((IterateCondition)testObject);
            }
            testObject = testObject.eContainer();
        }
        Collections.reverse(iterateConditions);
        List<EObject> currentRoots = Collections.singletonList(domainRoot);
        for (IterateCondition condition : iterateConditions) {
            LinkedList<EObject> newRoots = new LinkedList<EObject>();
            for (EObject currentRoot : currentRoots) {
                VDomainModelReference iterateDmr = condition.getItemReference();
                try {
                    EStructuralFeature.Setting setting = databinding.getSetting(iterateDmr, currentRoot);
                    if (setting.getEStructuralFeature() instanceof EReference) {
                        if (setting.getEStructuralFeature().isMany()) {
                            newRoots.addAll((Collection)setting.get(true));
                            continue;
                        }
                        newRoots.add((EObject)setting.get(true));
                        continue;
                    }
                    reportService.report(new AbstractReport("Could not determine root EObjects for the DMR of Condition {0} because the DMR {1} of a parent condition does not end in an EReference", new Object[]{owner, iterateDmr}));
                    return Collections.emptyList();
                }
                catch (DatabindingFailedException ex) {
                    reportService.report(new AbstractReport((Throwable)ex, "Could not determine root EObjects for the DMR of Condition {0}.", new Object[]{owner}));
                    return Collections.emptyList();
                }
            }
            currentRoots = newRoots;
        }
        return currentRoots;
    }
}

