/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.util;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPControlSWT;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTRenderingHelper;
import org.eclipse.emf.ecp.edit.spi.ECPAbstractControl;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.renderer.RenderingResultRow;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emfforms.spi.swt.core.ui.SWTValidationHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

@Deprecated
public abstract class SWTControl
extends ECPAbstractControl
implements ECPControlSWT {
    protected static final String CUSTOM_VARIANT = "org.eclipse.rap.rwt.customVariant";
    protected static final String VALIDATION_ERROR_ICON = "icons/validation_error.png";
    private static final String ICONS_UNSET_FEATURE = "icons/unset_feature.png";
    protected Label validationLabel;
    private IObservableValue modelValue;
    private Binding binding;
    private Composite controlComposite;
    private Composite parentComposite;
    private StackLayout sl;
    private Label unsetLabel;

    @Override
    public List<RenderingResultRow<Control>> createControls(Composite parent) {
        IItemPropertyDescriptor itemPropertyDescriptor = this.getItemPropertyDescriptor(this.getFirstSetting());
        if (itemPropertyDescriptor == null) {
            return null;
        }
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTControl.this.dispose();
            }
        });
        this.createValidationIcon(parent);
        List<RenderingResultRow<Control>> list = Collections.singletonList(SWTRenderingHelper.INSTANCE.getResultRowFactory().createRenderingResultRow((Object[])new Control[]{this.validationLabel, this.createControl(parent)}));
        this.applyValidation(this.getControl().getDiagnostic());
        this.backwardCompatibleHandleValidation();
        return list;
    }

    public Composite createControl(Composite parent) {
        Composite dataControl = this.createDataControl(parent);
        this.setHelpTooltips();
        this.setEditable(this.isEditable());
        this.binding = this.bindValue();
        if (!this.getFirstStructuralFeature().isUnsettable() && !this.getFirstSetting().isSet() && this.binding != null) {
            this.binding.updateTargetToModel();
        }
        return dataControl;
    }

    private void createValidationIcon(Composite composite) {
        if (!this.isEmbedded()) {
            this.validationLabel = new Label(composite, 0);
            this.validationLabel.setBackground(composite.getBackground());
        }
    }

    private Composite createDataControl(Composite composite) {
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setBackground(composite.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(innerComposite);
        this.createContentControl(innerComposite);
        return innerComposite;
    }

    private void setHelpTooltips() {
        Control[] controls = this.getControlsForTooltip();
        if (controls != null) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setToolTipText(this.getHelpText());
                ++n2;
            }
        }
    }

    protected abstract Control[] getControlsForTooltip();

    protected void createContentControl(Composite composite) {
        this.parentComposite = new Composite(composite, 0);
        this.parentComposite.setBackground(composite.getBackground());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.parentComposite);
        this.sl = new StackLayout();
        this.parentComposite.setLayout((Layout)this.sl);
        this.controlComposite = new Composite(this.parentComposite, 0);
        this.controlComposite.setBackground(this.parentComposite.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(2, 0).applyTo(this.controlComposite);
        this.unsetLabel = new Label(this.parentComposite, 0);
        this.unsetLabel.setBackground(composite.getBackground());
        this.unsetLabel.setForeground(composite.getShell().getDisplay().getSystemColor(16));
        this.unsetLabel.setAlignment(0x1000000);
        this.unsetLabel.setText(this.getUnsetLabelText());
        this.unsetLabel.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ((SWTControl)SWTControl.this).sl.topControl = SWTControl.this.controlComposite;
                SWTControl.this.parentComposite.layout(true);
                if (SWTControl.this.binding != null) {
                    SWTControl.this.binding.updateTargetToModel();
                } else {
                    EStructuralFeature.Setting firstSetting = SWTControl.this.getFirstSetting();
                    Object currentUnsetValue = firstSetting.get(true);
                    firstSetting.set(currentUnsetValue);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        int numControls = 1;
        this.fillControlComposite(this.controlComposite);
        if (!this.isEmbedded() && this.getFirstStructuralFeature().isUnsettable()) {
            Button unsetButton = this.getCustomUnsetButton();
            if (unsetButton == null) {
                ++numControls;
                unsetButton = new Button(this.controlComposite, 8);
                unsetButton.setToolTipText(this.getUnsetButtonTooltip());
                unsetButton.setImage(Activator.getImage(ICONS_UNSET_FEATURE));
            }
            unsetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EStructuralFeature.Setting firstSetting = SWTControl.this.getFirstSetting();
                    EditingDomain editingDomain = SWTControl.this.getEditingDomain(firstSetting);
                    editingDomain.getCommandStack().execute((Command)new SetCommand(editingDomain, firstSetting.getEObject(), firstSetting.getEStructuralFeature(), SetCommand.UNSET_VALUE));
                    SWTControl.this.showUnsetLabel();
                }
            });
            unsetButton.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_control_unset");
        }
        if (numControls != 1) {
            ((GridLayout)this.controlComposite.getLayout()).numColumns = numControls;
        }
        this.sl.topControl = !this.getFirstStructuralFeature().isUnsettable() || this.getFirstSetting().isSet() ? this.controlComposite : this.unsetLabel;
        this.parentComposite.layout();
    }

    protected void showUnsetLabel() {
        this.sl.topControl = this.unsetLabel;
        this.parentComposite.layout();
    }

    protected abstract void fillControlComposite(Composite var1);

    protected Button getCustomUnsetButton() {
        return null;
    }

    protected IObservableValue getModelValue() {
        if (this.modelValue != null) {
            return this.modelValue;
        }
        EStructuralFeature.Setting setting = this.getFirstSetting();
        this.modelValue = EMFEditObservables.observeValue((EditingDomain)this.getEditingDomain(setting), (EObject)setting.getEObject(), (EStructuralFeature)setting.getEStructuralFeature());
        return this.modelValue;
    }

    public void setObservableValue(IObservableValue modelValue) {
        this.modelValue = modelValue;
    }

    protected Button createButtonForAction(final Action action, final Composite composite) {
        Button selectButton = new Button(composite, 8);
        selectButton.setImage(Activator.getImage(action));
        selectButton.setEnabled(!this.getControl().isReadonly());
        selectButton.setToolTipText(action.getToolTipText());
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
                composite.layout();
            }
        });
        return selectButton;
    }

    protected abstract Binding bindValue();

    protected String getHelpText() {
        return this.getItemPropertyDescriptor(this.getFirstSetting()).getDescription(null);
    }

    protected Image getValidationIcon(int severity) {
        return SWTValidationHelper.INSTANCE.getValidationIcon(severity);
    }

    protected Color getValidationBackgroundColor(int severity) {
        return SWTValidationHelper.INSTANCE.getValidationBackgroundColor(severity);
    }

    protected abstract String getUnsetLabelText();

    protected abstract String getUnsetButtonTooltip();

    protected final Color getSystemColor(int color) {
        if (this.parentComposite == null) {
            return Display.getDefault().getSystemColor(color);
        }
        return this.parentComposite.getShell().getDisplay().getSystemColor(color);
    }

    @Deprecated
    protected boolean isEditable() {
        EStructuralFeature.Setting firstSetting = this.getFirstSetting();
        return this.getItemPropertyDescriptor(firstSetting).canSetProperty((Object)firstSetting.getEObject());
    }

    public void dispose() {
        this.validationLabel = null;
        if (this.modelValue != null) {
            this.modelValue.dispose();
            this.modelValue = null;
        }
        if (this.binding != null) {
            this.binding.dispose();
            this.binding = null;
        }
        if (this.controlComposite != null) {
            this.controlComposite.dispose();
            this.controlComposite = null;
        }
        if (this.parentComposite != null) {
            this.parentComposite.dispose();
            this.parentComposite = null;
        }
        this.sl = null;
        if (this.unsetLabel != null) {
            this.unsetLabel.dispose();
            this.unsetLabel = null;
        }
        super.dispose();
    }

    protected void backwardCompatibleHandleValidation() {
        final VDiagnostic diagnostic = this.getControl().getDiagnostic();
        if (diagnostic == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SWTControl.this.getControl() == null) {
                    return;
                }
                SWTControl.this.resetValidation();
                for (Object object : diagnostic.getDiagnostics()) {
                    SWTControl.this.handleValidation((Diagnostic)object);
                }
            }
        });
    }
}

