/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.treemasterdetail.diagnostic;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.cachetree.AbstractCachedTree;
import org.eclipse.emf.ecp.common.spi.cachetree.CachedTreeNode;
import org.eclipse.emf.ecp.common.spi.cachetree.IExcludedObjectsCallback;

public class DiagnosticCache
extends AbstractCachedTree<Diagnostic> {
    private final Set<ValidationListener> validationListeners = new CopyOnWriteArraySet<ValidationListener>();
    private ValidationChangeListener validationChangeListener;
    private Notifier input;
    private boolean initializing;

    public DiagnosticCache(Notifier input) {
        super(new IExcludedObjectsCallback(){

            public boolean isExcluded(Object object) {
                return false;
            }
        });
        this.init(input);
        LinkedHashSet<EObject> rootObjects = new LinkedHashSet<EObject>();
        if (ResourceSet.class.isInstance(input)) {
            EList resources = ((ResourceSet)ResourceSet.class.cast(input)).getResources();
            resources.stream().map(Resource::getContents).forEach(rootObjects::addAll);
        } else if (Resource.class.isInstance(input)) {
            rootObjects.addAll((Collection<EObject>)((Resource)Resource.class.cast(input)).getContents());
        } else if (EObject.class.isInstance(input)) {
            rootObjects.add((EObject)EObject.class.cast(input));
        } else {
            return;
        }
        rootObjects.forEach(this::depthFirstCacheUpdate);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(Notifier input) {
        TreeIterator allContents;
        LinkedHashSet externalReferences;
        boolean wasInitializing;
        block9: {
            wasInitializing = this.initializing;
            this.initializing = true;
            try {
                if (input == null) {
                    this.initializing = wasInitializing;
                    return;
                }
            }
            catch (Throwable throwable) {
                this.initializing = wasInitializing;
                throw throwable;
            }
            {
                Map map;
                this.input = input;
                this.validationChangeListener = new ValidationChangeListener(input);
                externalReferences = new LinkedHashSet();
                if (ResourceSet.class.isInstance(input)) {
                    ResourceSet resourceSet = (ResourceSet)ResourceSet.class.cast(input);
                    allContents = EcoreUtil.getAllContents((ResourceSet)resourceSet, (boolean)false);
                    map = EcoreUtil.ExternalCrossReferencer.find((ResourceSet)resourceSet);
                    externalReferences.addAll(map.keySet());
                    break block9;
                }
                if (Resource.class.isInstance(input)) {
                    Resource resource = (Resource)Resource.class.cast(input);
                    allContents = EcoreUtil.getAllContents((Resource)resource, (boolean)false);
                    map = EcoreUtil.ExternalCrossReferencer.find((Resource)resource);
                    externalReferences.addAll(map.keySet());
                    break block9;
                }
                if (!EObject.class.isInstance(input)) {
                    this.initializing = wasInitializing;
                    return;
                }
                Set<EObject> set = Collections.singleton((EObject)EObject.class.cast(input));
                allContents = EcoreUtil.getAllContents(set, (boolean)false);
                map = EcoreUtil.ExternalCrossReferencer.find(set);
                externalReferences.addAll(map.keySet());
            }
        }
        while (true) {
            if (!allContents.hasNext()) break;
            Object next = allContents.next();
            if (!EObject.class.isInstance(next)) continue;
            this.updateCacheWithoutRefresh((EObject)EObject.class.cast(next), this);
        }
        externalReferences.forEach(e -> this.updateCacheWithoutRefresh((EObject)e, this));
        this.initializing = wasInitializing;
    }

    private Diagnostic depthFirstCacheUpdate(EObject root) {
        CachedTreeNode treeNode = (CachedTreeNode)this.getNodes().get(root);
        if (treeNode == null) {
            return this.getDefaultValue();
        }
        root.eContents().stream().forEach(c -> treeNode.putIntoCache(c, (Object)this.depthFirstCacheUpdate((EObject)c)));
        return (Diagnostic)treeNode.getDisplayValue();
    }

    protected final boolean isInitializing() {
        return this.initializing;
    }

    public Diagnostic getDefaultValue() {
        return Diagnostic.OK_INSTANCE;
    }

    protected CachedTreeNode<Diagnostic> createdCachedTreeNode(Diagnostic value) {
        return new DiagnosticTreeNode(value);
    }

    protected void updateParentNode(Object parent, Object object, Diagnostic value) {
        if (!this.isInitializing()) {
            super.updateParentNode(parent, object, (Object)value);
        }
    }

    public Set<Object> getObjects() {
        return Collections.unmodifiableSet(new LinkedHashSet(this.getNodes().keySet()));
    }

    public Diagnostic getOwnValue(Object o) {
        if (o == null) {
            return this.getDefaultValue();
        }
        CachedTreeNode treeNode = (CachedTreeNode)this.getNodes().get(o);
        if (treeNode == null) {
            return this.getDefaultValue();
        }
        return (Diagnostic)treeNode.getOwnValue();
    }

    public void dispose() {
        this.validationChangeListener.dispose();
    }

    public void reinit(Notifier notifier) {
        if (this.input == notifier) {
            return;
        }
        this.dispose();
        this.clear();
        this.init(notifier);
    }

    public void registerValidationListener(ValidationListener listener) {
        this.validationListeners.add(listener);
    }

    public void deregisterValidationListener(ValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    protected void updateCache(EObject element, DiagnosticCache cache) {
        Diagnostic diagnostic = DiagnosticCache.getDiagnostic(element);
        Set update = cache.update(element, diagnostic);
        this.notifyValidationListeners(update, true);
    }

    protected void handleRemove(EObject object, DiagnosticCache cache) {
        LinkedHashSet<EObject> toRemove = new LinkedHashSet<EObject>();
        toRemove.add(object);
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)object, (boolean)false);
        while (iterator.hasNext()) {
            toRemove.add((EObject)iterator.next());
        }
        for (EObject eObject : toRemove) {
            cache.remove(eObject);
        }
    }

    protected static Diagnostic getDiagnostic(Object object) {
        if (!EObject.class.isInstance(object)) {
            return Diagnostic.OK_INSTANCE;
        }
        EObject eObject = (EObject)EObject.class.cast(object);
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator(eObject.eClass().getEPackage());
        BasicDiagnostic diagnostics = Diagnostician.INSTANCE.createDefaultDiagnostic(eObject);
        if (validator == null) {
            validator = new EObjectValidator();
        }
        HashMap<Class, Object> context = new HashMap<Class, Object>();
        context.put(EValidator.SubstitutionLabelProvider.class, Diagnostician.INSTANCE);
        context.put(EValidator.class, validator);
        validator.validate(eObject, (DiagnosticChain)diagnostics, context);
        return diagnostics;
    }

    protected void notifyValidationListeners(Set<EObject> updatedObjects, boolean potentialStructuralChange) {
        for (ValidationListener validationListener : this.validationListeners) {
            validationListener.revalidationOccurred(updatedObjects, potentialStructuralChange);
        }
    }

    protected void updateCacheWithoutRefresh(EObject element, DiagnosticCache cache) {
        Diagnostic diagnostic = DiagnosticCache.getDiagnostic(element);
        Set update = cache.update(element, diagnostic);
        this.notifyValidationListeners(update, false);
        this.notifyValidationListeners(Collections.singleton(element), false);
    }

    private class DiagnosticTreeNode
    extends CachedTreeNode<Diagnostic> {
        private final Set<Diagnostic> diagnosticSet;

        DiagnosticTreeNode(Diagnostic initialValue) {
            super((Object)initialValue);
            this.diagnosticSet = new TreeSet<Diagnostic>(new Comparator<Diagnostic>(){

                @Override
                public int compare(Diagnostic o1, Diagnostic o2) {
                    if (o1.getSeverity() == o2.getSeverity()) {
                        if (o1 == o2) {
                            return 0;
                        }
                        return this.getHashCode(o1) - this.getHashCode(o2);
                    }
                    return -1 * ((Integer)Integer.class.cast(o1.getSeverity())).compareTo(o2.getSeverity());
                }

                private int getHashCode(Diagnostic o) {
                    if (o.getData().isEmpty()) {
                        return 0;
                    }
                    return o.getData().hashCode();
                }
            });
        }

        public void putIntoCache(Object key, Diagnostic value) {
            boolean updateRequired = true;
            if (this.getCache().containsKey(key)) {
                Diagnostic diagnostic = (Diagnostic)this.getCache().get(key);
                if (diagnostic.getSeverity() == value.getSeverity()) {
                    updateRequired = false;
                }
                this.diagnosticSet.remove(diagnostic);
            }
            this.getCache().put(key, value);
            this.diagnosticSet.add(value);
            if (updateRequired) {
                this.update();
            }
        }

        public void update() {
            Iterator<Diagnostic> iterator = this.diagnosticSet.iterator();
            if (iterator.hasNext()) {
                Diagnostic mostSevereDiagnostic = iterator.next();
                this.setChildValue(mostSevereDiagnostic);
            } else {
                this.setChildValue(DiagnosticCache.this.getDefaultValue());
            }
        }

        public Diagnostic getDisplayValue() {
            if (this.getChildValue() == null) {
                return (Diagnostic)this.getOwnValue();
            }
            return ((Diagnostic)this.getOwnValue()).getSeverity() > ((Diagnostic)this.getChildValue()).getSeverity() ? (Diagnostic)this.getOwnValue() : (Diagnostic)this.getChildValue();
        }

        public void removeFromCache(Object key) {
            Diagnostic diagnostic = (Diagnostic)this.getCache().remove(key);
            if (diagnostic != null) {
                this.diagnosticSet.remove(diagnostic);
            }
            this.update();
        }
    }

    private final class ValidationChangeListener
    extends EContentAdapter {
        private final Notifier parent;

        ValidationChangeListener(Notifier parent) {
            this.parent = parent;
            parent.eAdapters().add((Object)this);
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.isTouch() && notification.getEventType() < 10) {
                return;
            }
            this.handleStructuralChangeNotification(notification);
            if (!EObject.class.isInstance(notification.getNotifier())) {
                return;
            }
            DiagnosticCache.this.updateCacheWithoutRefresh((EObject)EObject.class.cast(notification.getNotifier()), DiagnosticCache.this);
        }

        void dispose() {
            this.parent.eAdapters().remove((Object)this);
        }

        private void handleStructuralChangeNotification(Notification notification) {
            switch (notification.getEventType()) {
                case 4: {
                    this.handleSingleRemove(notification);
                    break;
                }
                case 6: {
                    List deleted = (List)notification.getOldValue();
                    if (deleted.isEmpty() || !EObject.class.isInstance(deleted.get(0))) break;
                    for (Object oldValue : deleted) {
                        DiagnosticCache.this.handleRemove((EObject)EObject.class.cast(oldValue), DiagnosticCache.this);
                    }
                    break;
                }
                case 3: {
                    this.handleAdd(notification);
                    break;
                }
                case 5: {
                    List added = (List)notification.getNewValue();
                    if (added.isEmpty() || !EObject.class.isInstance(added.get(0))) break;
                    for (Object newValue : added) {
                        TreeIterator iterator = EcoreUtil.getAllContents((EObject)((EObject)EObject.class.cast(newValue)), (boolean)false);
                        while (iterator.hasNext()) {
                            DiagnosticCache.this.updateCacheWithoutRefresh((EObject)iterator.next(), DiagnosticCache.this);
                        }
                        DiagnosticCache.this.updateCache((EObject)EObject.class.cast(newValue), DiagnosticCache.this);
                    }
                    break;
                }
                case 1: {
                    if (!EReference.class.isInstance(notification.getFeature()) || !((EReference)EReference.class.cast(notification.getFeature())).isContainment()) break;
                    this.handleAdd(notification);
                    break;
                }
            }
        }

        private void handleSingleRemove(Notification notification) {
            Object oldValue = notification.getOldValue();
            if (!EObject.class.isInstance(oldValue)) {
                return;
            }
            DiagnosticCache.this.handleRemove((EObject)EObject.class.cast(oldValue), DiagnosticCache.this);
        }

        private void handleAdd(Notification notification) {
            Object newValue = notification.getNewValue();
            if (!EObject.class.isInstance(newValue)) {
                return;
            }
            TreeIterator iterator = EcoreUtil.getAllContents((EObject)((EObject)EObject.class.cast(newValue)), (boolean)false);
            while (iterator.hasNext()) {
                DiagnosticCache.this.updateCacheWithoutRefresh((EObject)iterator.next(), DiagnosticCache.this);
            }
            DiagnosticCache.this.updateCache((EObject)EObject.class.cast(newValue), DiagnosticCache.this);
        }
    }

    public static interface ValidationListener {
        public void revalidationOccurred(Collection<EObject> var1, boolean var2);
    }
}

