/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core.layout;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Shell;

public final class EMFFormsSWTLayoutUtil {
    private static Set<Composite> requestedLayouts = new LinkedHashSet<Composite>();
    private static Thread thread;

    private EMFFormsSWTLayoutUtil() {
    }

    public static void adjustParentSize(Control control) {
        if (control.isDisposed()) {
            return;
        }
        Composite parent = control.getParent();
        while (parent != null) {
            if (ScrolledComposite.class.isInstance(parent)) {
                ScrolledComposite scrolledComposite = (ScrolledComposite)ScrolledComposite.class.cast(parent);
                Control content = scrolledComposite.getContent();
                if (content == null) {
                    return;
                }
                Point point = content.computeSize(-1, -1);
                scrolledComposite.setMinSize(point);
            } else if (ExpandBar.class.isInstance(parent)) {
                ExpandBar bar = (ExpandBar)ExpandBar.class.cast(parent);
                int oldBarHeight = 0;
                int barHeight = 0;
                ExpandItem[] expandItemArray = bar.getItems();
                int n = expandItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExpandItem item = expandItemArray[n2];
                    Control itemControl = item.getControl();
                    if (itemControl != null) {
                        oldBarHeight += item.getHeight();
                        int height = itemControl.computeSize((int)bar.getSize().x, (int)-1, (boolean)true).y;
                        barHeight += height;
                        item.setHeight(height);
                    }
                    ++n2;
                }
                if (bar.getItemCount() > 0) {
                    EMFFormsSWTLayoutUtil.updateLayoutData(bar.getLayoutData(), oldBarHeight, barHeight);
                }
            }
            if (parent.getParent() == null) {
                EMFFormsSWTLayoutUtil.layoutDelayed(parent);
            } else if (Shell.class.isInstance(parent)) {
                EMFFormsSWTLayoutUtil.layoutDelayed(parent);
            }
            parent = parent.getParent();
        }
    }

    private static synchronized void layoutDelayed(Composite parent) {
        EMFFormsSWTLayoutUtil.getRequestedLayouts().add(parent);
        EMFFormsSWTLayoutUtil.layoutDelayed();
    }

    private static synchronized void layoutDelayed() {
        if (thread != null || EMFFormsSWTLayoutUtil.getRequestedLayouts().isEmpty()) {
            return;
        }
        thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                final Set toLayout = EMFFormsSWTLayoutUtil.exchangeRequestedLayouts();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (Composite composite : toLayout) {
                            if (composite.isDisposed()) continue;
                            composite.layout(true, true);
                        }
                        EMFFormsSWTLayoutUtil.thread = null;
                        EMFFormsSWTLayoutUtil.layoutDelayed();
                    }
                });
            }
        });
        thread.start();
    }

    private static void updateLayoutData(Object layoutData, int oldHeight, int newHeight) {
        if (layoutData instanceof GridData) {
            int heightHint;
            GridData gridData = (GridData)layoutData;
            if (gridData.heightHint == -1) {
                return;
            }
            gridData.heightHint = heightHint = gridData.heightHint - oldHeight + newHeight;
        }
    }

    private static synchronized Set<Composite> getRequestedLayouts() {
        return requestedLayouts;
    }

    private static synchronized void setRequestedLayouts(Set<Composite> requestedLayouts) {
        EMFFormsSWTLayoutUtil.requestedLayouts = requestedLayouts;
    }

    private static synchronized Set<Composite> exchangeRequestedLayouts() {
        LinkedHashSet<Composite> toLayout = new LinkedHashSet<Composite>(EMFFormsSWTLayoutUtil.getRequestedLayouts());
        EMFFormsSWTLayoutUtil.setRequestedLayouts(new LinkedHashSet<Composite>());
        return toLayout;
    }
}

