/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.validation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.internal.ui.validation.Messages;
import org.eclipse.emf.ecp.internal.ui.validation.ValidationContentProvider;
import org.eclipse.emf.ecp.internal.ui.validation.ValidationLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public final class ValidationTreeViewerFactory {
    private ValidationTreeViewerFactory() {
    }

    public static TreeViewer createValidationViewer(Composite parent) {
        Tree validationTree = new Tree(parent, 2816);
        validationTree.setHeaderVisible(true);
        validationTree.setLinesVisible(true);
        TreeViewer treeViewer = new TreeViewer(validationTree);
        TreeColumn messageColumn = new TreeColumn(validationTree, 16384);
        messageColumn.setAlignment(16384);
        messageColumn.setText(Messages.ValidationTreeViewerFactory_Description);
        messageColumn.setWidth(600);
        TreeColumn objectColumn = new TreeColumn(validationTree, 16384);
        objectColumn.setAlignment(16384);
        objectColumn.setText(Messages.ValidationTreeViewerFactory_Object);
        objectColumn.setWidth(200);
        TreeColumn featureColumn = new TreeColumn(validationTree, 16384);
        featureColumn.setAlignment(16384);
        featureColumn.setText(Messages.ValidationTreeViewerFactory_Feature);
        featureColumn.setWidth(200);
        treeViewer.setContentProvider((IContentProvider)new ValidationContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new ValidationLabelProvider());
        ValidationTreeViewerFactory.addDoubleClickListener(treeViewer);
        return treeViewer;
    }

    private static void addDoubleClickListener(TreeViewer treeViewer) {
        IConfigurationElement[] doubleClickListener;
        IConfigurationElement[] iConfigurationElementArray = doubleClickListener = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.ui.validation.doubleClickListener");
        int n = doubleClickListener.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            doubleClickListener = null;
            try {
                IDoubleClickListener dcl = (IDoubleClickListener)element.createExecutableExtension("class");
                treeViewer.addDoubleClickListener(dcl);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
    }
}

