/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.common.converter;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emfforms.common.RankingHelper;
import org.eclipse.emfforms.spi.common.converter.EStructuralFeatureValueConverter;
import org.eclipse.emfforms.spi.common.converter.EStructuralFeatureValueConverterService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={EStructuralFeatureValueConverterService.class})
public class EStructuralFeatureValueConverterServiceImpl
implements EStructuralFeatureValueConverterService {
    private final Set<EStructuralFeatureValueConverter> converters = new LinkedHashSet<EStructuralFeatureValueConverter>();
    private static final RankingHelper<EStructuralFeatureValueConverter> RANKING_HELPER = new RankingHelper(EStructuralFeatureValueConverter.class, -1.0, -1.0);

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void addValueConverter(EStructuralFeatureValueConverter converter) {
        this.converters.add(converter);
    }

    @Override
    public void removeValueConverter(EStructuralFeatureValueConverter converter) {
        this.converters.remove(converter);
    }

    private EStructuralFeatureValueConverter getHighestRankingConverter(final EObject eObject, final EStructuralFeature feature, final Object value, final EStructuralFeatureValueConverter.Direction direction) {
        return RANKING_HELPER.getHighestRankingElement(this.converters, new RankingHelper.RankTester<EStructuralFeatureValueConverter>(){

            @Override
            public double getRank(EStructuralFeatureValueConverter converter) {
                return converter.isApplicable(eObject, feature, value, direction);
            }
        });
    }

    @Override
    public Object convertToModelValue(EObject eObject, EStructuralFeature feature, String literal) {
        EStructuralFeatureValueConverter converter = this.getHighestRankingConverter(eObject, feature, literal, EStructuralFeatureValueConverter.Direction.LITERAL_TO_MODEL);
        if (converter == null) {
            return null;
        }
        return converter.convertToModelValue(eObject, feature, literal);
    }

    @Override
    public Object convertToLiteral(EObject eObject, EStructuralFeature feature, Object instance) {
        EStructuralFeatureValueConverter converter = this.getHighestRankingConverter(eObject, feature, instance, EStructuralFeatureValueConverter.Direction.MODEL_TO_LITERAL);
        if (converter == null) {
            return null;
        }
        return converter.convertToLiteral(eObject, feature, instance);
    }
}

