/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.databinding.index;

import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.databinding.internal.EMFValuePropertyDecorator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.internal.core.services.databinding.index.EMFIndexedValueProperty;
import org.eclipse.emfforms.internal.core.services.databinding.index.EMFIndexedValuePropertyDelegator;
import org.eclipse.emfforms.internal.core.services.databinding.index.IllegalListTypeException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;

public class IndexDomainModelReferenceConverter
implements DomainModelReferenceConverterEMF {
    private EMFFormsDatabindingEMF emfFormsDatabinding;
    private ServiceReference<EMFFormsDatabindingEMF> databindingServiceReference;
    private BundleContext bundleContext;

    void setEMFFormsDatabinding(EMFFormsDatabindingEMF emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    void unsetEMFFormsDatabinding() {
        this.emfFormsDatabinding = null;
    }

    @Activate
    protected final void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected final void deactivate(BundleContext bundleContext) {
        if (this.databindingServiceReference != null) {
            bundleContext.ungetService(this.databindingServiceReference);
            this.unsetEMFFormsDatabinding();
        }
    }

    private EMFFormsDatabindingEMF getEMFFormsDatabindingEMF() {
        if (this.emfFormsDatabinding == null) {
            this.databindingServiceReference = this.bundleContext.getServiceReference(EMFFormsDatabindingEMF.class);
            if (this.databindingServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDatabindingEMF available!");
            }
            this.setEMFFormsDatabinding((EMFFormsDatabindingEMF)this.bundleContext.getService(this.databindingServiceReference));
        }
        return this.emfFormsDatabinding;
    }

    public double isApplicable(VDomainModelReference domainModelReference) {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (domainModelReference instanceof VIndexDomainModelReference) {
            return 10.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public IEMFValueProperty convertToValueProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        if (object == null) {
            return this.convertToValueProperty(domainModelReference, null, null);
        }
        EditingDomain editingDomain = this.getEditingDomain(object);
        return this.convertToValueProperty(domainModelReference, object.eClass(), editingDomain);
    }

    public IEMFValueProperty convertToValueProperty(VDomainModelReference domainModelReference, EClass rootEClass, EditingDomain editingDomain) throws DatabindingFailedException {
        return this.internalConvertToValueProperty(domainModelReference, rootEClass, editingDomain);
    }

    private IEMFValueProperty internalConvertToValueProperty(VDomainModelReference domainModelReference, EClass rootEClass, EditingDomain editingDomain) throws DatabindingFailedException {
        EMFValuePropertyDecorator valueProperty;
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VIndexDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VIndexDomainModelReference.");
        }
        VIndexDomainModelReference indexReference = (VIndexDomainModelReference)VIndexDomainModelReference.class.cast(domainModelReference);
        if (indexReference.getPrefixDMR() != null) {
            IEMFValueProperty prefixProperty = rootEClass != null ? this.getEMFFormsDatabindingEMF().getValueProperty(indexReference.getPrefixDMR(), rootEClass, editingDomain) : this.getEMFFormsDatabindingEMF().getValueProperty(indexReference.getPrefixDMR(), null);
            valueProperty = new EMFValuePropertyDecorator((IValueProperty)new EMFIndexedValuePropertyDelegator(editingDomain, indexReference.getIndex(), (IValueProperty)prefixProperty, prefixProperty.getStructuralFeature()), prefixProperty.getStructuralFeature());
        } else {
            if (indexReference.getDomainModelEFeature() == null) {
                throw new DatabindingFailedException("The field domainModelEFeature of the given VIndexDomainModelReference must not be null.");
            }
            this.checkListType(indexReference.getDomainModelEFeature());
            EList referencePath = indexReference.getDomainModelEReferencePath();
            EMFValuePropertyDecorator indexedValueProperty = new EMFValuePropertyDecorator((IValueProperty)new EMFIndexedValueProperty(editingDomain, indexReference.getIndex(), indexReference.getDomainModelEFeature()), indexReference.getDomainModelEFeature());
            if (referencePath.isEmpty()) {
                valueProperty = indexedValueProperty;
            } else {
                IEMFEditValueProperty emfValueProperty = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)((EStructuralFeature)referencePath.get(0)));
                int i = 1;
                while (i < referencePath.size()) {
                    emfValueProperty = emfValueProperty.value((EStructuralFeature)referencePath.get(i));
                    ++i;
                }
                valueProperty = emfValueProperty.value((IEMFValueProperty)indexedValueProperty);
            }
        }
        EClass targetDmrRootEClass = ((EReference)EReference.class.cast(valueProperty.getValueType())).getEReferenceType();
        IEMFValueProperty targetValueProperty = this.getEMFFormsDatabindingEMF().getValueProperty(indexReference.getTargetDMR(), targetDmrRootEClass, editingDomain);
        return valueProperty.value(targetValueProperty);
    }

    public IEMFListProperty convertToListProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        EMFValuePropertyDecorator valueProperty;
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VIndexDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VIndexDomainModelReference.");
        }
        VIndexDomainModelReference indexReference = (VIndexDomainModelReference)VIndexDomainModelReference.class.cast(domainModelReference);
        if (indexReference.getPrefixDMR() != null) {
            IEMFValueProperty prefixProperty = this.getEMFFormsDatabindingEMF().getValueProperty(indexReference.getPrefixDMR(), object);
            valueProperty = new EMFValuePropertyDecorator((IValueProperty)new EMFIndexedValuePropertyDelegator(this.getEditingDomain(object), indexReference.getIndex(), (IValueProperty)prefixProperty, prefixProperty.getStructuralFeature()), prefixProperty.getStructuralFeature());
        } else {
            if (indexReference.getDomainModelEFeature() == null) {
                throw new DatabindingFailedException("The field domainModelEFeature of the given VIndexDomainModelReference must not be null.");
            }
            this.checkListType(indexReference.getDomainModelEFeature());
            EList referencePath = indexReference.getDomainModelEReferencePath();
            EMFValuePropertyDecorator indexedValueProperty = new EMFValuePropertyDecorator((IValueProperty)new EMFIndexedValueProperty(this.getEditingDomain(object), indexReference.getIndex(), indexReference.getDomainModelEFeature()), indexReference.getDomainModelEFeature());
            if (referencePath.isEmpty()) {
                valueProperty = indexedValueProperty;
            } else {
                IEMFEditValueProperty emfValueProperty = EMFEditProperties.value((EditingDomain)this.getEditingDomain(object), (EStructuralFeature)((EStructuralFeature)referencePath.get(0)));
                int i = 1;
                while (i < referencePath.size()) {
                    emfValueProperty = emfValueProperty.value((EStructuralFeature)referencePath.get(i));
                    ++i;
                }
                valueProperty = emfValueProperty.value((IEMFValueProperty)indexedValueProperty);
            }
        }
        return valueProperty.list(this.getEMFFormsDatabindingEMF().getListProperty(indexReference.getTargetDMR(), object));
    }

    private void checkListType(EStructuralFeature structuralFeature) throws IllegalListTypeException {
        if (!structuralFeature.isMany()) {
            throw new IllegalListTypeException("The VIndexDomainModelReference's domainModelEFeature must reference a list.");
        }
        if (!EReference.class.isInstance(structuralFeature)) {
            throw new IllegalListTypeException("The VIndexDomainModelReference's domainModelEFeature must reference a list of EObjects.");
        }
    }

    private EditingDomain getEditingDomain(EObject object) throws DatabindingFailedException {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
    }

    public EStructuralFeature.Setting getSetting(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        EList eList;
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VIndexDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VIndexDomainModelReference.");
        }
        VIndexDomainModelReference indexDMR = (VIndexDomainModelReference)VIndexDomainModelReference.class.cast(domainModelReference);
        if (indexDMR.getPrefixDMR() == null) {
            if (indexDMR.getDomainModelEFeature() == null) {
                throw new DatabindingFailedException("The field domainModelEFeature of the given VIndexDomainModelReference must not be null.");
            }
            this.checkListType(indexDMR.getDomainModelEFeature());
            EObject currentObject = object;
            for (EReference eReference : indexDMR.getDomainModelEReferencePath()) {
                if ((currentObject = (EObject)currentObject.eGet((EStructuralFeature)eReference)) != null) continue;
                throw new DatabindingFailedException("The path is not fully resolved.");
            }
            eList = (EList)currentObject.eGet(indexDMR.getDomainModelEFeature());
        } else {
            EStructuralFeature.Setting setting = this.getEMFFormsDatabindingEMF().getSetting(indexDMR.getPrefixDMR(), object);
            eList = (EList)setting.get(true);
        }
        if (eList.isEmpty()) {
            throw new DatabindingFailedException("The list used by the index dmr mustr must not be empty.");
        }
        EObject eObject = (EObject)eList.get(indexDMR.getIndex());
        return this.getEMFFormsDatabindingEMF().getSetting(indexDMR.getTargetDMR(), eObject);
    }
}

