/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.treemasterdetail.actions;

import org.eclipse.emfforms.spi.swt.treemasterdetail.actions.MasterDetailAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public abstract class KeybindedMasterDetailAction
extends MasterDetailAction
implements KeyListener,
ISelectionChangedListener {
    private TreeViewer registeredTreeViewer;
    private ISelection currentSelection;
    private boolean executeOnKeyRelease;

    @Override
    public void setTreeViewer(TreeViewer treeviewer) {
        super.setTreeViewer(treeviewer);
        if (this.registeredTreeViewer != null) {
            this.registeredTreeViewer.getTree().removeKeyListener((KeyListener)this);
            this.registeredTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        treeviewer.getTree().addKeyListener((KeyListener)this);
        treeviewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.registeredTreeViewer = treeviewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.currentSelection = event.getSelection();
    }

    protected ISelection getCurrentSelection() {
        return this.currentSelection;
    }

    public void keyPressed(KeyEvent event) {
        this.setExecuteOnKeyRelease(this.isExecuteOnKeyRelease(event));
        if (this.isExecuteOnKeyPressed(event)) {
            this.executeOnKeyPressed(this.currentSelection);
        }
    }

    protected boolean isExecuteOnKeyPressed(KeyEvent event) {
        return false;
    }

    protected void executeOnKeyPressed(ISelection currentSelection) {
    }

    public void keyReleased(KeyEvent event) {
        if (this.isExecuteOnKeyRelease()) {
            this.executeOnKeyRelease(this.currentSelection);
        }
        this.setExecuteOnKeyRelease(false);
    }

    protected abstract boolean isExecuteOnKeyRelease(KeyEvent var1);

    protected abstract void executeOnKeyRelease(ISelection var1);

    protected static boolean isActivated(KeyEvent event, int swtMask, char c) {
        return (event.stateMask & swtMask) == swtMask && event.keyCode == c;
    }

    protected boolean isExecuteOnKeyRelease() {
        return this.executeOnKeyRelease;
    }

    protected void setExecuteOnKeyRelease(boolean executeOnKeyRelease) {
        this.executeOnKeyRelease = executeOnKeyRelease;
    }
}

