/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.rule.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CompareType implements Enumerator
{
    EQUALS(0, "EQUALS", "EQUALS"),
    NOT_EQUALS(1, "NOT_EQUALS", "NOT_EQUALS");

    public static final int EQUALS_VALUE = 0;
    public static final int NOT_EQUALS_VALUE = 1;
    private static final CompareType[] VALUES_ARRAY;
    public static final List<CompareType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CompareType[]{EQUALS, NOT_EQUALS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CompareType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompareType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompareType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompareType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompareType get(int value) {
        switch (value) {
            case 0: {
                return EQUALS;
            }
            case 1: {
                return NOT_EQUALS;
            }
        }
        return null;
    }

    private CompareType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

