/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.refactoring;

import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.view.model.presentation.ContributionUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;

public class ViewModelDeleteParticipant
extends DeleteParticipant {
    private static final Pattern EMPTY_PLUGIN_PATTERN = Pattern.compile("<plugin>\\s*</plugin>", 42);
    private static final String EMPTY_STRING = "";
    private static final Pattern EMPTY_XMI_EXTENSIONPOINT = Pattern.compile("<extension.*point=\"org.eclipse.emf.ecp.view.model.provider.xmi.file\">\\s*</extension>", 42);
    private static final String ONE_LINE_FILE = "<file filePath=\"%s\"/>";
    private static final String MULTI_LINE_FILE = "<file\\s*filePath=\"%s\">\\s*</file>";
    private static final String REMOVE_PLUGIN_XML = "plugin.xml,?\\\\?\\s*";
    private static final String REMOVE_FOLDER = "%s/,?\\\\?\\s*";
    private static final String REMOVE_VIEW = "%s,?\\\\?\\s*";
    private static final String CLEAN_PLUGIN_XML = ",\\\\\\s*$";
    private IFile viewModel;
    private IFile pluginXml;

    protected boolean initialize(Object element) {
        this.viewModel = (IFile)Adapters.adapt((Object)element, IFile.class);
        this.pluginXml = this.viewModel.getProject().getFile("plugin.xml");
        return this.viewModel != null && this.pluginXml.exists();
    }

    public String getName() {
        return "Clean up after View Model Removal";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        ResourceChangeChecker resourceChecker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        if (resourceChecker != null) {
            try {
                RefactoringStatus result = resourceChecker.check(pm);
                String projectInfo = "Remove view model from plugin.xml";
                result.addInfo("Remove view model from plugin.xml");
                return result;
            }
            catch (CoreException e) {
                return RefactoringStatus.create((IStatus)e.getStatus());
            }
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new ChangeExtension();
    }

    private final class ChangeExtension
    extends Change {
        private ChangeExtension() {
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            try {
                String pluginString = ContributionUtil.parseIFile(ViewModelDeleteParticipant.this.pluginXml).get();
                String viewPath = ViewModelDeleteParticipant.this.viewModel.getProjectRelativePath().toString();
                String cleanExtensionString = pluginString.replaceAll(String.format(ViewModelDeleteParticipant.ONE_LINE_FILE, viewPath), ViewModelDeleteParticipant.EMPTY_STRING).replaceAll(String.format(ViewModelDeleteParticipant.MULTI_LINE_FILE, viewPath), ViewModelDeleteParticipant.EMPTY_STRING);
                String cleanPlugin = EMPTY_XMI_EXTENSIONPOINT.matcher(cleanExtensionString).replaceAll(ViewModelDeleteParticipant.EMPTY_STRING);
                Matcher matcher = EMPTY_PLUGIN_PATTERN.matcher(cleanPlugin);
                boolean removePluginXml = false;
                if (!matcher.find()) {
                    FileWriter out = new FileWriter(ViewModelDeleteParticipant.this.pluginXml.getRawLocation().makeAbsolute().toFile());
                    out.write(String.valueOf(cleanPlugin));
                    out.close();
                } else {
                    ViewModelDeleteParticipant.this.pluginXml.delete(true, pm);
                    removePluginXml = true;
                }
                boolean removeFolder = false;
                if (ViewModelDeleteParticipant.this.viewModel.getParent().members().length == 0) {
                    ViewModelDeleteParticipant.this.viewModel.getParent().delete(true, pm);
                    removeFolder = true;
                }
                IFile buildProperties = ViewModelDeleteParticipant.this.viewModel.getProject().getFile("build.properties");
                String buildPropertiesString = ContributionUtil.parseIFile(buildProperties).get();
                String cleanedProperties = null;
                if (removePluginXml || removeFolder) {
                    if (removePluginXml) {
                        cleanedProperties = buildPropertiesString.replaceAll(ViewModelDeleteParticipant.REMOVE_PLUGIN_XML, ViewModelDeleteParticipant.EMPTY_STRING);
                    }
                    if (removeFolder) {
                        cleanedProperties = (cleanedProperties != null ? cleanedProperties : buildPropertiesString).replaceAll(String.format(ViewModelDeleteParticipant.REMOVE_FOLDER, ViewModelDeleteParticipant.this.viewModel.getParent().getProjectRelativePath().toString()), ViewModelDeleteParticipant.EMPTY_STRING);
                    }
                }
                cleanedProperties = (cleanedProperties != null ? cleanedProperties : buildPropertiesString).replaceAll(String.format(ViewModelDeleteParticipant.REMOVE_VIEW, ViewModelDeleteParticipant.this.viewModel.getProjectRelativePath().toString()), ViewModelDeleteParticipant.EMPTY_STRING);
                cleanedProperties = cleanedProperties.replaceAll(ViewModelDeleteParticipant.CLEAN_PLUGIN_XML, ViewModelDeleteParticipant.EMPTY_STRING);
                FileWriter out = new FileWriter(buildProperties.getRawLocation().makeAbsolute().toFile());
                out.write(String.valueOf(cleanedProperties));
                out.flush();
                out.close();
                ViewModelDeleteParticipant.this.viewModel.getProject().refreshLocal(2, null);
            }
            catch (IOException ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.ecp.view.model.editor", ex.getMessage(), (Throwable)ex));
            }
            return null;
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public String getName() {
            return "Remove view model from plugin.xml";
        }

        public Object getModifiedElement() {
            return null;
        }
    }
}

