/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.common.util.Diagnostic;

public final class DiagnosticMessageExtractor {
    private DiagnosticMessageExtractor() {
    }

    public static String getMessage(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 0) {
            return "";
        }
        if (diagnostic.getChildren() != null && diagnostic.getChildren().size() == 0) {
            return diagnostic.getMessage();
        }
        StringBuilder sb = new StringBuilder();
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(childDiagnostic.getMessage());
        }
        return sb.toString();
    }

    public static String getMessage(Collection<Diagnostic> diagnostics) {
        ArrayList<Diagnostic> diagnosticList = new ArrayList<Diagnostic>(diagnostics);
        Collections.sort(diagnosticList, new Comparator<Diagnostic>(){

            @Override
            public int compare(Diagnostic o1, Diagnostic o2) {
                if (o1.getSeverity() != o2.getSeverity()) {
                    return o2.getSeverity() - o1.getSeverity();
                }
                return o1.getMessage().compareTo(o2.getMessage());
            }
        });
        StringBuilder sb = new StringBuilder();
        for (Diagnostic diagnostic : diagnosticList) {
            if (diagnostic.getSeverity() == 0) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(DiagnosticMessageExtractor.getMessage(diagnostic));
        }
        return sb.toString();
    }
}

