/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.ui.search;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.ui.util.ECPHandlerHelper;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class SearchModelElementHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        InternalProject project = (InternalProject)ECPUtil.getECPProjectManager().getProject(selection.getFirstElement());
        ESLocalProject projectSpace = EMFStoreProvider.INSTANCE.getProjectSpace(project);
        if (projectSpace == null) {
            return null;
        }
        Set eObjects = projectSpace.getAllModelElements();
        if (project == null) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Information", (String)"You must first select the Project.");
        } else {
            Object[] selections;
            ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
            AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (ILabelProvider)adapterFactoryLabelProvider);
            dialog.setElements(eObjects.toArray());
            dialog.setMultipleSelection(false);
            dialog.setMessage("Enter model element name prefix or pattern (e.g. *Trun?)");
            dialog.setTitle("Search Model Element");
            if (dialog.open() == 0 && (selections = dialog.getResult()) != null && selections.length == 1 && selections[0] instanceof EObject) {
                ECPHandlerHelper.openModelElement((Object)selections[0], (ECPProject)project);
            }
            adapterFactoryLabelProvider.dispose();
            composedAdapterFactory.dispose();
        }
        return null;
    }
}

