/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.rule.RuleService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.rule.RuleServiceHelper;

public class RuleServiceHelperImpl
implements ViewModelService,
RuleServiceHelper {
    private ViewModelContext context;

    @Override
    public <T extends VElement> Set<T> getInvolvedEObjects(EStructuralFeature.Setting setting, Object newValue, EAttribute attribute, Class<T> renderableClass) {
        LinkedHashMap<EStructuralFeature.Setting, Object> newValues = new LinkedHashMap<EStructuralFeature.Setting, Object>();
        newValues.put(setting, newValue);
        Map<VElement, Boolean> disabledRenderables = ((RuleService)this.context.getService(RuleService.class)).getDisabledRenderables(newValues, attribute);
        Map<VElement, Boolean> hiddenRenderables = ((RuleService)this.context.getService(RuleService.class)).getHiddenRenderables(newValues, attribute);
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        result.addAll(this.collectFalseValues(renderableClass, disabledRenderables, this.createDisabledRenderablePredicate()));
        result.addAll(this.collectFalseValues(renderableClass, hiddenRenderables, this.createHiddenRenderablePredicate()));
        return result;
    }

    private RenderablePredicate createDisabledRenderablePredicate() {
        return new RenderablePredicate(){

            @Override
            public boolean checkCurrentState(VElement renderable) {
                return renderable.isEnabled();
            }
        };
    }

    private RenderablePredicate createHiddenRenderablePredicate() {
        return new RenderablePredicate(){

            @Override
            public boolean checkCurrentState(VElement renderable) {
                return renderable.isVisible();
            }
        };
    }

    @Override
    public <T extends VElement> Set<T> getInvolvedEObjects(Map<EStructuralFeature.Setting, Object> possibleNewValues, EAttribute changedAttribute, Class<T> renderableClass) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        Map<VElement, Boolean> hiddenRenderables = ((RuleService)this.context.getService(RuleService.class)).getHiddenRenderables(possibleNewValues, changedAttribute);
        Map<VElement, Boolean> disabledRenderables = ((RuleService)this.context.getService(RuleService.class)).getDisabledRenderables(possibleNewValues, changedAttribute);
        result.addAll(this.collectFalseValues(renderableClass, disabledRenderables, this.createDisabledRenderablePredicate()));
        result.addAll(this.collectFalseValues(renderableClass, hiddenRenderables, this.createHiddenRenderablePredicate()));
        return result;
    }

    private <T extends VElement> Set<T> collectFalseValues(Class<T> cls, Map<VElement, Boolean> renderableToStateMapping, RenderablePredicate renderablePredicate) {
        LinkedHashSet<VElement> result = new LinkedHashSet<VElement>();
        block0: for (Map.Entry<VElement, Boolean> entry : renderableToStateMapping.entrySet()) {
            VElement renderable = entry.getKey();
            Boolean newState = entry.getValue();
            if (newState.booleanValue() || renderablePredicate.checkCurrentState(renderable) == newState.booleanValue()) continue;
            if (cls.isInstance(renderable)) {
                result.add(renderable);
                continue;
            }
            EObject parent = renderable.eContainer();
            while (parent != null) {
                if (cls.isInstance(parent)) {
                    result.add((VElement)parent);
                    continue block0;
                }
                parent = parent.eContainer();
            }
        }
        return result;
    }

    public void instantiate(ViewModelContext context) {
        this.context = context;
    }

    public void dispose() {
    }

    public int getPriority() {
        return 2;
    }

    private static interface RenderablePredicate {
        public boolean checkCurrentState(VElement var1);
    }
}

