/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.migration.BackwardConverter;

public class MaterializingBackwardConverter
extends BackwardConverter {
    protected EClass resolveEClass(EClass eClass) {
        return (EClass)this.resolveEClassifier((EClassifier)eClass);
    }

    private EClassifier resolveEClassifier(EClassifier classifier) {
        EPackage sourcePackage = classifier.getEPackage();
        EPackage targetPackage = EPackage.Registry.INSTANCE.getEPackage(sourcePackage.getNsURI());
        return targetPackage.getEClassifier(classifier.getName());
    }

    protected EStructuralFeature resolveFeature(EStructuralFeature feature) {
        EClass sourceClass = feature.getEContainingClass();
        EClass targetClass = this.resolveEClass(sourceClass);
        return targetClass.getEStructuralFeature(feature.getName());
    }

    protected Enumerator resolveLiteral(EEnumLiteral literal) {
        EEnum sourceEnum = literal.getEEnum();
        String value = sourceEnum.getEPackage().getEFactoryInstance().convertToString((EDataType)sourceEnum, (Object)literal);
        EEnum targetEnum = (EEnum)this.resolveEClassifier((EClassifier)sourceEnum);
        return (Enumerator)targetEnum.getEPackage().getEFactoryInstance().createFromString((EDataType)targetEnum, value);
    }
}

