/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.history.reconstruction.EcoreReconstructorSwitchBase;
import org.eclipse.emf.edapt.history.recorder.IChangeProvider;
import org.eclipse.emf.edapt.internal.common.MetamodelExtent;
import org.eclipse.emf.edapt.spi.history.Add;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.CompositeChange;
import org.eclipse.emf.edapt.spi.history.Create;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.MigrationChange;
import org.eclipse.emf.edapt.spi.history.Move;
import org.eclipse.emf.edapt.spi.history.PrimitiveChange;
import org.eclipse.emf.edapt.spi.history.Remove;
import org.eclipse.emf.edapt.spi.history.Set;
import org.eclipse.emf.edapt.spi.history.ValueChange;
import org.eclipse.emf.edit.command.ChangeCommand;

public class UndoChangesCommand
extends ChangeCommand
implements IChangeProvider {
    private final List<Change> changes;
    private final UndoSwitch undoSwitch;

    public UndoChangesCommand(List<Change> changes, MetamodelExtent extent) {
        super(UndoChangesCommand.getNotifiers(changes, extent));
        this.changes = changes;
        this.undoSwitch = new UndoSwitch();
    }

    private static Collection<Notifier> getNotifiers(List<Change> changes, MetamodelExtent extent) {
        HashSet<Notifier> notifiers = new HashSet<Notifier>();
        notifiers.addAll(extent.getRootPackages());
        for (Change change : changes) {
            notifiers.add((Notifier)change.getRelease().getHistory());
        }
        return notifiers;
    }

    protected void doExecute() {
        Collections.reverse(this.changes);
        for (Change change : this.changes) {
            this.undoSwitch.doSwitch((EObject)change);
            EcoreUtil.delete((EObject)change);
        }
    }

    public List<Change> getChanges(List<PrimitiveChange> changes) {
        return Collections.emptyList();
    }

    private class UndoSwitch
    extends EcoreReconstructorSwitchBase<Object> {
        private UndoSwitch() {
        }

        public Object caseSet(Set set) {
            this.set(set.getElement(), set.getFeature(), set.getOldValue());
            return set;
        }

        public Object caseAdd(Add add) {
            this.remove(add.getElement(), add.getFeature(), add.getValue());
            return add;
        }

        public Object caseRemove(Remove remove) {
            this.add(remove.getElement(), remove.getFeature(), remove.getValue());
            return remove;
        }

        public Object caseCreate(Create create) {
            this.delete(create.getElement());
            return create;
        }

        public Object caseDelete(Delete delete) {
            this.add(delete.getTarget(), (EStructuralFeature)delete.getReference(), delete.getElement());
            for (ValueChange change : delete.getChanges()) {
                this.doSwitch((EObject)change);
            }
            return delete;
        }

        public Object caseMove(Move move) {
            this.add(move.getSource(), (EStructuralFeature)move.getReference(), move.getElement());
            return move;
        }

        public Object caseCompositeChange(CompositeChange compositeChange) {
            EList changes = compositeChange.getChanges();
            int i = changes.size() - 1;
            while (i >= 0) {
                this.doSwitch((EObject)changes.get(i));
                --i;
            }
            return compositeChange;
        }

        public Object caseMigrationChange(MigrationChange migrationChange) {
            EList changes = migrationChange.getChanges();
            int i = changes.size() - 1;
            while (i >= 0) {
                this.doSwitch((EObject)changes.get(i));
                --i;
            }
            return migrationChange;
        }
    }
}

