/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.inheritedapi_servlet;

import ee.jakarta.tck.concurrent.common.CommonTasks;
import ee.jakarta.tck.concurrent.common.fixed.counter.CounterRunnableTask;
import ee.jakarta.tck.concurrent.common.fixed.counter.StaticCounter;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import jakarta.servlet.annotation.WebServlet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.testng.Assert;

@WebServlet(value={"/InheritedAPIServlet"})
public class InheritedAPIServlet
extends TestServlet {
    @Override
    protected void before() {
        StaticCounter.reset();
    }

    public void testApiSubmit() throws Exception {
        Future result = TestUtil.getManagedScheduledExecutorService().submit((Callable)new CommonTasks.SimpleCallable());
        TestUtil.waitTillFutureIsDone(result);
        Assert.assertEquals(result.get(), (Object)"ok");
        result = TestUtil.getManagedScheduledExecutorService().submit((Runnable)new CommonTasks.SimpleRunnable());
        TestUtil.waitTillFutureIsDone(result);
        result.get();
        result = TestUtil.getManagedScheduledExecutorService().submit((Runnable)new CommonTasks.SimpleRunnable(), (Object)"ok");
        TestUtil.waitTillFutureIsDone(result);
        Assert.assertEquals(result.get(), (Object)"ok");
    }

    public void testApiExecute() throws Exception {
        TestUtil.getManagedScheduledExecutorService().execute((Runnable)new CounterRunnableTask());
        this.waitForCounter(1);
    }

    public void testApiInvokeAll() throws Exception {
        ArrayList<Callable> taskList = new ArrayList<Callable>();
        taskList.add(new CommonTasks.SimpleArgCallable(1));
        taskList.add(new CommonTasks.SimpleArgCallable(2));
        taskList.add(new CommonTasks.SimpleArgCallable(3));
        List resultList = TestUtil.getManagedScheduledExecutorService().invokeAll(taskList);
        for (Future each : resultList) {
            TestUtil.waitTillFutureIsDone(each);
        }
        Assert.assertEquals(((Future)resultList.get(0)).get(), (Object)1);
        Assert.assertEquals(((Future)resultList.get(1)).get(), (Object)2);
        Assert.assertEquals(((Future)resultList.get(2)).get(), (Object)3);
        resultList = TestUtil.getManagedScheduledExecutorService().invokeAll(taskList, TestConstants.WaitTimeout.getSeconds(), TimeUnit.SECONDS);
        for (Future each : resultList) {
            TestUtil.waitTillFutureIsDone(each);
        }
        Assert.assertEquals(((Future)resultList.get(0)).get(), (Object)1);
        Assert.assertEquals(((Future)resultList.get(1)).get(), (Object)2);
        Assert.assertEquals(((Future)resultList.get(2)).get(), (Object)3);
        try {
            taskList = new ArrayList();
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.WaitTimeout.toMillis()));
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.WaitTimeout.toMillis()));
            resultList = TestUtil.getManagedScheduledExecutorService().invokeAll(taskList, TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
            for (Future each : resultList) {
                TestUtil.waitTillFutureThrowsException(each, CancellationException.class);
            }
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    public void testApiInvokeAny() throws Exception {
        ArrayList<Callable> taskList = new ArrayList<Callable>();
        taskList.add(new CommonTasks.SimpleArgCallable(1));
        taskList.add(new CommonTasks.SimpleArgCallable(2));
        taskList.add(new CommonTasks.SimpleArgCallable(3));
        Object result = TestUtil.getManagedScheduledExecutorService().invokeAny(taskList);
        TestUtil.assertInRange(new Integer[]{1, 2, 3}, result);
        result = TestUtil.getManagedScheduledExecutorService().invokeAny(taskList, TestConstants.WaitTimeout.getSeconds(), TimeUnit.SECONDS);
        TestUtil.assertInRange(new Integer[]{1, 2, 3}, result);
        try {
            taskList = new ArrayList();
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.WaitTimeout.toMillis()));
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.WaitTimeout.toMillis()));
            result = TestUtil.getManagedScheduledExecutorService().invokeAny(taskList, TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return;
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.fail((String)"Task should be cancelled because of timeout");
    }

    public void testApiSchedule() throws Exception {
        ScheduledFuture result = TestUtil.getManagedScheduledExecutorService().schedule((Callable)new CommonTasks.SimpleCallable(), TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
        TestUtil.waitTillFutureIsDone(result);
        Assert.assertEquals(result.get(), (Object)"ok");
        result = TestUtil.getManagedScheduledExecutorService().schedule((Runnable)new CommonTasks.SimpleRunnable(), TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
        TestUtil.waitTillFutureIsDone(result);
        Assert.assertEquals(result.get(), null);
    }

    public void testApiScheduleAtFixedRate() throws Exception {
        Future result = null;
        try {
            result = TestUtil.getManagedScheduledExecutorService().scheduleAtFixedRate((Runnable)new CounterRunnableTask(), TestConstants.PollInterval.getSeconds(), TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
            TestUtil.sleep(TestConstants.WaitTimeout);
            TestUtil.assertIntInRange(TestConstants.PollsPerTimeout - 2, TestConstants.PollsPerTimeout + 2, StaticCounter.getCount());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (result != null) {
                result.cancel(true);
                try {
                    TestUtil.sleep(TestConstants.PollInterval);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void testApiScheduleWithFixedDelay() throws Exception {
        Future result = null;
        try {
            result = TestUtil.getManagedScheduledExecutorService().scheduleWithFixedDelay((Runnable)new CounterRunnableTask(TestConstants.PollInterval.toMillis()), TestConstants.PollInterval.getSeconds(), TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
            TestUtil.sleep(TestConstants.WaitTimeout);
            TestUtil.assertIntInRange(TestConstants.PollsPerTimeout / 2 - 2, TestConstants.PollsPerTimeout / 2 + 2, StaticCounter.getCount());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (result != null) {
                result.cancel(true);
                try {
                    TestUtil.sleep(TestConstants.PollInterval);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void waitForCounter(int expected) {
        long start = System.currentTimeMillis();
        while (expected != StaticCounter.getCount()) {
            try {
                TestUtil.sleep(TestConstants.PollInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= TestConstants.WaitTimeout.toMillis()) continue;
            throw new RuntimeException("Static counter did not produce expected counter before timeout. Expected: " + expected + " Actual: " + StaticCounter.getCount());
        }
    }
}

