/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.SkippedException;

import ee.jakarta.tck.concurrent.framework.ArquillianTests;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import jakarta.enterprise.concurrent.SkippedException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class SkippedExceptionTests
extends ArquillianTests {
    private static final TestLogger log = TestLogger.get(SkippedExceptionTests.class);

    @Deployment(name="SkippedExceptionTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{SkippedExceptionTests.getFrameworkPackage(), SkippedExceptionTests.class.getPackage()});
    }

    @Test
    public void SkippedExceptionNoArgTest() {
        boolean pass = false;
        try {
            throw new SkippedException();
        }
        catch (SkippedException se) {
            log.info("SkippedException Caught as Expected");
            if (se.getMessage() == null) {
                log.info("Received expected null message");
                pass = true;
            } else {
                log.warning("SkippedException should have had null message, actual message=" + se.getMessage());
            }
        }
        catch (Exception e) {
            log.warning("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void SkippedExceptionStringTest() {
        boolean pass = false;
        String expected = "thisisthedetailmessage";
        try {
            throw new SkippedException(expected);
        }
        catch (SkippedException se) {
            log.info("SkippedException Caught as Expected");
            if (se.getMessage().equals(expected)) {
                log.info("Received expected message");
                pass = true;
            } else {
                log.info("Expected:" + expected + ", actual message=" + se.getMessage());
            }
        }
        catch (Exception e) {
            log.warning("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void SkippedExceptionThrowableTest() {
        Throwable cause;
        boolean pass1 = false;
        boolean pass2 = false;
        Throwable expected = new Throwable("thisisthethrowable");
        try {
            throw new SkippedException(expected);
        }
        catch (SkippedException se) {
            log.info("SkippedException Caught as Expected");
            cause = se.getCause();
            if (cause.equals(expected)) {
                log.info("Received expected cause");
                pass1 = true;
            } else {
                log.info("Expected:" + expected + ", actual message=" + cause);
            }
        }
        catch (Exception e) {
            log.warning("Unexpected Exception Caught", e);
        }
        expected = null;
        try {
            throw new SkippedException(expected);
        }
        catch (SkippedException se) {
            log.info("SkippedException Caught as Expected");
            cause = se.getCause();
            if (cause == null) {
                log.info("Received expected null cause");
                pass2 = true;
            } else {
                log.info("Expected:null, actual message=" + cause);
            }
        }
        catch (Exception e) {
            log.warning("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass1);
        this.assertTrue(pass2);
    }

    @Test
    public void SkippedExceptionStringThrowableTest() {
        Throwable cause;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        String sExpected = "thisisthedetailmessage";
        Throwable tExpected = new Throwable("thisisthethrowable");
        try {
            throw new SkippedException(sExpected, tExpected);
        }
        catch (SkippedException se) {
            log.info("SkippedException Caught as Expected");
            if (se.getMessage().equals(sExpected)) {
                log.info("Received expected message");
                pass1 = true;
            } else {
                log.info("Expected:" + sExpected + ", actual message=" + se.getMessage());
            }
            cause = se.getCause();
            if (cause.equals(tExpected)) {
                log.info("Received expected cause");
                pass2 = true;
            } else {
                log.info("Expected:" + tExpected + ", actual message=" + cause);
            }
        }
        catch (Exception e) {
            log.warning("Unexpected Exception Caught", e);
        }
        tExpected = null;
        try {
            throw new SkippedException(sExpected, tExpected);
        }
        catch (SkippedException se) {
            log.info("SkippedException Caught as Expected");
            if (se.getMessage().equals(sExpected)) {
                log.info("Received expected message");
                pass3 = true;
            } else {
                log.info("Expected:" + sExpected + ", actual message=" + se.getMessage());
            }
            cause = se.getCause();
            if (cause == null) {
                log.info("Received expected null cause");
                pass4 = true;
            } else {
                log.info("Expected:null, actual message=" + cause);
            }
        }
        catch (Exception e) {
            log.warning("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass1);
        this.assertTrue(pass2);
        this.assertTrue(pass3);
        this.assertTrue(pass4);
    }
}

