/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.utilities;

import ee.jakarta.tck.data.framework.utilities.TestProperty;
import java.time.Duration;
import java.util.logging.Logger;

public class TestPropertyUtility {
    private static final Logger log = Logger.getLogger(TestPropertyUtility.class.getCanonicalName());

    private TestPropertyUtility() {
    }

    public static boolean skipDeployment() {
        return Boolean.valueOf(TestProperty.skipDeployment.getValue());
    }

    public static void waitForEventualConsistency() {
        if (!TestProperty.delay.isSet()) {
            return;
        }
        Duration delay = Duration.ofSeconds(TestProperty.delay.getLong());
        try {
            Thread.sleep(delay.toMillis());
        }
        catch (InterruptedException e) {
            log.warning("Did not wait full duration of " + delay.toMillis() + "ms for eventual consistency due to interruption: " + e.getLocalizedMessage());
        }
    }
}

