/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipalDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.ResourceReference;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.Descriptor;

public class ResourceReferenceDescriptor
extends EnvironmentProperty
implements NamedDescriptor,
ResourceReference {
    private static final long serialVersionUID = 1L;
    public static final String APPLICATION_AUTHORIZATION = "Application";
    public static final String CONTAINER_AUTHORIZATION = "Container";
    public static final String RESOURCE_SHAREABLE = "Shareable";
    public static final String RESOURCE_UNSHAREABLE = "Unshareable";
    private static final String URL_RESOURCE_TYPE = "java.net.URL";
    private static final String CONNECTOR_RESOURCE_TYPE = "jakarta.resource.cci.ConnectionFactory";
    private static final String MAIL_RESOURCE_TYPE = "jakarta.mail.Session";
    private static final String JDBC_RESOURCE_TYPE = "javax.sql.DataSource";
    private static final String ORB_RESOURCE_TYPE = "org.omg.CORBA.ORB";
    private static final String WEBSERVICE_CONTEXT_TYPE = "jakarta.xml.ws.WebServiceContext";
    private String type;
    private ResourcePrincipalDescriptor resourcePrincipalDescriptor;
    private MailConfiguration mailConfiguration;
    private String authorization;
    private DataSource dataSource;
    private String sharingScope;
    private List<NameValuePairDescriptor> runtimeProps;
    boolean createTablesAtDeploy;
    boolean dropTablesAtUndeploy;
    private String databaseVendorName;
    private Properties schemaGeneratorProperties;
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(ResourceReferenceDescriptor.class);

    public ResourceReferenceDescriptor(String name, String description, String type) {
        super(name, "", description);
        this.type = type;
    }

    public ResourceReferenceDescriptor() {
    }

    @Override
    public SimpleJndiName getJndiName() {
        String jndiName = super.getValue();
        if (!jndiName.isEmpty()) {
            return new SimpleJndiName(jndiName);
        }
        if (this.mappedName != null && !this.mappedName.isEmpty()) {
            return this.mappedName;
        }
        return this.lookupName;
    }

    @Override
    public void setJndiName(SimpleJndiName jndiName) {
        super.setValue(jndiName == null ? null : jndiName.toString());
    }

    @Override
    public String getInjectResourceType() {
        return this.type;
    }

    @Override
    public void setInjectResourceType(String resourceType) {
        this.type = resourceType;
    }

    public boolean hasSharingScope() {
        return this.sharingScope != null;
    }

    public String getSharingScope() {
        if (this.sharingScope == null) {
            return RESOURCE_SHAREABLE;
        }
        return this.sharingScope;
    }

    public void setSharingScope(String sharingScope) {
        this.sharingScope = sharingScope;
    }

    public boolean isResolved() {
        return true;
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public boolean isContainerAuthorization() {
        return this.getAuthorization().equals(CONTAINER_AUTHORIZATION);
    }

    @Override
    public String getAuthorization() {
        if (this.authorization == null) {
            this.authorization = APPLICATION_AUTHORIZATION;
        }
        return this.authorization;
    }

    @Override
    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public DataSource getJDBCDataSource() {
        if (this.dataSource == null) {
            try {
                InitialContext ctx = new InitialContext();
                this.dataSource = (DataSource)ctx.lookup(this.getJndiName().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dataSource;
    }

    public boolean isWebServiceContext() {
        return this.getType().equals(WEBSERVICE_CONTEXT_TYPE);
    }

    public boolean isORB() {
        return this.getType().equals(ORB_RESOURCE_TYPE);
    }

    public boolean isMailResource() {
        return this.getType().equals(MAIL_RESOURCE_TYPE);
    }

    public boolean isJDBCResource() {
        return this.getType().equals(JDBC_RESOURCE_TYPE);
    }

    public boolean isURLResource() {
        return this.getType() != null && this.getType().equals(URL_RESOURCE_TYPE);
    }

    public boolean isJMSConnectionFactory() {
        String myType = this.getType();
        return myType.equals("jakarta.jms.QueueConnectionFactory") || myType.equals("jakarta.jms.TopicConnectionFactory");
    }

    public ResourcePrincipalDescriptor getResourcePrincipal() {
        return this.resourcePrincipalDescriptor;
    }

    public void setResourcePrincipal(ResourcePrincipalDescriptor resourcePrincipalDescriptor) {
        this.resourcePrincipalDescriptor = resourcePrincipalDescriptor;
    }

    public void setMailConfiguration(MailConfiguration mailConfiguration) {
        this.mailConfiguration = mailConfiguration;
    }

    public void addProperty(NameValuePairDescriptor newProp) {
        if (this.runtimeProps == null) {
            this.runtimeProps = new ArrayList<NameValuePairDescriptor>();
        }
        this.runtimeProps.add(newProp);
    }

    public Iterator<NameValuePairDescriptor> getProperties() {
        if (this.runtimeProps == null) {
            return null;
        }
        return this.runtimeProps.iterator();
    }

    public MailConfiguration getMailConfiguration() {
        return this.mailConfiguration;
    }

    public boolean isCreateTablesAtDeploy() {
        return this.createTablesAtDeploy;
    }

    public void setCreateTablesAtDeploy(boolean createTablesAtDeploy) {
        this.createTablesAtDeploy = createTablesAtDeploy;
    }

    public boolean isDropTablesAtUndeploy() {
        return this.dropTablesAtUndeploy;
    }

    public void setDropTablesAtUndeploy(boolean dropTablesAtUndeploy) {
        this.dropTablesAtUndeploy = dropTablesAtUndeploy;
    }

    public String getDatabaseVendorName() {
        return this.databaseVendorName;
    }

    public void setDatabaseVendorName(String vendorName) {
        this.databaseVendorName = vendorName;
    }

    public Properties getSchemaGeneratorProperties() {
        return this.schemaGeneratorProperties;
    }

    public void setSchemaGeneratorProperties(Properties props) {
        this.schemaGeneratorProperties = props;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ResourceReference) {
            ResourceReference resourceReference = (ResourceReference)object;
            return resourceReference.getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.getName());
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        StringBuffer sb = toStringBuffer;
        sb.append("Res-Ref-Env-Property: ");
        sb.append(super.getName());
        sb.append("@");
        sb.append(this.getType());
        sb.append("@");
        sb.append(this.getDescription());
        if (this.isResolved()) {
            sb.append(" resolved as: jndi: ");
            sb.append(this.getJndiName());
            sb.append("@res principal: ");
            sb.append((Object)this.getResourcePrincipal());
            sb.append("@mail: ");
            sb.append(this.getMailConfiguration());
        }
        if (this.runtimeProps != null) {
            for (NameValuePairDescriptor runtimeProp : this.runtimeProps) {
                sb.append("\nPropery : ");
                sb.append((Object)runtimeProp);
            }
        } else {
            sb.append("\nNo Runtime properties");
        }
        sb.append("\nDatabase Vendor : " + this.databaseVendorName);
        sb.append("\nCreate Tables at Deploy : " + this.createTablesAtDeploy);
        sb.append("\nDelete Tables at Undeploy : " + this.dropTablesAtUndeploy);
        if (this.schemaGeneratorProperties != null) {
            sb.append("\nSchema Generator Properties : ");
            sb.append(this.schemaGeneratorProperties);
        }
    }

    public boolean isResourceConnectionFactory() {
        return this.getType().equals(CONNECTOR_RESOURCE_TYPE);
    }

    public void checkType() {
        block5: {
            if (this.type == null) {
                if (Descriptor.isBoundsChecking()) {
                    throw new IllegalArgumentException(I18N.getLocalString("enterprise.deployment.exceptiontypenotallowedpropertytype", "{0} is not an allowed property value type", new Object[]{"null"}));
                }
            } else {
                try {
                    Class.forName(this.type, true, Thread.currentThread().getContextClassLoader());
                }
                catch (Throwable t) {
                    if (!Descriptor.isBoundsChecking()) break block5;
                    throw new IllegalArgumentException(I18N.getLocalString("enterprise.deployment.exceptiontypenotallowedpropertytype", "{0} is not an allowed property value type", new Object[]{this.type}));
                }
            }
        }
    }

    public boolean isConflict(ResourceReferenceDescriptor other) {
        return this.getName().equals(other.getName()) && (!DOLUtils.equals(this.getType(), other.getType()) || !this.getAuthorization().equals(other.getAuthorization()) || !this.getSharingScope().equals(other.getSharingScope()) || this.isConflictResourceGroup(other));
    }
}

