/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ReferenceKeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.ResultDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.RetrieveDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.Concurrency;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.Constraint;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintField;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldName;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldNameSubQuery;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintForeignFieldName;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintJoin;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintNode;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintSubquery;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.CorrelatedExistSelectPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.CorrelatedInSelectPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.VerificationSelectPlan;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.ColumnElement;

public class SelectQueryPlan
extends QueryPlan {
    private static final int ST_JOINED = 2;
    public static final int ST_C_BUILT = 4;
    public static final int ST_OC_BUILT = 16;
    protected Constraint constraint;
    public int options;
    private Iterator fieldIterator;
    private int aggregateResultType;
    private ArrayList foreignPlans;
    protected ForeignFieldDesc parentField;
    private boolean prefetched;
    private Concurrency concurrency;
    private BitSet hierarchicalGroupMask;
    private BitSet independentGroupMask;
    private BitSet fieldMask;
    private Map foreignConstraintPlans;
    private ResultDesc resultDesc;
    private boolean appendAndOp;
    private static final Logger logger = LogHelperSQLStore.getLogger();
    public static final String MULTILEVEL_PREFETCH_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.MULTILEVEL_PREFETCH";
    private static final boolean MULTILEVEL_PREFETCH = Boolean.valueOf(System.getProperty("com.sun.jdo.spi.persistence.support.sqlstore.MULTILEVEL_PREFETCH", "false"));

    public static SelectQueryPlan newInstance(RetrieveDescImpl desc, SQLStoreManager store, Concurrency concurrency) {
        SelectQueryPlan plan = null;
        plan = (desc.getOptions() & 0x1000) > 0 ? new VerificationSelectPlan(desc, store) : new SelectQueryPlan(desc, store, concurrency);
        return plan;
    }

    public SelectQueryPlan(ActionDesc desc, SQLStoreManager store, Concurrency concurrency) {
        super(desc, store);
        this.action = 4;
        this.fieldMask = new BitSet();
        this.hierarchicalGroupMask = new BitSet();
        this.independentGroupMask = new BitSet();
        this.concurrency = concurrency;
        if (!(desc instanceof RetrieveDescImpl)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", desc.getClass().getName(), "RetrieveDescImpl"));
        }
        RetrieveDescImpl retrieveDesc = (RetrieveDescImpl)desc;
        retrieveDesc.setPlan(this);
        this.constraint = retrieveDesc.getConstraint();
        this.options = retrieveDesc.getOptions();
        this.fieldIterator = retrieveDesc.getFields();
        this.aggregateResultType = retrieveDesc.getAggregateResultType();
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    private void setFieldMask(int index) {
        if (index < 0) {
            index = this.config.fields.size() - index;
        }
        this.fieldMask.set(index);
    }

    private boolean getFieldMask(int index) {
        if (index < 0) {
            index = this.config.fields.size() - index;
        }
        return this.fieldMask.get(index);
    }

    protected void addTable(LocalFieldDesc fieldDesc) {
        this.addColumn(fieldDesc, false, false);
    }

    protected void addColumn(LocalFieldDesc fieldDesc) {
        this.addColumn(fieldDesc, true, false);
    }

    private void addColumn(LocalFieldDesc fieldDesc, boolean add, boolean projection) {
        Iterator iter = fieldDesc.getColumnElements();
        while (iter.hasNext()) {
            SelectStatement statement;
            ColumnElement columnElement = (ColumnElement)iter.next();
            QueryTable table = this.findQueryTable(columnElement.getDeclaringTable());
            if (table == null) {
                table = this.addQueryTable(columnElement.getDeclaringTable(), null);
            }
            if ((statement = (SelectStatement)this.getStatement(table)) == null) {
                statement = (SelectStatement)this.addStatement(table);
            }
            if (!add) continue;
            ColumnRef columnRef = statement.addColumn(columnElement, table);
            if (this.resultDesc == null) {
                this.resultDesc = new ResultDesc(this.config, this.aggregateResultType);
            }
            this.resultDesc.addField(fieldDesc, columnRef, projection);
        }
    }

    private void processForeignFields(ArrayList foreignFields, ArrayList localFields) {
        if (foreignFields.size() == 0) {
            return;
        }
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processforeignfield", (Object)this.config.getPersistenceCapableClass().getName());
        }
        this.foreignPlans = new ArrayList();
        for (int i = 0; i < foreignFields.size(); ++i) {
            this.processForeignField((ConstraintFieldName)foreignFields.get(i), localFields);
        }
        if (debug) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processforeignfield.exit");
        }
    }

    private void processForeignField(ConstraintFieldName cfn, ArrayList localFields) {
        SelectQueryPlan fp = new SelectQueryPlan(cfn.desc, this.store, this.concurrency);
        fp.prefetched = cfn.isPrefetched();
        if (fp.prefetched) {
            fp.options |= 0x200;
        }
        fp.processParentField(this.config, cfn.name);
        fp.build();
        for (int i = 0; i < fp.parentField.localFields.size(); ++i) {
            LocalFieldDesc la = (LocalFieldDesc)fp.parentField.localFields.get(i);
            if (this.getFieldMask(la.absoluteID)) continue;
            if ((this.options & 0x200) > 0) {
                localFields.add(la);
                continue;
            }
            this.addTable(la);
        }
        this.foreignPlans.add(fp);
    }

    private boolean getGroupMask(int groupID) {
        if (groupID >= 1) {
            return this.hierarchicalGroupMask.get(groupID);
        }
        if (groupID < 0) {
            return this.independentGroupMask.get(-(groupID + 1));
        }
        return true;
    }

    private void setGroupMask(int groupID) {
        if (groupID >= 1) {
            this.hierarchicalGroupMask.set(groupID);
        } else if (groupID < 0) {
            this.independentGroupMask.set(-(groupID + 1));
        }
    }

    private void addFetchGroup(int groupID, ArrayList localFields, ArrayList foreignFields) {
        assert ((this.options & 0x200) > 0);
        ArrayList group = this.config.getFetchGroup(groupID);
        this.setGroupMask(groupID);
        if (group != null) {
            for (int i = 0; i < group.size(); ++i) {
                FieldDesc f = (FieldDesc)group.get(i);
                if (this.getFieldMask(f.absoluteID)) continue;
                boolean isLocalField = f instanceof LocalFieldDesc;
                this.setFieldMask(f.absoluteID);
                if (isLocalField) {
                    if ((this.options & 0x400) != 0 && !f.isKeyField()) continue;
                    int indexToInsert = f.isKeyField() ? 0 : localFields.size();
                    localFields.add(indexToInsert, f);
                    continue;
                }
                if ((this.options & 1) <= 0 && !MULTILEVEL_PREFETCH || (this.options & 0x400) != 0 || (this.options & 0x800) != 0) continue;
                ForeignFieldDesc ff = (ForeignFieldDesc)f;
                RetrieveDescImpl desc = (RetrieveDescImpl)this.store.getRetrieveDesc(ff.foreignConfig.getPersistenceCapableClass());
                foreignFields.add(new ConstraintFieldName(ff.getName(), desc, true));
            }
        }
    }

    private void addFetchGroups(int groupID, ArrayList localFields, ArrayList foreignFields) {
        if (groupID >= 1) {
            for (int i = 1; i <= groupID; ++i) {
                if (this.getGroupMask(i)) continue;
                this.addFetchGroup(i, localFields, foreignFields);
            }
        } else if (groupID < 0) {
            if (!this.getGroupMask(1)) {
                this.addFetchGroup(1, localFields, foreignFields);
            }
            if (!this.getGroupMask(groupID)) {
                this.addFetchGroup(groupID, localFields, foreignFields);
            }
        }
    }

    private void processFetchGroups(ArrayList localFields, ArrayList foreignFields) {
        if ((this.options & 0x200) > 0) {
            int requestedItems = localFields.size() + foreignFields.size();
            if (!this.getGroupMask(1)) {
                this.addFetchGroups(1, localFields, foreignFields);
            }
            if (requestedItems > 0) {
                int i;
                for (i = 0; i < localFields.size(); ++i) {
                    FieldDesc f = (FieldDesc)localFields.get(i);
                    this.setFieldMask(f.absoluteID);
                    if (f.fetchGroup == 0 || this.getGroupMask(f.fetchGroup)) continue;
                    this.addFetchGroups(f.fetchGroup, localFields, foreignFields);
                }
                for (i = 0; i < foreignFields.size(); ++i) {
                    ConstraintFieldName cfn = (ConstraintFieldName)foreignFields.get(i);
                    FieldDesc f = this.config.getField(cfn.name);
                    this.setFieldMask(f.absoluteID);
                    if (f.fetchGroup == 0 || this.getGroupMask(f.fetchGroup)) continue;
                    this.addFetchGroups(f.fetchGroup, localFields, foreignFields);
                }
            }
        }
    }

    private void processLocalFields(ArrayList localFields, LocalFieldDesc projectionField) {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processlocalfield", (Object)this.config.getPersistenceCapableClass().getName());
        }
        for (int i = 0; i < localFields.size(); ++i) {
            LocalFieldDesc lf;
            this.addColumn(lf, true, projectionField == (lf = (LocalFieldDesc)localFields.get(i)));
        }
        if (debug) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processlocalfield.exit");
        }
    }

    private void joinSecondaryTableStatement(SelectStatement statement, SelectStatement secondaryTableStatement) {
        statement.copyColumns(secondaryTableStatement);
        QueryTable secondaryTable = (QueryTable)secondaryTableStatement.getQueryTables().get(0);
        ReferenceKeyDesc key = secondaryTable.getTableDesc().getPrimaryTableKey();
        this.addJoinConstraint(this, this, key.getReferencedKey().getColumns(), key.getReferencingKey().getColumns(), 16);
        secondaryTableStatement.markJoined();
    }

    private void processRelatedStatements(SelectStatement statement) {
        ArrayList secondaryTableStatements = statement.getSecondaryTableStatements();
        if (secondaryTableStatements != null) {
            for (int i = 0; i < secondaryTableStatements.size(); ++i) {
                SelectStatement secondaryTableStatement = (SelectStatement)secondaryTableStatements.get(i);
                if (secondaryTableStatement.isJoined()) continue;
                this.processRelatedStatements(secondaryTableStatement);
                this.joinSecondaryTableStatement(statement, secondaryTableStatement);
            }
            secondaryTableStatements.clear();
        }
    }

    @Override
    protected void processStatements() {
        int size;
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{this.config.getPersistenceCapableClass().getName(), new Integer(this.statements.size())};
            logger.finest("sqlstore.sql.generator.selectqueryplan.processstmts", items);
        }
        if (this.concurrency != null) {
            this.concurrency.select(this);
        }
        if ((size = this.statements.size()) > 1) {
            SelectStatement s;
            int i;
            super.processStatements();
            for (i = 0; i < size; ++i) {
                s = (SelectStatement)this.statements.get(i);
                if (s.isJoined()) continue;
                this.processRelatedStatements(s);
            }
            for (i = 0; i < this.statements.size(); ++i) {
                s = (SelectStatement)this.statements.get(i);
                if (!s.isJoined()) continue;
                this.statements.remove(i);
                --i;
            }
        }
        if (debug) {
            logger.finest("sqlstore.sql.generator.selectqueryplan.processstmts.exit");
        }
    }

    private void processLocalConstraints() {
        List stack = this.constraint.getConstraints();
        for (int i = 0; i < stack.size(); ++i) {
            FieldDesc field;
            ConstraintNode node = (ConstraintNode)stack.get(i);
            if (!(node instanceof ConstraintFieldName)) continue;
            ConstraintFieldName fieldNode = (ConstraintFieldName)node;
            if (fieldNode.originalPlan != null) continue;
            SelectQueryPlan thePlan = null;
            if (fieldNode.desc == null) {
                thePlan = this;
            } else {
                RetrieveDescImpl rd = (RetrieveDescImpl)fieldNode.desc;
                thePlan = this.newForeignConstraintPlan(rd, fieldNode.name);
            }
            fieldNode.originalPlan = thePlan;
            if (fieldNode.name == null || !((field = thePlan.config.getField(fieldNode.name)) instanceof LocalFieldDesc)) continue;
            thePlan.addTable((LocalFieldDesc)field);
        }
    }

    private SelectQueryPlan newForeignConstraintPlan(RetrieveDescImpl rd, String fieldName) {
        SelectQueryPlan fcp = rd.getPlan();
        if (fcp == null) {
            fcp = new SelectQueryPlan(rd, this.store, null);
        }
        if (fieldName == null) {
            return fcp;
        }
        if (this.foreignConstraintPlans == null) {
            this.foreignConstraintPlans = new HashMap();
        }
        SelectQueryPlan masterPlan = null;
        Object tag = rd.getNavigationalId() != null ? rd.getNavigationalId() : fieldName;
        masterPlan = (SelectQueryPlan)this.foreignConstraintPlans.get(tag);
        if (masterPlan != null) {
            fcp.tables = masterPlan.tables;
            fcp.foreignConstraintPlans = masterPlan.foreignConstraintPlans;
        } else {
            this.foreignConstraintPlans.put(tag, fcp);
            fcp.foreignConstraintPlans = new HashMap();
        }
        return fcp;
    }

    private void addCorrelatedExistsQuery(ForeignFieldDesc ff, int operation) {
        Class classType = ff.cardinalityUPB > 1 ? ff.getComponentType() : ff.getType();
        RetrieveDescImpl rd = (RetrieveDescImpl)this.store.getRetrieveDesc(classType);
        CorrelatedExistSelectPlan subqueryPlan = new CorrelatedExistSelectPlan(rd, this.store, ff, this);
        subqueryPlan.build();
        this.addQueryTables(subqueryPlan.tables);
        ConstraintSubquery subqueryConstraint = new ConstraintSubquery();
        subqueryConstraint.operation = operation;
        subqueryConstraint.plan = subqueryPlan;
        this.constraint.stack.add(subqueryConstraint);
    }

    private void processForeignConstraints() {
        List currentStack = this.constraint.getConstraints();
        this.constraint.stack = new ArrayList();
        for (int index = 0; index < currentStack.size(); ++index) {
            ConstraintNode node = (ConstraintNode)currentStack.get(index);
            if (node instanceof ConstraintForeignFieldName) {
                this.processForeignFieldConstraint((ConstraintForeignFieldName)node);
                continue;
            }
            if (node instanceof ConstraintFieldName) {
                index = this.processLocalFieldConstraint((ConstraintFieldName)node, currentStack, index);
                continue;
            }
            if (node instanceof ConstraintFieldNameSubQuery) {
                this.addCorrelatedInQuery((ConstraintFieldNameSubQuery)node);
                continue;
            }
            this.constraint.stack.add(node);
        }
    }

    private void processForeignFieldConstraint(ConstraintForeignFieldName node) {
        RetrieveDescImpl rd = (RetrieveDescImpl)node.desc;
        if (rd == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "sqlstore.constraint.noretrievedesc", node.name, this.config.getPersistenceCapableClass().getName()));
        }
        SelectQueryPlan fcp = this.newForeignConstraintPlan(rd, node.name);
        if ((fcp.status & 2) == 0) {
            fcp.processParentField(this.config, node.name);
            this.processJoin(fcp, 10);
            fcp.appendAndOp = true;
        } else {
            fcp.appendAndOp = false;
        }
    }

    private int processLocalFieldConstraint(ConstraintFieldName node, List currentStack, int index) {
        if (node.desc != null) {
            SelectQueryPlan fcp = ((RetrieveDescImpl)node.desc).getPlan();
            this.constraint.stack.add(node);
            if ((fcp.status & 2) == 0) {
                fcp.appendAndOp = true;
            } else {
                this.constraint.stack.add(currentStack.get(++index));
                this.constraint.stack.add(currentStack.get(++index));
                if (fcp.appendAndOp) {
                    this.constraint.addOperation(3);
                    fcp.appendAndOp = false;
                }
            }
        } else {
            index = this.processForeignFieldNullComparision(node, currentStack, index);
        }
        return index;
    }

    private int processForeignFieldNullComparision(ConstraintFieldName node, List currentStack, int index) {
        FieldDesc f;
        boolean addCurrentNode = true;
        if (node.name != null && (f = this.config.getField(node.name)) instanceof ForeignFieldDesc && index + 1 < currentStack.size()) {
            ConstraintNode nextNode;
            if ((nextNode = (ConstraintNode)currentStack.get(++index)) instanceof ConstraintOperation && (((ConstraintOperation)nextNode).operation == 28 || ((ConstraintOperation)nextNode).operation == 27)) {
                this.processNullConstraint((ForeignFieldDesc)f, nextNode);
            } else {
                this.constraint.stack.add(node);
                this.constraint.stack.add(nextNode);
            }
            addCurrentNode = false;
        }
        if (addCurrentNode) {
            this.constraint.stack.add(node);
        }
        return index;
    }

    private void processNullConstraint(ForeignFieldDesc ff, ConstraintNode nextNode) {
        if (ff.hasForeignKey()) {
            ArrayList localFields = ff.getLocalFields();
            for (int j = 0; j < localFields.size(); ++j) {
                this.constraint.stack.add(new ConstraintFieldDesc((LocalFieldDesc)localFields.get(j)));
                this.constraint.stack.add(nextNode);
            }
        } else {
            int subOp = 45;
            if (((ConstraintOperation)nextNode).operation == 27) {
                subOp = 46;
            }
            this.addCorrelatedExistsQuery(ff, subOp);
        }
    }

    private void addCorrelatedInQuery(ConstraintFieldNameSubQuery node) {
        FieldDesc field = this.config.getField(node.fieldName);
        RetrieveDescImpl rd = (RetrieveDescImpl)node.desc;
        if (field != null && field instanceof ForeignFieldDesc) {
            ForeignFieldDesc ff = (ForeignFieldDesc)field;
            if (ff.getComponentType() != rd.getPersistenceCapableClass()) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.unknownfield", node.fieldName, rd.getPersistenceCapableClass().getName()));
            }
            CorrelatedInSelectPlan subqueryPlan = new CorrelatedInSelectPlan(rd, this.store, ff, this);
            subqueryPlan.build();
            this.addQueryTables(subqueryPlan.tables);
            ConstraintSubquery subqueryConstraint = new ConstraintSubquery();
            subqueryConstraint.plan = subqueryPlan;
            this.constraint.stack.add(subqueryConstraint);
            ArrayList localFields = ff.getLocalFields();
            for (int i = 0; i < localFields.size(); ++i) {
                this.constraint.addField((LocalFieldDesc)localFields.get(i), this);
            }
        } else {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.unknownfield", node.fieldName, rd.getPersistenceCapableClass().getName()));
        }
    }

    private void processUnboundConstraints() {
        List currentStack = this.constraint.getConstraints();
        this.constraint.stack = new ArrayList();
        for (int i = 0; i < currentStack.size(); ++i) {
            ConstraintNode node = (ConstraintNode)currentStack.get(i);
            if (node instanceof ConstraintFieldName) {
                ConstraintFieldName fieldNode = (ConstraintFieldName)node;
                if (fieldNode.name != null) {
                    this.constraint.stack.add(fieldNode);
                    continue;
                }
                if (fieldNode.desc == null) continue;
                SelectQueryPlan fcp = ((RetrieveDescImpl)fieldNode.desc).getPlan();
                if ((fcp.status & 2) != 0) continue;
                fcp.appendAndOp = false;
                this.processJoin(fcp, 52);
                continue;
            }
            this.constraint.stack.add(node);
        }
    }

    private void processJoin(SelectQueryPlan fcp, int joinOp) {
        fcp.processConstraints();
        this.doJoin(fcp, joinOp);
    }

    private void processParentField(ClassDesc parentConfig, String fieldName) {
        if (this.parentField == null) {
            ColumnElement col;
            int i;
            FieldDesc f = parentConfig.getField(fieldName);
            if (f == null || !(f instanceof ForeignFieldDesc)) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.unknownfield", fieldName, parentConfig.getPersistenceCapableClass().getName()));
            }
            this.parentField = (ForeignFieldDesc)f;
            if (this.parentField.useJoinTable()) {
                for (i = 0; i < this.parentField.assocLocalColumns.size(); ++i) {
                    col = (ColumnElement)this.parentField.assocLocalColumns.get(i);
                    this.addQueryTable(col.getDeclaringTable(), this.config);
                }
            }
            for (i = 0; i < this.parentField.foreignColumns.size(); ++i) {
                col = (ColumnElement)this.parentField.foreignColumns.get(i);
                this.addQueryTable(col.getDeclaringTable(), this.config);
            }
        }
    }

    @Override
    public void build() {
        if ((this.status & 1) > 0) {
            return;
        }
        this.processFields();
        this.processConstraints();
        this.processJoins();
        this.processOrderConstraints();
        this.status |= 1;
    }

    protected void processFields() {
        ArrayList foreignFields = new ArrayList();
        ArrayList localFields = new ArrayList();
        LocalFieldDesc projectionField = this.separateFieldList(localFields, foreignFields);
        this.processFetchGroups(localFields, foreignFields);
        this.processForeignFields(foreignFields, localFields);
        this.processLocalFields(localFields, projectionField);
    }

    private LocalFieldDesc separateFieldList(ArrayList localFields, ArrayList foreignFields) {
        LocalFieldDesc projectionField = null;
        while (this.fieldIterator.hasNext()) {
            ConstraintFieldName cfn = (ConstraintFieldName)this.fieldIterator.next();
            FieldDesc f = this.config.getField(cfn.name);
            if (f == null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.unknownfield", cfn.name, this.config.getPersistenceCapableClass().getName()));
            }
            this.setFieldMask(f.absoluteID);
            if (cfn.desc != null) {
                foreignFields.add(cfn);
                continue;
            }
            localFields.add(f);
            if (!cfn.isProjection()) continue;
            projectionField = (LocalFieldDesc)f;
        }
        return projectionField;
    }

    protected void processConstraints() {
        if ((this.status & 1) > 0 || (this.status & 4) > 0) {
            return;
        }
        this.processLocalConstraints();
        this.processStatements();
        this.processForeignConstraints();
        this.processUnboundConstraints();
        this.status |= 4;
    }

    private void doJoin(SelectQueryPlan foreignPlan, int joinOperation) {
        if ((foreignPlan.status & 2) > 0) {
            return;
        }
        this.mergeConstraints(foreignPlan, joinOperation);
        this.mergeStatements(foreignPlan, joinOperation);
        if (foreignPlan.tables != null) {
            this.addQueryTables(foreignPlan.tables);
        }
        foreignPlan.status |= 2;
    }

    private void mergeStatements(SelectQueryPlan foreignPlan, int joinOperation) {
        if (foreignPlan.statements.size() > 0) {
            SelectStatement toStatement = (SelectStatement)foreignPlan.statements.get(0);
            if (this.statements.size() > 0) {
                SelectStatement fromStatement = (SelectStatement)this.statements.get(0);
                fromStatement.copyColumns(toStatement);
                if (joinOperation == 52) {
                    fromStatement.tableList.addAll(toStatement.tableList);
                }
                this.mergeResultDesc(foreignPlan);
                if (foreignPlan.prefetched) {
                    this.resultDesc.setPrefetching();
                }
                this.options |= foreignPlan.options;
            }
        }
    }

    private void mergeConstraints(SelectQueryPlan foreignPlan, int joinOperation) {
        boolean addAnd;
        if (joinOperation != 52) {
            if (foreignPlan.parentField.useJoinTable()) {
                this.addJoinConstraint(this, foreignPlan, foreignPlan.parentField.localColumns, foreignPlan.parentField.assocLocalColumns, joinOperation);
                this.addJoinConstraint(foreignPlan, foreignPlan, foreignPlan.parentField.assocForeignColumns, foreignPlan.parentField.foreignColumns, joinOperation);
                if (joinOperation == 10) {
                    this.constraint.addOperation(3);
                }
            } else {
                this.addJoinConstraint(this, foreignPlan, foreignPlan.parentField.localColumns, foreignPlan.parentField.foreignColumns, joinOperation);
            }
        }
        if ((addAnd = this.constraint.mergeConstraint(foreignPlan.constraint, joinOperation)) || foreignPlan.appendAndOp) {
            this.constraint.addOperation(3);
        }
    }

    private void mergeResultDesc(SelectQueryPlan foreignPlan) {
        ResultDesc foreignResult = foreignPlan.resultDesc;
        if (this.resultDesc != null && foreignResult != null) {
            this.resultDesc.doJoin(foreignResult, foreignPlan.parentField);
        } else if (this.resultDesc == null) {
            this.resultDesc = foreignResult;
        }
    }

    protected void addJoinConstraint(SelectQueryPlan fromPlan, SelectQueryPlan toPlan, ArrayList fromColumns, ArrayList toColumns, int joinOp) {
        ConstraintJoin join = new ConstraintJoin();
        join.operation = joinOp;
        join.fromColumns = fromColumns;
        join.fromPlan = fromPlan;
        join.toColumns = toColumns;
        join.toPlan = toPlan;
        this.constraint.addJoinConstraint(join);
    }

    private void processJoins() {
        if (this.foreignPlans == null) {
            return;
        }
        Iterator iter = this.foreignPlans.iterator();
        while (iter.hasNext()) {
            SelectQueryPlan fp = (SelectQueryPlan)iter.next();
            if ((fp.status & 2) == 0) {
                fp.processJoins();
                if (this.statements.size() == 1 && fp.statements.size() == 1) {
                    this.doJoin(fp, this.getJoinOperator(fp));
                }
            }
            if ((fp.status & 2) <= 0) continue;
            iter.remove();
        }
        if (this.foreignPlans != null && this.foreignPlans.size() > 0) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "sqlstore.sql.generator.selectqueryplan.plansnotjoined"));
        }
        this.foreignPlans = null;
    }

    private int getJoinOperator(SelectQueryPlan dependentPlan) {
        ForeignFieldDesc parentField = null;
        if (this.isProjection(this)) {
            parentField = dependentPlan.parentField;
        } else if (this.isProjection(dependentPlan)) {
            parentField = dependentPlan.parentField.getInverseRelationshipField();
        }
        int joinOperator = parentField != null ? 16 : 10;
        return joinOperator;
    }

    private boolean isProjection(SelectQueryPlan plan) {
        return this.prefetched || (plan.options & 1) > 0 && (plan.options & 0x1F8) == 0;
    }

    public void processOrderConstraints() {
        if ((this.status & 1) > 0 || (this.status & 0x10) > 0) {
            return;
        }
        ArrayList orderByArray = new ArrayList();
        int insertAt = 0;
        if (this.constraint != null) {
            for (int i = 0; i < this.constraint.stack.size(); ++i) {
                ConstraintNode opNode = (ConstraintNode)this.constraint.stack.get(i);
                if (!(opNode instanceof ConstraintOperation) || ((ConstraintOperation)opNode).operation != 30 && ((ConstraintOperation)opNode).operation != 31) continue;
                int pos = -1;
                if (i > 1 && this.constraint.stack.get(i - 2) instanceof ConstraintValue) {
                    pos = (Integer)((ConstraintValue)this.constraint.stack.get(i - 2)).getValue();
                    this.constraint.stack.remove(i - 2);
                    --i;
                }
                if (pos > 0) {
                    insertAt = pos;
                }
                for (int k = orderByArray.size(); k <= insertAt; ++k) {
                    orderByArray.add(null);
                }
                if (orderByArray.get(insertAt) == null) {
                    orderByArray.set(insertAt, new ArrayList());
                }
                ConstraintNode fieldNode = (ConstraintNode)this.constraint.stack.get(i - 1);
                ConstraintFieldDesc consFieldDesc = null;
                if (fieldNode instanceof ConstraintFieldName) {
                    FieldDesc fieldDesc;
                    QueryPlan originalPlan = this;
                    if (((ConstraintField)fieldNode).originalPlan != null) {
                        originalPlan = ((ConstraintField)fieldNode).originalPlan;
                    }
                    if (!((fieldDesc = originalPlan.config.getField(((ConstraintFieldName)fieldNode).name)) instanceof LocalFieldDesc)) {
                        throw new JDOUserException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", fieldDesc.getClass().getName(), "LocalFieldDesc"));
                    }
                    consFieldDesc = new ConstraintFieldDesc((LocalFieldDesc)fieldDesc, originalPlan, 1);
                } else if (fieldNode instanceof ConstraintFieldDesc) {
                    consFieldDesc = (ConstraintFieldDesc)fieldNode;
                } else {
                    throw new JDOUserException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", fieldNode.getClass().getName(), "ConstraintFieldName/ConstraintFieldDesc"));
                }
                if (((ConstraintOperation)opNode).operation == 31) {
                    consFieldDesc.ordering = -1;
                }
                ArrayList temp = (ArrayList)orderByArray.get(insertAt);
                temp.add(consFieldDesc);
                this.constraint.stack.remove(i);
                this.constraint.stack.remove(i - 1);
                i = i - 2 + 1;
            }
        }
        int size = orderByArray.size();
        for (int j = 0; j < size; ++j) {
            ArrayList oa = (ArrayList)orderByArray.get(j);
            if (this.constraint == null) {
                this.constraint = new Constraint();
            }
            int sizeK = oa.size();
            for (int k = 0; k < sizeK; ++k) {
                ConstraintFieldDesc ob = (ConstraintFieldDesc)oa.get(k);
                if (ob.ordering < 0) {
                    this.constraint.addField(ob);
                    this.constraint.addOperation(31);
                    continue;
                }
                this.constraint.addField(ob);
                this.constraint.addOperation(30);
            }
        }
        this.status |= 0x10;
    }

    @Override
    protected Statement newStatement() {
        return new SelectStatement(this.store.getVendorType(), this);
    }

    public Object getResult(PersistenceManager pm, ResultSet resultData) throws SQLException {
        return this.resultDesc.getResult(pm, resultData);
    }
}

