/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.transport.ConnectionCacheBase;
import com.sun.corba.ee.impl.transport.OutboundConnectionCacheProbeProvider;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.ContactInfo;
import com.sun.corba.ee.spi.transport.OutboundConnectionCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedObject;

@Transport
@ManagedObject
@Description(value="Cache of connections originated by the ORB")
@AMXMetadata(type="corba-outbound-connection-cache-mon", group="monitoring")
public class OutboundConnectionCacheImpl
extends ConnectionCacheBase
implements OutboundConnectionCache {
    protected Map<ContactInfo, Connection> connectionCache;
    private OutboundConnectionCacheProbeProvider pp = new OutboundConnectionCacheProbeProvider();

    public OutboundConnectionCacheImpl(ORB orb, ContactInfo contactInfo) {
        super(orb, contactInfo.getConnectionCacheType(), contactInfo.getMonitoringName());
        this.connectionCache = new HashMap<ContactInfo, Connection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public Connection get(ContactInfo contactInfo) {
        Object object = this.backingStore();
        synchronized (object) {
            this.cacheStatisticsInfo();
            return this.connectionCache.get(contactInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void put(ContactInfo contactInfo, Connection connection) {
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.put(contactInfo, connection);
            connection.setConnectionCache(this);
            this.pp.connectionOpenedEvent(contactInfo.toString(), connection.toString());
            this.cacheStatisticsInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void remove(ContactInfo contactInfo) {
        Object object = this.backingStore();
        synchronized (object) {
            if (contactInfo != null) {
                Connection connection = this.connectionCache.remove(contactInfo);
                this.pp.connectionClosedEvent(contactInfo.toString(), connection.toString());
            }
            this.cacheStatisticsInfo();
        }
    }

    @Override
    public Collection values() {
        return this.connectionCache.values();
    }

    @Override
    protected Object backingStore() {
        return this.connectionCache;
    }

    public String toString() {
        return "CorbaOutboundConnectionCacheImpl[" + this.connectionCache + "]";
    }
}

