/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.timer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class TimerSchedule
implements Serializable {
    private String second_ = "0";
    private String minute_ = "0";
    private String hour_ = "0";
    private String dayOfMonth_ = "*";
    private String month_ = "*";
    private String dayOfWeek_ = "*";
    private String year_ = "*";
    private String timezone_ = null;
    private TimeZone tz_ = null;
    private Date start_ = null;
    private Date end_ = null;
    private boolean configured = false;
    private boolean isValid = true;
    private boolean lastDayOfMonth = false;
    private int dayBeforeEndOfMonth = 0;
    private BitSet seconds = new BitSet(60);
    private BitSet minutes = new BitSet(60);
    private BitSet hours = new BitSet(24);
    private BitSet daysOfWeek = new BitSet(7);
    private BitSet daysOfMonth = new BitSet(31);
    private BitSet months = new BitSet(12);
    private static Map<Object, Integer> conversionTable = new HashMap<Object, Integer>();
    private List<String> daysOfWeekOrRangesOfDaysInMonth = new ArrayList<String>();
    private List<Integer> years = new ArrayList<Integer>();
    private static final Pattern simpleRangePattern = Pattern.compile("[0-9]+\\s*-\\s*([0-9]+|last)");
    private static final Pattern positivePattern = Pattern.compile("[0-9]+");
    private static final Pattern negativePattern = Pattern.compile("-[1-7]");
    private static final Pattern orderedDayPattern = Pattern.compile("(1st|2nd|3rd|[45]th|last)\\s+[a-z][a-z][a-z]");
    private static final Pattern yearPattern = Pattern.compile("[1-9][0-9][0-9][0-9]");
    private static final char rangeChar = '-';
    private static final char incrementChar = '/';
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY_OF_MONTH = "dayOfMonth";
    private static final String DAY_OF_WEEK = "dayOfWeek";
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String SECOND = "second";
    private static final int MAX_YEAR_TRY = 100;

    public TimerSchedule() {
    }

    public TimerSchedule(String s) {
        String[] sp = s.split(" # ");
        if (!this.isExpectedElementCount(sp)) {
            throw new IllegalStateException("Cannot construct " + this.getClass().getName() + " from " + s);
        }
        this.second_ = sp[0];
        this.minute_ = sp[1];
        this.hour_ = sp[2];
        this.dayOfMonth_ = sp[3];
        this.month_ = sp[4];
        this.dayOfWeek_ = sp[5];
        this.year_ = sp[6];
        this.timezone_ = sp[7].equals("null") ? null : sp[7];
        this.start_ = sp[8].equals("null") ? null : new Date(Long.parseLong(sp[8]));
        this.end_ = sp[9].equals("null") ? null : new Date(Long.parseLong(sp[9]));
        this.configure();
    }

    public TimerSchedule second(String s) {
        this.assertNotEmpty(s, SECOND);
        this.second_ = s.trim();
        return this;
    }

    public String getSecond() {
        return this.second_;
    }

    public TimerSchedule minute(String m) {
        this.assertNotEmpty(m, MINUTE);
        this.minute_ = m.trim();
        return this;
    }

    public String getMinute() {
        return this.minute_;
    }

    public TimerSchedule hour(String h) {
        this.assertNotEmpty(h, HOUR);
        this.hour_ = h.trim();
        return this;
    }

    public String getHour() {
        return this.hour_;
    }

    public TimerSchedule dayOfMonth(String d) {
        this.assertNotEmpty(d, DAY_OF_MONTH);
        this.dayOfMonth_ = d.trim();
        return this;
    }

    public String getDayOfMonth() {
        return this.dayOfMonth_;
    }

    public TimerSchedule month(String m) {
        this.assertNotEmpty(m, MONTH);
        this.month_ = m.trim();
        return this;
    }

    public String getMonth() {
        return this.month_;
    }

    public TimerSchedule dayOfWeek(String d) {
        this.assertNotEmpty(d, DAY_OF_WEEK);
        this.dayOfWeek_ = d.trim();
        return this;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek_;
    }

    public TimerSchedule year(String y) {
        this.assertNotEmpty(y, YEAR);
        this.year_ = y.trim();
        return this;
    }

    public String getYear() {
        return this.year_;
    }

    public TimerSchedule timezone(String tz) {
        this.timezone_ = tz != null && tz.length() > 0 ? tz.trim() : null;
        return this;
    }

    public String getTimeZoneID() {
        return this.timezone_;
    }

    public TimeZone getTimeZone() {
        return this.tz_;
    }

    public TimerSchedule start(Date s) {
        this.start_ = s == null ? null : new Date(s.getTime());
        return this;
    }

    public Date getStart() {
        return this.start_ == null ? null : new Date(this.start_.getTime());
    }

    public TimerSchedule end(Date e) {
        this.end_ = e == null ? null : new Date(e.getTime());
        return this;
    }

    public Date getEnd() {
        return this.end_ == null ? null : new Date(this.end_.getTime());
    }

    public String getScheduleAsString() {
        StringBuffer s = new StringBuffer().append(this.second_).append(" # ").append(this.minute_).append(" # ").append(this.hour_).append(" # ").append(this.dayOfMonth_).append(" # ").append(this.month_).append(" # ").append(this.dayOfWeek_).append(" # ").append(this.year_).append(" # ").append(this.timezone_).append(" # ").append(this.start_ == null ? null : Long.valueOf(this.start_.getTime())).append(" # ").append(this.end_ == null ? null : Long.valueOf(this.end_.getTime()));
        return s.toString();
    }

    public int hashCode() {
        return this.getScheduleAsString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof TimerSchedule)) {
            return false;
        }
        TimerSchedule t = (TimerSchedule)o;
        return this.getScheduleAsString().equals(t.getScheduleAsString());
    }

    public boolean isValid(Calendar date) {
        if (this.end_ != null && date.getTimeInMillis() > this.end_.getTime()) {
            return false;
        }
        if (this.years.size() == 0) {
            return this.isValid;
        }
        GregorianCalendar now = new GregorianCalendar(Locale.ENGLISH);
        if (this.tz_ != null) {
            ((Calendar)now).setTimeZone(this.tz_);
        }
        int currYear = now.get(1);
        for (int year : this.years) {
            if (year < currYear || date.get(1) != year) continue;
            return true;
        }
        return false;
    }

    public Calendar getNextTimeout() {
        return this.getNextTimeout(new GregorianCalendar(Locale.ENGLISH));
    }

    public Calendar getNextTimeout(Date date) {
        GregorianCalendar next = new GregorianCalendar(Locale.ENGLISH);
        next.setTime(date);
        return this.getNextTimeout(next);
    }

    private Calendar getNextTimeout(Calendar next) {
        if (!this.configured) {
            this.configure();
        }
        if (this.tz_ != null) {
            next.setTimeZone(this.tz_);
        }
        if (this.start_ != null && next.getTimeInMillis() < this.start_.getTime()) {
            next.setTime(this.start_);
        } else {
            next.add(13, 1);
            next.set(14, 0);
        }
        if (this.years.size() == 0) {
            return this.getNextTimeout(next, 0);
        }
        int currYear = next.get(1);
        for (int year : this.years) {
            if (year < currYear) continue;
            if (next.get(1) == year) {
                next = this.getNextTimeout(next, year);
            } else if (next.get(1) < year) {
                next.set(year, 0, 1, 0, 0, 0);
                System.out.println("==> Year reset " + String.valueOf(next.getTime()));
                next = this.getNextTimeout(next, year);
            }
            if (next.get(1) != year) continue;
            break;
        }
        return next;
    }

    private Calendar getNextTimeout(Calendar next, int year) {
        int i = 0;
        while (!(this.end_ != null && next.getTime().after(this.end_) || year != 0 && next.get(1) > year)) {
            if (this.skipToNextValue(next, this.months, 2, 1)) {
                if (++i > 100) {
                    this.isValid = false;
                    break;
                }
                next.set(5, 1);
                next.set(11, 0);
                next.set(12, 0);
                next.set(13, 0);
                continue;
            }
            if (this.dayOfWeek_.equals("*")) {
                if (this.skipToNextValue(next, this.daysOfMonth, 5, 2)) {
                    next.set(11, 0);
                    next.set(12, 0);
                    next.set(13, 0);
                    continue;
                }
            } else if (this.dayOfMonth_.equals("*")) {
                if (this.skipToNextValue(next, this.daysOfWeek, 7, 4)) {
                    next.set(11, 0);
                    next.set(12, 0);
                    next.set(13, 0);
                    continue;
                }
            } else {
                Calendar date0;
                Calendar date1 = (Calendar)next.clone();
                Calendar date2 = (Calendar)next.clone();
                if (this.skipToNextValue(date1, this.daysOfMonth, 5, 2)) {
                    date1.set(11, 0);
                    date1.set(12, 0);
                    date1.set(13, 0);
                }
                if (this.skipToNextValue(date2, this.daysOfWeek, 7, 4)) {
                    date2.set(11, 0);
                    date2.set(12, 0);
                    date2.set(13, 0);
                }
                Calendar calendar = date0 = date1.before(date2) ? date1 : date2;
                if (!next.equals(date0)) {
                    next = date0;
                    continue;
                }
            }
            if (this.skipToNextValue(next, this.hours, 11, 5)) {
                next.set(12, 0);
                next.set(13, 0);
                continue;
            }
            if (this.skipToNextValue(next, this.minutes, 12, 11)) {
                next.set(13, 0);
                continue;
            }
            if (this.skipToNextValue(next, this.seconds, 13, 12)) continue;
        }
        return next;
    }

    protected boolean isExpectedElementCount(String[] el) {
        return el.length == 10;
    }

    protected void configure() {
        this.parseNumbersOrNames(this.second_, this.seconds, 0, 60, true, SECOND);
        this.parseNumbersOrNames(this.minute_, this.minutes, 0, 60, true, MINUTE);
        this.parseNumbersOrNames(this.hour_, this.hours, 0, 24, true, HOUR);
        this.parseNumbersOrNames(this.dayOfWeek_, this.daysOfWeek, 0, 7, false, DAY_OF_WEEK);
        this.parseNumbersOrNames(this.month_, this.months, 1, 12, false, MONTH);
        this.parseDaysOfMonth();
        this.parseYears();
        if (this.timezone_ != null) {
            this.tz_ = TimeZone.getTimeZone(this.timezone_);
        }
        this.configured = true;
    }

    private void parseNumbersOrNames(String s, BitSet bits, int start, int size, boolean incrementAllowed, String field) {
        if (s.equals("*")) {
            if (!this.isDayOfWeek(field)) {
                bits.set(0, size);
            } else {
                for (int i = start; i <= size; ++i) {
                    bits.set(conversionTable.get(i));
                }
            }
            return;
        }
        if (s.indexOf(44) > 0) {
            String[] arr;
            for (String s0 : arr = this.splitList(s)) {
                if (s0.indexOf(45, 1) > 0) {
                    this.processRange(s0, bits, start, size, field);
                    continue;
                }
                bits.set(this.getNumericValue(s0, start, size, field));
            }
            return;
        }
        if (s.indexOf(45) > 0) {
            this.processRange(s, bits, start, size, field);
            return;
        }
        if (incrementAllowed && s.indexOf(47) > 0) {
            String[] arr = this.splitBy(s, '/');
            int begin = 0;
            if (!arr[0].equals("*")) {
                begin = this.getNumericValue(arr[0], start, size, field);
            }
            int incr = this.getNumericValue(arr[1], start, size, field);
            for (int i = begin; i < size; i += incr) {
                bits.set(i);
            }
            return;
        }
        bits.set(this.getNumericValue(s, start, size, field));
    }

    private void processRange(String s, BitSet bits, int start, int size, String field) {
        String[] arr = this.splitBy(s, '-');
        int begin = this.getNumericValue(arr[0], start, size, field);
        int end = this.getNumericValue(arr[1], start, size, field);
        if (begin < 0) {
            throw new IllegalArgumentException("Negative range start for " + field + " : " + s);
        }
        boolean b = this.isDayOfWeek(field);
        if (b && arr[0].equals(Integer.toString(start)) && arr[1].equals(Integer.toString(size))) {
            for (int i = start; i <= size; ++i) {
                bits.set(conversionTable.get(i));
            }
        } else if (b) {
            this.setBitsRange(bits, begin, end, 1, 8);
        } else {
            this.setBitsRange(bits, begin, end, 0, size);
        }
    }

    private void parseDaysOfMonth() {
        if (this.dayOfMonth_.equals("*")) {
            this.daysOfMonth.set(1, 32);
            return;
        }
        if (this.dayOfMonth_.indexOf(44) > 0) {
            String[] arr;
            for (String s0 : arr = this.splitList(this.dayOfMonth_)) {
                if (s0.indexOf(45, 1) > 0) {
                    this.processRangeDaysOfMonth(s0);
                    continue;
                }
                this.processDayOfMonth(s0);
            }
            return;
        }
        if (this.dayOfMonth_.indexOf(45, 1) > 0) {
            this.processRangeDaysOfMonth(this.dayOfMonth_);
            return;
        }
        this.processDayOfMonth(this.dayOfMonth_);
    }

    private void processRangeDaysOfMonth(String s) {
        if (simpleRangePattern.matcher(s).matches()) {
            String[] arr = this.splitBy(s, '-');
            int begin = this.parseInt(arr[0], DAY_OF_MONTH);
            int end = 31;
            if (positivePattern.matcher(arr[1]).matches()) {
                end = this.parseInt(arr[1], DAY_OF_MONTH);
            }
            if (begin < 1 || end > 31) {
                throw new IllegalArgumentException("Invalid dayOfMonth range: " + s);
            }
            this.setBitsRange(this.daysOfMonth, begin, end, 1, 32);
        } else {
            this.daysOfWeekOrRangesOfDaysInMonth.add(s.toLowerCase(Locale.ENGLISH));
        }
    }

    private void parseYears() {
        if (this.year_.equals("*")) {
            return;
        }
        if (this.year_.indexOf(44) > 0) {
            String[] arr = this.splitList(this.year_);
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i].indexOf(45, 1) > 0) {
                    this.processRangeAsList(this.years, arr[i], YEAR, yearPattern);
                    continue;
                }
                this.years.add(this.assertValidYear(this.parseInt(arr[i], YEAR)));
            }
            Collections.sort(this.years);
            return;
        }
        if (this.year_.indexOf(45, 1) > 0) {
            this.processRangeAsList(this.years, this.year_, YEAR, yearPattern);
            return;
        }
        this.years.add(this.assertValidYear(this.parseInt(this.year_, YEAR)));
    }

    private void processRangeAsList(List list, String s, String field, Pattern pattern) {
        int end;
        String[] arr = this.splitBy(s, '-');
        int begin = this.parseInt(arr[0], field);
        if (begin > (end = this.parseInt(arr[1], field)) || !pattern.matcher(arr[0]).matches() || !pattern.matcher(arr[1]).matches()) {
            throw new IllegalArgumentException("Invalid " + field + " range: " + s);
        }
        for (int i = begin; i <= end; ++i) {
            list.add(i);
        }
    }

    private boolean skipToNextValue(Calendar date, BitSet bits, int field, int highfiled) {
        boolean changed = false;
        int currvalue = date.get(field);
        if (field == 5) {
            bits = this.populateCurrentMonthBits(date);
        }
        if (!bits.get(currvalue)) {
            int nextvalue = bits.nextSetBit(currvalue);
            if (nextvalue == -1 || nextvalue > date.getActualMaximum(field)) {
                date.add(highfiled, 1);
                if (field == 5) {
                    bits = this.populateCurrentMonthBits(date);
                }
                nextvalue = bits.nextSetBit(0);
            }
            if (nextvalue == -1) {
                throw new IllegalArgumentException("Should not happen - no value found");
            }
            date.set(field, nextvalue);
            changed = true;
        }
        return changed;
    }

    private String[] splitList(String s) {
        return s.split("\\s*,\\s*");
    }

    private String[] splitBy(String s, char ch) {
        int i = s.indexOf(ch, 1);
        return new String[]{s.substring(0, i).trim(), s.substring(i + 1).trim()};
    }

    private int getNumericValue(String s, int start, int size, String field) {
        int i;
        if (positivePattern.matcher(s).matches()) {
            i = this.parseInt(s, field);
            if (!(this.isDayOfWeek(field) || i >= start && i <= start + size - 1)) {
                throw new IllegalArgumentException("Invalid " + field + " value: " + s);
            }
        } else {
            Integer val = conversionTable.get(s.toLowerCase(Locale.ENGLISH));
            this.assertValid(val, s, field);
            i = val;
        }
        int result = i - start;
        if (this.isDayOfWeek(field)) {
            Integer val = conversionTable.get(i);
            this.assertValid(val, s, field);
            result = val;
        }
        return result;
    }

    private void processDayOfMonth(String s) {
        String s0 = s.toLowerCase(Locale.ENGLISH);
        if (positivePattern.matcher(s0).matches()) {
            int i = this.parseInt(s0, DAY_OF_MONTH);
            if (i < 1 || i > 31) {
                throw new IllegalArgumentException("Invalid dayOfMonth value: " + s0);
            }
            this.daysOfMonth.set(i);
        } else if (negativePattern.matcher(s0).matches()) {
            this.dayBeforeEndOfMonth = this.parseInt(s0.substring(1), DAY_OF_MONTH);
        } else if (s0.equals("last")) {
            this.lastDayOfMonth = true;
        } else {
            this.daysOfWeekOrRangesOfDaysInMonth.add(s0);
        }
    }

    private BitSet populateCurrentMonthBits(Calendar date) {
        if (this.dayOfMonth_.equals("*")) {
            return this.daysOfMonth;
        }
        BitSet bits = (BitSet)this.daysOfMonth.clone();
        if (this.lastDayOfMonth) {
            bits.set(date.getActualMaximum(5));
        }
        if (this.dayBeforeEndOfMonth > 0) {
            bits.set(date.getActualMaximum(5) - this.dayBeforeEndOfMonth);
        }
        int size = this.daysOfWeekOrRangesOfDaysInMonth.size();
        for (int i = 0; i < size; ++i) {
            this.setDaysOfWeek(bits, date, this.daysOfWeekOrRangesOfDaysInMonth.get(i));
        }
        return bits;
    }

    private int getDayForDayOfMonth(Calendar date, String s) {
        if (positivePattern.matcher(s).matches()) {
            return this.parseInt(s, DAY_OF_MONTH);
        }
        Calendar testdate = (Calendar)date.clone();
        int lastday = testdate.getActualMaximum(5);
        if (s.equals("last")) {
            return lastday;
        }
        if (negativePattern.matcher(s).matches()) {
            return lastday - this.parseInt(s.substring(1), DAY_OF_MONTH);
        }
        if (orderedDayPattern.matcher(s).matches()) {
            String[] arr = this.splitBy(s, ' ');
            int num = -1;
            if (!arr[0].equals("last")) {
                num = this.parseInt(arr[0].substring(0, 1), DAY_OF_MONTH);
            }
            Integer weekday = conversionTable.get(arr[1]);
            this.assertValid(weekday, arr[1], DAY_OF_MONTH);
            int day = conversionTable.get(weekday);
            return this.getDayForDayOfWeek(testdate, lastday, day, num);
        }
        throw new IllegalArgumentException("Invalid dayOfMonth value: " + s);
    }

    private int getDayForDayOfWeek(Calendar testdate, int lastday, int day, int num) {
        if (num == -1) {
            return this.getLastDayForDayOfWeek(testdate, day, lastday);
        }
        int result = 1;
        for (int i = (num - 1) * 7 + 1; i <= lastday; ++i) {
            testdate.set(5, i);
            int testday = testdate.get(7);
            if (testday != day) continue;
            result = i;
            break;
        }
        return result;
    }

    private int getLastDayForDayOfWeek(Calendar testdate, int day, int lastday) {
        int result = lastday;
        for (int i = lastday; i >= 1; --i) {
            testdate.set(5, i);
            int testday = testdate.get(7);
            if (testday != day) continue;
            result = i;
            break;
        }
        return result;
    }

    private void setDaysOfWeek(BitSet bits, Calendar date, String s) {
        if (s.indexOf(45, 1) > 0) {
            String[] arr = this.splitBy(s, '-');
            int begin = this.getDayForDayOfMonth(date, arr[0]);
            int end = this.getDayForDayOfMonth(date, arr[1]);
            this.setBitsRange(bits, begin, end, 1, date.getActualMaximum(5) + 1);
        } else {
            bits.set(this.getDayForDayOfMonth(date, s));
        }
    }

    private void setBitsRange(BitSet bits, int begin, int end, int start, int size) {
        if (begin <= end) {
            bits.set(begin, end + 1);
        } else {
            bits.set(begin, size);
            bits.set(start, end + 1);
        }
    }

    private int parseInt(String s, String field) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid " + field + " value: " + s);
        }
    }

    private int assertValidYear(int y) {
        this.assertValid(y, 1970, 9999, YEAR);
        return y;
    }

    private void assertValid(int v, int min, int max, String field) {
        if (v < min || v > max) {
            throw new IllegalArgumentException("Invalid " + field + " value: " + v);
        }
    }

    private void assertNotNull(Object s, String field) {
        if (s == null) {
            throw new IllegalArgumentException("Field " + field + " cannot be null");
        }
    }

    private void assertNotEmpty(String s, String field) {
        this.assertNotNull(s, field);
        if (s.length() == 0) {
            throw new IllegalArgumentException("Field " + field + " cannot be an empty String");
        }
    }

    private void assertValid(Integer v, String s, String field) {
        if (v == null) {
            throw new IllegalArgumentException("Invalid " + field + " value: " + s);
        }
    }

    private boolean isDayOfWeek(String field) {
        return field.equals(DAY_OF_WEEK);
    }

    static {
        conversionTable.put("jan", 1);
        conversionTable.put("feb", 2);
        conversionTable.put("mar", 3);
        conversionTable.put("apr", 4);
        conversionTable.put("may", 5);
        conversionTable.put("jun", 6);
        conversionTable.put("jul", 7);
        conversionTable.put("aug", 8);
        conversionTable.put("sep", 9);
        conversionTable.put("oct", 10);
        conversionTable.put("nov", 11);
        conversionTable.put("dec", 12);
        conversionTable.put("sun", 0);
        conversionTable.put("mon", 1);
        conversionTable.put("tue", 2);
        conversionTable.put("wed", 3);
        conversionTable.put("thu", 4);
        conversionTable.put("fri", 5);
        conversionTable.put("sat", 6);
        conversionTable.put(0, 1);
        conversionTable.put(1, 2);
        conversionTable.put(2, 3);
        conversionTable.put(3, 4);
        conversionTable.put(4, 5);
        conversionTable.put(5, 6);
        conversionTable.put(6, 7);
        conversionTable.put(7, 1);
    }
}

