/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.JsonUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.Map;

public final class ButtonRenderer
extends AbstractRenderer {
    private static final String[] INT_ATTRIBUTES = new String[]{"tabIndex"};
    private static final String[] STRING_ATTRIBUTES = new String[]{"dir", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "style"};
    private static final String[] INPUT_ATTRIBUTES = new String[]{"alt", "align"};

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Button button = (Button)component;
        if (button.isReset()) {
            return;
        }
        String clientId = button.getClientId(context);
        Map map = context.getExternalContext().getRequestParameterMap();
        if (map.containsKey(clientId) || map.containsKey(clientId + ".x") && map.containsKey(clientId + ".y")) {
            button.queueEvent((FacesEvent)new ActionEvent((UIComponent)button));
        }
    }

    @Override
    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        if (button.isEscape()) {
            writer.startElement("input", (UIComponent)button);
        } else {
            writer.startElement("button", (UIComponent)button);
        }
    }

    @Override
    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        writer.writeAttribute("id", (Object)button.getClientId(context), null);
        writer.writeAttribute("name", (Object)button.getClientId(context), null);
        String style = ButtonRenderer.getStyle(button, ThemeUtilities.getTheme(context));
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)button, style);
        writer.writeAttribute("onblur", (Object)JavaScriptUtilities.renderEventCall("button", button.getOnBlur(), "onblur"), "onBlur");
        writer.writeAttribute("onfocus", (Object)JavaScriptUtilities.renderEventCall("button", button.getOnFocus(), "onfocus"), "onFocus");
        writer.writeAttribute("onmouseout", (Object)JavaScriptUtilities.renderEventCall("button", button.getOnMouseOut(), "onmouseout"), "onMouseOut");
        writer.writeAttribute("onmouseover", (Object)JavaScriptUtilities.renderEventCall("button", button.getOnMouseOver(), "onmouseover"), "onMouseOver");
        if (button.getToolTip() != null) {
            writer.writeAttribute("title", (Object)button.getToolTip(), "toolTip");
        }
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        this.addIntegerAttributes(context, component, writer, INT_ATTRIBUTES);
        ButtonRenderer.addStringAttributes(context, component, writer, STRING_ATTRIBUTES);
        if (button.isEscape()) {
            ButtonRenderer.addStringAttributes(context, component, writer, INPUT_ATTRIBUTES);
        }
        String imageURL = button.getImageURL();
        String icon = button.getIcon();
        if (imageURL != null) {
            ButtonRenderer.renderImageURLAttributes(context, component, writer, imageURL);
        } else if (icon != null) {
            ButtonRenderer.renderIconAttributes(context, component, writer, icon);
        } else {
            ButtonRenderer.renderTextAttributes(component, writer);
        }
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        if (button.isEscape()) {
            writer.endElement("input");
        } else {
            writer.endElement("button");
        }
        boolean isIcon = button.getImageURL() != null || button.getIcon() != null;
        JsonObject initProps = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("id", button.getClientId(context)).add("mini", button.isMini()).add("disabled", button.isDisabled()).add("secondary", !button.isPrimary()).add("icon", isIcon).build();
        JavaScriptUtilities.renderInitScriptTag(writer, "button", initProps);
    }

    private static void renderIconAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String icon) throws IOException {
        String imagePath = ThemeUtilities.getTheme(context).getImagePath(icon);
        writer.writeAttribute("type", (Object)"image", null);
        RenderingUtilities.renderURLAttribute(context, writer, component, "src", imagePath, "icon");
    }

    private static void renderImageURLAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String url) throws IOException {
        String zUrl = context.getApplication().getViewHandler().getResourceURL(context, url);
        writer.writeAttribute("type", (Object)"image", null);
        RenderingUtilities.renderURLAttribute(context, writer, component, "src", zUrl, "imageURL");
    }

    private static void renderTextAttributes(UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        if (button.isReset()) {
            writer.writeAttribute("type", (Object)"reset", null);
        } else {
            writer.writeAttribute("type", (Object)"submit", null);
        }
        Object text = ConversionUtilities.convertValueToString((UIComponent)button, button.getValue());
        if (text == null || ((String)text).trim().length() == 0) {
            return;
        }
        if (!button.isNoTextPadding()) {
            if (((String)text).trim().length() <= 3) {
                text = "  " + (String)text + "  ";
            } else if (((String)text).trim().length() == 4) {
                text = " " + (String)text + " ";
            }
        }
        if (button.isEscape()) {
            writer.writeAttribute("value", text, "text");
        } else {
            writer.write((String)text);
        }
    }

    private static String getOnBlurStyle(Button button, Theme theme) {
        String style = button.getImageURL() != null || button.getIcon() != null ? theme.getStyleClass("BUTTON3") : (button.isMini() && !button.isPrimary() ? theme.getStyleClass("BUTTON2_MINI") : (button.isMini() ? theme.getStyleClass("BUTTON1_MINI") : (!button.isPrimary() ? theme.getStyleClass("BUTTON2") : theme.getStyleClass("BUTTON1"))));
        return style;
    }

    private static String getOnFocusStyle(Button button, Theme theme) {
        String style = button.getImageURL() != null || button.getIcon() != null ? theme.getStyleClass("BUTTON3_HOVER") : (button.isMini() && !button.isPrimary() ? theme.getStyleClass("BUTTON2_MINI_HOVER") : (button.isMini() ? theme.getStyleClass("BUTTON1_MINI_HOVER") : (!button.isPrimary() ? theme.getStyleClass("BUTTON2_HOVER") : theme.getStyleClass("BUTTON1_HOVER"))));
        return style;
    }

    private static String getOnMouseOverStyle(Button button, Theme theme) {
        return ButtonRenderer.getOnFocusStyle(button, theme);
    }

    private static String getOnMouseOutStyle(Button button, Theme theme) {
        return ButtonRenderer.getOnBlurStyle(button, theme);
    }

    private static String getStyle(Button button, Theme theme) {
        String style = button.getImageURL() != null || button.getIcon() != null ? theme.getStyleClass("BUTTON3") : (button.isMini() && !button.isPrimary() ? (button.isDisabled() ? theme.getStyleClass("BUTTON2_MINI_DISABLED") : theme.getStyleClass("BUTTON2_MINI")) : (button.isMini() ? (button.isDisabled() ? theme.getStyleClass("BUTTON1_MINI_DISABLED") : theme.getStyleClass("BUTTON1_MINI")) : (!button.isPrimary() ? (button.isDisabled() ? theme.getStyleClass("BUTTON2_DISABLED") : theme.getStyleClass("BUTTON2")) : (button.isDisabled() ? theme.getStyleClass("BUTTON1_DISABLED") : theme.getStyleClass("BUTTON1")))));
        return style;
    }
}

