/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.glassfish.grizzly.http.util.CookieHeaderParser;
import org.glassfish.grizzly.http.util.CookieUtils;

public class CookieHeaderGenerator {
    public static final String COOKIE_COMMENT_ATTR = "Comment";
    public static final String COOKIE_DOMAIN_ATTR = "Domain";
    public static final String COOKIE_MAX_AGE_ATTR = "Max-Age";
    public static final String COOKIE_PATH_ATTR = "Path";
    public static final String COOKIE_SECURE_ATTR = "Secure";
    public static final String COOKIE_HTTP_ONLY_ATTR = "HttpOnly";
    private static final String COOKIE_DATE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    protected static final ThreadLocal<DateFormat> COOKIE_DATE_FORMAT;
    protected static final String ANCIENT_DATE;
    private static final BitSet domainValid;

    public static String generateHeader(String name, String value, int maxAge, String domain, String path, boolean isSecure, boolean isHttpOnly, Map<String, String> attributes) {
        StringBuffer header = new StringBuffer();
        header.append(name);
        header.append('=');
        if (value != null && value.length() > 0) {
            CookieHeaderGenerator.validateCookieValue(value);
            header.append(value);
        }
        if (maxAge > -1) {
            if (maxAge > 0) {
                header.append("; Max-Age=");
                header.append(maxAge);
            }
            if (CookieUtils.ALWAYS_ADD_EXPIRES) {
                header.append("; Expires=");
                if (maxAge == 0) {
                    header.append(ANCIENT_DATE);
                } else {
                    COOKIE_DATE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), header, new FieldPosition(0));
                }
            }
        }
        if (domain != null && domain.length() > 0) {
            CookieHeaderGenerator.validateDomain(domain);
            header.append("; Domain=");
            header.append(domain);
        }
        if (path != null && path.length() > 0) {
            CookieHeaderGenerator.validatePath(path);
            header.append("; Path=");
            header.append(path);
        }
        if (isSecure) {
            header.append("; Secure");
        }
        if (isHttpOnly) {
            header.append("; HttpOnly");
        }
        block11: for (Map.Entry<String, String> entry : attributes.entrySet()) {
            switch (entry.getKey()) {
                case "Comment": 
                case "Domain": 
                case "Max-Age": 
                case "Path": 
                case "Secure": 
                case "HttpOnly": {
                    continue block11;
                }
            }
            CookieHeaderGenerator.validateAttribute(entry.getKey(), entry.getValue());
            header.append("; ");
            header.append(entry.getKey());
            if ("".equals(entry.getValue())) continue;
            header.append('=');
            header.append(entry.getValue());
        }
        return header.toString();
    }

    private static void validateCookieValue(String value) {
        int start = 0;
        int end = value.length();
        if (end > 1 && value.charAt(0) == '\"' && value.charAt(end - 1) == '\"') {
            start = 1;
            --end;
        }
        char[] chars = value.toCharArray();
        for (int i = start; i < end; ++i) {
            char c = chars[i];
            if (c >= '!' && c != '\"' && c != ',' && c != ';' && c != '\\' && c != '\u007f') continue;
            throw new IllegalArgumentException("rfc6265CookieProcessor.invalidCharInValue " + Integer.toString(c));
        }
    }

    private static void validateDomain(String domain) {
        int prev = -1;
        int cur = -1;
        char[] chars = domain.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            prev = cur;
            cur = chars[i];
            if (!domainValid.get(cur)) {
                throw new IllegalArgumentException("rfc6265CookieProcessor.invalidDomain " + domain);
            }
            if (!(prev != 46 && prev != -1 || cur != 46 && cur != 45)) {
                throw new IllegalArgumentException("rfc6265CookieProcessor.invalidDomain " + domain);
            }
            if (prev != 45 || cur != 46) continue;
            throw new IllegalArgumentException("rfc6265CookieProcessor.invalidDomain " + domain);
        }
        if (cur == 46 || cur == 45) {
            throw new IllegalArgumentException("rfc6265CookieProcessor.invalidDomain " + domain);
        }
    }

    private static void validatePath(String path) {
        char[] chars;
        for (char ch : chars = path.toCharArray()) {
            if (ch >= ' ' && ch <= '~' && ch != ';') continue;
            throw new IllegalArgumentException("rfc6265CookieProcessor.invalidPath " + path);
        }
    }

    private static void validateAttribute(String name, String value) {
        char[] chars;
        if (!CookieHeaderGenerator.isToken(name)) {
            throw new IllegalArgumentException("rfc6265CookieProcessor.invalidAttributeName " + name);
        }
        for (char ch : chars = value.toCharArray()) {
            if (ch >= ' ' && ch <= '~' && ch != ';') continue;
            throw new IllegalArgumentException("rfc6265CookieProcessor.invalidAttributeValue " + name + " " + value);
        }
    }

    public static boolean isToken(String string) {
        if (string == null) {
            return false;
        }
        if (string.isEmpty()) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (CookieHeaderParser.isToken(c)) continue;
            return false;
        }
        return true;
    }

    static {
        int c;
        COOKIE_DATE_FORMAT = ThreadLocal.withInitial(() -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat(COOKIE_DATE_PATTERN, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return dateFormat;
        });
        ANCIENT_DATE = COOKIE_DATE_FORMAT.get().format(new Date(10000L));
        domainValid = new BitSet(128);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        domainValid.set(46);
        domainValid.set(45);
    }
}

