/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.AgentConnector;
import com.jcraft.jsch.AgentProxyException;
import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Util;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import java.util.Locale;

public class PageantConnector
implements AgentConnector {
    private static final int AGENT_MAX_MSGLEN = 262144;
    private static final long AGENT_COPYDATA_ID = 2152616122L;
    private final User32 user32;
    private final Kernel32 kernel32;

    public PageantConnector() throws AgentProxyException {
        if (!Util.getSystemProperty("os.name", "").startsWith("Windows")) {
            throw new AgentProxyException("PageantConnector only available on Windows.");
        }
        try {
            this.user32 = User32.INSTANCE;
            this.kernel32 = Kernel32.INSTANCE;
        }
        catch (LinkageError e) {
            throw new AgentProxyException(e.toString(), e);
        }
    }

    @Override
    public String getName() {
        return "pageant";
    }

    @Override
    public boolean isAvailable() {
        return this.user32.FindWindow("Pageant", "Pageant") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Buffer buffer) throws AgentProxyException {
        WinNT.HANDLE sharedFile;
        block12: {
            if (buffer.getLength() > 262144) {
                throw new AgentProxyException("Query too large.");
            }
            WinDef.HWND hwnd = this.user32.FindWindow("Pageant", "Pageant");
            if (hwnd == null) {
                throw new AgentProxyException("Pageant is not runnning.");
            }
            String mapname = String.format(Locale.ROOT, "PageantRequest%08x", this.kernel32.GetCurrentThreadId());
            sharedFile = null;
            Pointer sharedMemory = null;
            try {
                int i;
                WinBase.SECURITY_ATTRIBUTES psa = null;
                sharedFile = this.kernel32.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, psa, 4, 0, 262144, mapname);
                if (sharedFile == null || sharedFile == WinBase.INVALID_HANDLE_VALUE) {
                    throw new AgentProxyException("Unable to create shared file mapping.");
                }
                sharedMemory = this.kernel32.MapViewOfFile(sharedFile, 2, 0, 0, 0);
                if (sharedMemory == null) {
                    throw new AgentProxyException("Unable to create shared file mapping.");
                }
                sharedMemory.write(0L, buffer.buffer, 0, buffer.getLength());
                WinUser.COPYDATASTRUCT cds = PageantConnector.createCDS(mapname);
                long rcode = this.sendMessage(hwnd, cds);
                long foo = cds.dwData.longValue();
                buffer.rewind();
                if (rcode != 0L) {
                    sharedMemory.read(0L, buffer.buffer, 0, 4);
                    i = buffer.getInt();
                    if (i <= 0 || i > 262140) {
                        throw new AgentProxyException("Illegal length: " + i);
                    }
                } else {
                    throw new AgentProxyException("User32.SendMessage() returned 0 with cds.dwData: " + Long.toHexString(foo));
                }
                buffer.rewind();
                buffer.checkFreeSize(i);
                sharedMemory.read(4L, buffer.buffer, 0, i);
                if (sharedMemory == null) break block12;
            }
            catch (Throwable throwable) {
                if (sharedMemory != null) {
                    this.kernel32.UnmapViewOfFile(sharedMemory);
                }
                if (sharedFile != null) {
                    this.kernel32.CloseHandle(sharedFile);
                }
                throw throwable;
            }
            this.kernel32.UnmapViewOfFile(sharedMemory);
        }
        if (sharedFile != null) {
            this.kernel32.CloseHandle(sharedFile);
        }
    }

    static WinUser.COPYDATASTRUCT createCDS(String mapname) {
        Memory foo = new Memory((long)(mapname.length() + 1));
        foo.setString(0L, mapname, "US-ASCII");
        WinUser.COPYDATASTRUCT cds = new WinUser.COPYDATASTRUCT();
        cds.dwData = new BaseTSD.ULONG_PTR(2152616122L);
        cds.cbData = (int)foo.size();
        cds.lpData = foo;
        cds.write();
        return cds;
    }

    long sendMessage(WinDef.HWND hwnd, WinUser.COPYDATASTRUCT cds) {
        WinDef.LPARAM data = new WinDef.LPARAM(Pointer.nativeValue((Pointer)cds.getPointer()));
        WinDef.LRESULT result = this.user32.SendMessage(hwnd, 74, null, data);
        return result.longValue();
    }
}

