/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CompoundSelection;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaSelect;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Nulls;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.criteria.TemporalField;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.Type;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.expressions.ArgumentListFunctionExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicCollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicMapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicSetJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CommonAbstractCriteriaImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.ConstructorSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaDeleteImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaMultiSelectImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaUpdateImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.FunctionExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.JoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.ListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.MapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.OrderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.PathImpl;
import org.eclipse.persistence.internal.jpa.querydef.PredicateImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.SetJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.jpa.JpaCriteriaBuilder;
import org.eclipse.persistence.queries.ReportQuery;

public class CriteriaBuilderImpl
implements JpaCriteriaBuilder,
Serializable {
    public static final String CONCAT = "concat";
    public static final String SIZE = "size";
    protected Metamodel metamodel;

    public CriteriaBuilderImpl(Metamodel metamodel) {
        this.metamodel = metamodel;
    }

    public CriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this.metamodel, AbstractQueryImpl.ResultType.UNKNOWN, ClassConstants.OBJECT, this);
    }

    public <T> CriteriaQuery<T> createQuery(Class<T> resultClass) {
        if (resultClass == null) {
            return this.createQuery();
        }
        if (resultClass.equals(Tuple.class)) {
            return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.AOBJECT)) {
            return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.isArray()) {
            return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.OBJECT)) {
            return this.createQuery();
        }
        if (resultClass.isPrimitive() || resultClass.equals(ClassConstants.STRING) || BasicTypeHelperImpl.getInstance().isWrapperClass(resultClass) || BasicTypeHelperImpl.getInstance().isDateClass(resultClass)) {
            return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.OTHER, resultClass, this);
        }
        TypeImpl<T> type = ((MetamodelImpl)this.metamodel).getType(resultClass);
        if (type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.ENTITY, resultClass, this);
        }
        return new CriteriaQueryImpl<T>(this.metamodel, AbstractQueryImpl.ResultType.CONSTRUCTOR, resultClass, this);
    }

    public CriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, Tuple.class, this);
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> result, Selection<?> ... selections) {
        return new ConstructorSelectionImpl<Y>(result, selections);
    }

    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return new CompoundSelectionImpl<Tuple>(Tuple.class, selections, true);
    }

    public CompoundSelection<Tuple> tuple(List<Selection<?>> selections) {
        return this.tuple(selections != null ? selections.toArray(new Selection[0]) : null);
    }

    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return new CompoundSelectionImpl<Object[]>(ClassConstants.AOBJECT, selections, true);
    }

    public CompoundSelection<Object[]> array(List<Selection<?>> selections) {
        return this.array(selections != null ? selections.toArray(new Selection[0]) : null);
    }

    public Order asc(jakarta.persistence.criteria.Expression<?> expression) {
        return this.asc(expression, Nulls.NONE);
    }

    public Order asc(jakarta.persistence.criteria.Expression<?> expression, Nulls nullPrecedence) {
        if (ExpressionImpl.currentNode(expression) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new OrderImpl(expression, true, nullPrecedence);
    }

    public Order desc(jakarta.persistence.criteria.Expression<?> expression) {
        return this.desc(expression, Nulls.NONE);
    }

    public Order desc(jakarta.persistence.criteria.Expression<?> expression, Nulls nullPrecedence) {
        if (ExpressionImpl.currentNode(expression) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new OrderImpl(expression, false, nullPrecedence);
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<Double> avg(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionImpl.currentNode(x).average(), CriteriaBuilderImpl.buildList(x), "AVG");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionImpl.currentNode(x).sum(), CriteriaBuilderImpl.buildList(x), "SUM");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> max(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionImpl.currentNode(x).maximum(), CriteriaBuilderImpl.buildList(x), "MAX");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> min(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionImpl.currentNode(x).minimum(), CriteriaBuilderImpl.buildList(x), "MIN");
    }

    public <X extends Comparable<? super X>> jakarta.persistence.criteria.Expression<X> greatest(jakarta.persistence.criteria.Expression<X> x) {
        if (ExpressionImpl.currentNode(x) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ExpressionImpl.currentNode(x).maximum());
    }

    public <X extends Comparable<? super X>> jakarta.persistence.criteria.Expression<X> least(jakarta.persistence.criteria.Expression<X> x) {
        if (ExpressionImpl.currentNode(x) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ExpressionImpl.currentNode(x).minimum());
    }

    public jakarta.persistence.criteria.Expression<Long> count(jakarta.persistence.criteria.Expression<?> x) {
        if (ExpressionImpl.currentNode(x) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ExpressionImpl.currentNode(x).count(), CriteriaBuilderImpl.buildList(x), "COUNT");
    }

    public jakarta.persistence.criteria.Expression<Long> countDistinct(jakarta.persistence.criteria.Expression<?> x) {
        if (ExpressionImpl.currentNode(x) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ExpressionImpl.currentNode(x).distinct().count(), CriteriaBuilderImpl.buildList(x), "COUNT");
    }

    public Predicate exists(Subquery<?> subquery) {
        return new CompoundExpressionImpl(this.metamodel, Expression.getOperator((int)86).expressionFor(((SubQueryImpl)subquery).getCurrentNode()), CriteriaBuilderImpl.buildList(new jakarta.persistence.criteria.Expression[]{subquery}), "exists");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> all(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().all(ExpressionImpl.currentNode(subquery)), CriteriaBuilderImpl.buildList(new jakarta.persistence.criteria.Expression[]{subquery}), "all");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> some(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().some(ExpressionImpl.currentNode(subquery)), CriteriaBuilderImpl.buildList(new jakarta.persistence.criteria.Expression[]{subquery}), "some");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> any(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().any(ExpressionImpl.currentNode(subquery)), CriteriaBuilderImpl.buildList(new jakarta.persistence.criteria.Expression[]{subquery}), "any");
    }

    public Predicate and(jakarta.persistence.criteria.Expression<Boolean> x, jakarta.persistence.criteria.Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)x).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)y).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isJunction()) {
            if (((PredicateImpl)yp).getJunctionValue().booleanValue()) {
                return xp;
            }
            return yp;
        }
        if (xp.isJunction()) {
            if (((PredicateImpl)xp).getJunctionValue().booleanValue()) {
                return yp;
            }
            return xp;
        }
        Expression currentNode = xp.getCurrentNode().and(yp.getCurrentNode());
        xp.setParentNode(currentNode);
        yp.setParentNode(currentNode);
        return new PredicateImpl(this.metamodel, currentNode, CriteriaBuilderImpl.buildList(xp, yp), Predicate.BooleanOperator.AND);
    }

    public Predicate or(jakarta.persistence.criteria.Expression<Boolean> x, jakarta.persistence.criteria.Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)x).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)y).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isJunction()) {
            if (((PredicateImpl)yp).getJunctionValue().booleanValue()) {
                return yp;
            }
            return xp;
        }
        if (xp.isJunction()) {
            if (((PredicateImpl)xp).getJunctionValue().booleanValue()) {
                return xp;
            }
            return yp;
        }
        Expression parentNode = xp.getCurrentNode().or(yp.getCurrentNode());
        xp.setParentNode(parentNode);
        yp.setParentNode(parentNode);
        return new PredicateImpl(this.metamodel, parentNode, CriteriaBuilderImpl.buildList(xp, yp), Predicate.BooleanOperator.OR);
    }

    public Predicate and(Predicate ... restrictions) {
        return this.and(restrictions != null ? List.of(restrictions) : null);
    }

    public Predicate and(List<Predicate> restrictions) {
        switch (restrictions != null ? restrictions.size() : 0) {
            case 0: {
                return this.conjunction();
            }
            case 1: {
                return restrictions.get(0);
            }
            case 2: {
                return this.and((jakarta.persistence.criteria.Expression<Boolean>)((jakarta.persistence.criteria.Expression)restrictions.get(0)), (jakarta.persistence.criteria.Expression<Boolean>)((jakarta.persistence.criteria.Expression)restrictions.get(1)));
            }
        }
        Predicate predicate = restrictions.get(0);
        for (int i = 1; i < restrictions.size(); ++i) {
            predicate = this.and((jakarta.persistence.criteria.Expression<Boolean>)predicate, (jakarta.persistence.criteria.Expression<Boolean>)((jakarta.persistence.criteria.Expression)restrictions.get(i)));
        }
        return predicate;
    }

    public Predicate or(Predicate ... restrictions) {
        return this.or(restrictions != null ? List.of(restrictions) : null);
    }

    public Predicate or(List<Predicate> restrictions) {
        switch (restrictions != null ? restrictions.size() : 0) {
            case 0: {
                return this.disjunction();
            }
            case 1: {
                return restrictions.get(0);
            }
            case 2: {
                return this.or((jakarta.persistence.criteria.Expression<Boolean>)((jakarta.persistence.criteria.Expression)restrictions.get(0)), (jakarta.persistence.criteria.Expression<Boolean>)((jakarta.persistence.criteria.Expression)restrictions.get(1)));
            }
        }
        Predicate predicate = restrictions.get(0);
        for (int i = 1; i < restrictions.size(); ++i) {
            predicate = this.or((jakarta.persistence.criteria.Expression<Boolean>)predicate, (jakarta.persistence.criteria.Expression<Boolean>)((jakarta.persistence.criteria.Expression)restrictions.get(i)));
        }
        return predicate;
    }

    public Predicate not(jakarta.persistence.criteria.Expression<Boolean> restriction) {
        if (((InternalExpression)restriction).isPredicate()) {
            return ((Predicate)restriction).not();
        }
        Expression parentNode = null;
        List<jakarta.persistence.criteria.Expression<?>> compoundExpressions = null;
        String name = "not";
        if (((InternalExpression)restriction).isCompoundExpression() && ((CompoundExpressionImpl)restriction).getOperation().equals("exists")) {
            FunctionExpression exp = (FunctionExpression)ExpressionImpl.currentNode(restriction);
            SubSelectExpression sub = (SubSelectExpression)exp.getChildren().get(0);
            parentNode = Expression.getOperator((int)88).expressionFor((Expression)sub);
            name = "notExists";
            compoundExpressions = ((CompoundExpressionImpl)restriction).getChildExpressions();
        } else {
            parentNode = ExpressionImpl.currentNode(restriction).not();
            compoundExpressions = CriteriaBuilderImpl.buildList(restriction);
        }
        CompoundExpressionImpl expr = new CompoundExpressionImpl(this.metamodel, parentNode, compoundExpressions, name);
        expr.setIsNegated(true);
        return expr;
    }

    public Predicate conjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.AND);
    }

    public Predicate disjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.OR);
    }

    public Predicate isTrue(jakarta.persistence.criteria.Expression<Boolean> x) {
        if (((InternalExpression)x).isPredicate()) {
            if (ExpressionImpl.currentNode(x) == null) {
                return (Predicate)x;
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"PREDICATE_PASSED_TO_EVALUATION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).equal(true), CriteriaBuilderImpl.buildList(x), "equals");
    }

    public Predicate isFalse(jakarta.persistence.criteria.Expression<Boolean> x) {
        if (((InternalExpression)x).isPredicate()) {
            if (ExpressionImpl.currentNode(x) == null) {
                if (((Predicate)x).getOperator() == Predicate.BooleanOperator.AND) {
                    return (Predicate)x;
                }
                return this.conjunction();
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"PREDICATE_PASSED_TO_EVALUATION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).equal(false), CriteriaBuilderImpl.buildList(x), "equals");
    }

    public Predicate isNull(jakarta.persistence.criteria.Expression<?> x) {
        return new PredicateImpl(this.metamodel, ExpressionImpl.currentNode(x).isNull(), CriteriaBuilderImpl.buildList(x), Predicate.BooleanOperator.AND);
    }

    public Predicate isNotNull(jakarta.persistence.criteria.Expression<?> x) {
        return new PredicateImpl(this.metamodel, ExpressionImpl.currentNode(x).notNull(), CriteriaBuilderImpl.buildList(x), Predicate.BooleanOperator.AND);
    }

    public Predicate equal(jakarta.persistence.criteria.Expression<?> x, jakarta.persistence.criteria.Expression<?> y) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).equal(ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "equals");
    }

    public Predicate notEqual(jakarta.persistence.criteria.Expression<?> x, jakarta.persistence.criteria.Expression<?> y) {
        if (ExpressionImpl.currentNode(x) == null || ExpressionImpl.currentNode(y) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).notEqual(ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "not equal");
    }

    public Predicate equal(jakarta.persistence.criteria.Expression<?> x, Object y) {
        if (ExpressionImpl.currentNode(x) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y instanceof ParameterExpression) {
            return this.equal(x, (jakarta.persistence.criteria.Expression<?>)((ParameterExpression)y));
        }
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).equal(y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "equal");
    }

    public Predicate notEqual(jakarta.persistence.criteria.Expression<?> x, Object y) {
        if (ExpressionImpl.currentNode(x) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y instanceof ParameterExpression) {
            return this.notEqual(x, (jakarta.persistence.criteria.Expression<?>)((ParameterExpression)y));
        }
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).notEqual(y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "not equal");
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (ExpressionImpl.currentNode(x) == null || ExpressionImpl.currentNode(y) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).greaterThan(ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "greaterThan");
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (ExpressionImpl.currentNode(x) == null || ExpressionImpl.currentNode(y) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).lessThan(ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "lessThan");
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (ExpressionImpl.currentNode(x) == null || ExpressionImpl.currentNode(y) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).greaterThanEqual(ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "greaterThanEqual");
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (ExpressionImpl.currentNode(x) == null || ExpressionImpl.currentNode(y) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).lessThanEqual(ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "lessThanEqual");
    }

    public <Y extends Comparable<? super Y>> Predicate between(jakarta.persistence.criteria.Expression<? extends Y> v, jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(v).between(ExpressionImpl.currentNode(x), ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(v, x, y), "between");
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        if (ExpressionImpl.currentNode(x) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).greaterThan(ExpressionImpl.currentNode(expressionY)), CriteriaBuilderImpl.buildList(x, expressionY), "greaterThan");
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        if (ExpressionImpl.currentNode(x) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).lessThan(ExpressionImpl.currentNode(expressionY)), CriteriaBuilderImpl.buildList(x, expressionY), "lessThan");
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        if (ExpressionImpl.currentNode(x) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).greaterThanEqual(ExpressionImpl.currentNode(expressionY)), CriteriaBuilderImpl.buildList(x, expressionY), "greaterThanEqual");
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        if (ExpressionImpl.currentNode(x) == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).lessThanEqual(ExpressionImpl.currentNode(expressionY)), CriteriaBuilderImpl.buildList(x, expressionY), "lessThanEqual");
    }

    public <Y extends Comparable<? super Y>> Predicate between(jakarta.persistence.criteria.Expression<? extends Y> v, Y x, Y y) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(v).between(x, y), CriteriaBuilderImpl.buildList(v, this.internalLiteral(x), this.internalLiteral(y)), "between");
    }

    protected static List<jakarta.persistence.criteria.Expression<?>> buildList(jakarta.persistence.criteria.Expression<?> ... expressions) {
        ArrayList list = new ArrayList(expressions.length + 2);
        Collections.addAll(list, expressions);
        return list;
    }

    public Predicate gt(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).greaterThan(ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "gt");
    }

    public Predicate lt(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).lessThan(ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "lessThan");
    }

    public Predicate ge(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).greaterThanEqual(ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "ge");
    }

    public Predicate le(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).lessThanEqual(ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "le");
    }

    public Predicate gt(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).greaterThan((Object)y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "gt");
    }

    public Predicate lt(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).lessThan((Object)y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "lt");
    }

    public Predicate ge(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).greaterThanEqual((Object)y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "ge");
    }

    public Predicate le(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).lessThanEqual((Object)y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "le");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> neg(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.negate((Expression)ExpressionImpl.currentNode(x)), CriteriaBuilderImpl.buildList(x), "neg");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> abs(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.abs((Expression)ExpressionImpl.currentNode(x)), CriteriaBuilderImpl.buildList(x), "ABS");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(jakarta.persistence.criteria.Expression<? extends N> x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotionClass(x.getJavaType(), y.getJavaType()), ExpressionMath.add((Expression)ExpressionImpl.currentNode(x), (Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "sum");
    }

    public jakarta.persistence.criteria.Expression<Long> sumAsLong(jakarta.persistence.criteria.Expression<Integer> x) {
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ExpressionImpl.currentNode(x).sum(), CriteriaBuilderImpl.buildList(x), "SUM");
    }

    public jakarta.persistence.criteria.Expression<Double> sumAsDouble(jakarta.persistence.criteria.Expression<Float> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionImpl.currentNode(x).sum(), CriteriaBuilderImpl.buildList(x), "SUM");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> prod(jakarta.persistence.criteria.Expression<? extends N> x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotionClass(x.getJavaType(), y.getJavaType()), ExpressionMath.multiply((Expression)ExpressionImpl.currentNode(x), (Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "prod");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> diff(jakarta.persistence.criteria.Expression<? extends N> x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.subtract((Expression)ExpressionImpl.currentNode(x), (Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "diff");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(jakarta.persistence.criteria.Expression<? extends N> x, N y) {
        return new FunctionExpressionImpl(this.metamodel, BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotionClass(x.getJavaType(), y.getClass()), ExpressionMath.add((Expression)ExpressionImpl.currentNode(x), y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "sum");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> prod(jakarta.persistence.criteria.Expression<? extends N> x, N y) {
        return new FunctionExpressionImpl(this.metamodel, BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotionClass(x.getJavaType(), y.getClass()), ExpressionMath.multiply((Expression)ExpressionImpl.currentNode(x), y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "prod");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> diff(jakarta.persistence.criteria.Expression<? extends N> x, N y) {
        return new FunctionExpressionImpl(this.metamodel, y.getClass(), ExpressionMath.subtract((Expression)ExpressionImpl.currentNode(x), y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "diff");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(N x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotionClass(x.getClass(), y.getJavaType()), ExpressionMath.add((Expression)new ConstantExpression(x, ExpressionImpl.currentNode(y)), (Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(this.internalLiteral(x), y), "sum");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> prod(N x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotionClass(x.getClass(), y.getJavaType()), ExpressionMath.multiply((Expression)new ConstantExpression(x, ExpressionImpl.currentNode(y)), (Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(this.internalLiteral(x), y), "prod");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> diff(N x, jakarta.persistence.criteria.Expression<? extends N> y) {
        jakarta.persistence.criteria.Expression<N> literal = this.internalLiteral(x);
        return new FunctionExpressionImpl(this.metamodel, literal.getJavaType(), ExpressionMath.subtract((Expression)ExpressionImpl.currentNode(literal), (Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(literal, y), "diff");
    }

    public jakarta.persistence.criteria.Expression<Number> quot(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotionClass(x.getJavaType(), y.getClass()), ExpressionMath.divide((Expression)ExpressionImpl.currentNode(x), (Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "quot");
    }

    public jakarta.persistence.criteria.Expression<Number> quot(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotionClass(x.getJavaType(), y.getClass()), ExpressionMath.divide((Expression)ExpressionImpl.currentNode(x), (Object)y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "quot");
    }

    public jakarta.persistence.criteria.Expression<Number> quot(Number x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, ClassConstants.NUMBER, ExpressionMath.divide((Expression)new ConstantExpression((Object)x, ExpressionImpl.currentNode(y)), (Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(this.internalLiteral(x), y), "quot");
    }

    public jakarta.persistence.criteria.Expression<Integer> mod(jakarta.persistence.criteria.Expression<Integer> x, jakarta.persistence.criteria.Expression<Integer> y) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod((Expression)ExpressionImpl.currentNode(x), (Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "mod");
    }

    public jakarta.persistence.criteria.Expression<Integer> mod(jakarta.persistence.criteria.Expression<Integer> x, Integer y) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod((Expression)ExpressionImpl.currentNode(x), (Object)y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "mod");
    }

    public jakarta.persistence.criteria.Expression<Integer> mod(Integer x, jakarta.persistence.criteria.Expression<Integer> y) {
        jakarta.persistence.criteria.Expression<Integer> xExp = this.internalLiteral(x);
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod((Expression)ExpressionImpl.currentNode(xExp), (Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(xExp, y), "mod");
    }

    public jakarta.persistence.criteria.Expression<Double> sqrt(jakarta.persistence.criteria.Expression<? extends Number> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.sqrt((Expression)ExpressionImpl.currentNode(x)), CriteriaBuilderImpl.buildList(x), "sqrt");
    }

    public jakarta.persistence.criteria.Expression<Integer> sign(jakarta.persistence.criteria.Expression<? extends Number> x) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.sign((Expression)ExpressionImpl.currentNode(x)), CriteriaBuilderImpl.buildList(x), "sign");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> ceiling(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.ceil((Expression)ExpressionImpl.currentNode(x)), CriteriaBuilderImpl.buildList(x), "ceiling");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> floor(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.floor((Expression)ExpressionImpl.currentNode(x)), CriteriaBuilderImpl.buildList(x), "floor");
    }

    public jakarta.persistence.criteria.Expression<Double> exp(jakarta.persistence.criteria.Expression<? extends Number> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.exp((Expression)ExpressionImpl.currentNode(x)), CriteriaBuilderImpl.buildList(x), "exp");
    }

    public jakarta.persistence.criteria.Expression<Double> ln(jakarta.persistence.criteria.Expression<? extends Number> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.ln((Expression)ExpressionImpl.currentNode(x)), CriteriaBuilderImpl.buildList(x), "ln");
    }

    public jakarta.persistence.criteria.Expression<Double> power(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.power((Expression)ExpressionImpl.currentNode(x), (Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "power");
    }

    public jakarta.persistence.criteria.Expression<Double> power(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.power((Expression)ExpressionImpl.currentNode(x), (Object)y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "power");
    }

    public <T extends Number> jakarta.persistence.criteria.Expression<T> round(jakarta.persistence.criteria.Expression<T> x, Integer n) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.round((Expression)ExpressionImpl.currentNode(x), (Object)n), CriteriaBuilderImpl.buildList(x, this.internalLiteral(n)), "round");
    }

    public jakarta.persistence.criteria.Expression<Long> toLong(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<Integer> toInteger(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<Float> toFloat(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<Double> toDouble(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<BigDecimal> toBigDecimal(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<BigInteger> toBigInteger(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<String> toString(jakarta.persistence.criteria.Expression<Character> character) {
        return character;
    }

    public <T> jakarta.persistence.criteria.Expression<T> literal(T value) {
        if (value == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"jpa_criteriaapi_null_literal_value", (Object[])new Object[0]));
        }
        return ExpressionImpl.createLiteral(value, this.metamodel);
    }

    public <T> jakarta.persistence.criteria.Expression<T> nullLiteral(Class<T> resultClass) {
        return ExpressionImpl.createLiteral(null, this.metamodel, resultClass);
    }

    protected <T> jakarta.persistence.criteria.Expression<T> internalLiteral(T value) {
        return ExpressionImpl.createLiteral(value, this.metamodel);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass, name);
    }

    public <C extends Collection<?>> Predicate isEmpty(jakarta.persistence.criteria.Expression<C> collection) {
        if (((InternalExpression)collection).isLiteral()) {
            if (((Collection)((ConstantExpression)ExpressionImpl.currentNode(collection)).getValue()).isEmpty()) {
                return this.conjunction();
            }
            return this.disjunction();
        }
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(collection).size(ClassConstants.INTEGER).equal(0), CriteriaBuilderImpl.buildList(collection), "isEmpty");
    }

    public <C extends Collection<?>> Predicate isNotEmpty(jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(collection).size(ClassConstants.INTEGER).equal(0).not(), CriteriaBuilderImpl.buildList(collection), "isNotEmpty");
    }

    public <C extends Collection<?>> jakarta.persistence.criteria.Expression<Integer> size(C collection) {
        return this.internalLiteral(collection.size());
    }

    public <C extends Collection<?>> jakarta.persistence.criteria.Expression<Integer> size(jakarta.persistence.criteria.Expression<C> collection) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionImpl.currentNode(collection).size(ClassConstants.INTEGER), CriteriaBuilderImpl.buildList(collection), SIZE);
    }

    public <E, C extends Collection<E>> Predicate isMember(E elem, jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(collection).equal(elem), CriteriaBuilderImpl.buildList(collection, this.internalLiteral(elem)), "isMember");
    }

    public <E, C extends Collection<E>> Predicate isNotMember(E elem, jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(collection).notEqual(elem), CriteriaBuilderImpl.buildList(collection, this.internalLiteral(elem)), "isMember");
    }

    public <E, C extends Collection<E>> Predicate isMember(jakarta.persistence.criteria.Expression<E> elem, jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(collection).equal(ExpressionImpl.currentNode(elem)), CriteriaBuilderImpl.buildList(collection, elem), "isMember");
    }

    public <E, C extends Collection<E>> Predicate isNotMember(jakarta.persistence.criteria.Expression<E> elem, jakarta.persistence.criteria.Expression<C> collection) {
        ReportQuery subQuery = new ReportQuery();
        subQuery.setReferenceClass(((ExpressionImpl)elem).getJavaType());
        ExpressionBuilder elemBuilder = new ExpressionBuilder();
        Expression collectionExp = ExpressionImpl.currentNode(collection);
        Expression elemExp = ExpressionImpl.currentNode(elem);
        subQuery.setExpressionBuilder(elemBuilder);
        subQuery.setShouldRetrieveFirstPrimaryKey(true);
        subQuery.setSelectionCriteria(elemBuilder.equal(collectionExp).and(collectionExp.equal(elemExp)));
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(elem).notExists(subQuery), CriteriaBuilderImpl.buildList(elem, collection), "isNotMemeber");
    }

    public <V, M extends Map<?, V>> jakarta.persistence.criteria.Expression<Collection<V>> values(M map) {
        return this.internalLiteral(map.values());
    }

    public <K, M extends Map<K, ?>> jakarta.persistence.criteria.Expression<Set<K>> keys(M map) {
        return this.internalLiteral(map.keySet());
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).like(ExpressionImpl.currentNode(pattern)), CriteriaBuilderImpl.buildList(x, pattern), "like");
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).like(ExpressionImpl.currentNode(pattern), ExpressionImpl.currentNode(escapeChar)), CriteriaBuilderImpl.buildList(x, pattern, escapeChar), "like");
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return this.like(x, pattern, this.internalLiteral(Character.valueOf(escapeChar)));
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, String pattern) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).like(pattern), CriteriaBuilderImpl.buildList(x, this.internalLiteral(pattern)), "like");
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, String pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        return this.like(x, this.internalLiteral(pattern), escapeChar);
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, String pattern, char escapeChar) {
        String escapeString = String.valueOf(escapeChar);
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).like(pattern, escapeString), CriteriaBuilderImpl.buildList(x, this.internalLiteral(pattern), this.internalLiteral(Character.valueOf(escapeChar))), "like");
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).notLike(ExpressionImpl.currentNode(pattern)), CriteriaBuilderImpl.buildList(x, pattern), "notLike");
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).notLike(ExpressionImpl.currentNode(pattern), ExpressionImpl.currentNode(escapeChar)), CriteriaBuilderImpl.buildList(x, pattern, escapeChar), "like");
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return this.notLike(x, pattern, this.internalLiteral(Character.valueOf(escapeChar)));
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, String pattern) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionImpl.currentNode(x).notLike(pattern), CriteriaBuilderImpl.buildList(x, this.internalLiteral(pattern)), "notLike");
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, String pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        return this.notLike(x, this.internalLiteral(pattern), escapeChar);
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, String pattern, char escapeChar) {
        return this.notLike(x, this.internalLiteral(pattern), this.internalLiteral(Character.valueOf(escapeChar)));
    }

    public jakarta.persistence.criteria.Expression<String> concat(List<jakarta.persistence.criteria.Expression<String>> expressions) {
        switch (expressions != null ? expressions.size() : 0) {
            case 0: {
                return this.literal("");
            }
            case 1: {
                return expressions.get(0);
            }
            case 2: {
                return this.concat(expressions.get(0), expressions.get(1));
            }
        }
        jakarta.persistence.criteria.Expression<String> expression = expressions.get(0);
        for (int i = 1; i < expressions.size(); ++i) {
            expression = this.concat(expression, expressions.get(i));
        }
        return expression;
    }

    public jakarta.persistence.criteria.Expression<String> concat(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> y) {
        Expression xNode = ExpressionImpl.currentNode(x);
        Expression yNode = ExpressionImpl.currentNode(y);
        if (xNode.isParameterExpression() && yNode.isParameterExpression()) {
            ((org.eclipse.persistence.internal.expressions.ParameterExpression)xNode).setType((Object)ClassConstants.STRING);
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, xNode.concat((Object)yNode), CriteriaBuilderImpl.buildList(x, y), CONCAT);
    }

    public jakarta.persistence.criteria.Expression<String> concat(jakarta.persistence.criteria.Expression<String> x, String y) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).concat((Object)y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), CONCAT);
    }

    public jakarta.persistence.criteria.Expression<String> concat(String x, jakarta.persistence.criteria.Expression<String> y) {
        jakarta.persistence.criteria.Expression<String> literal = this.internalLiteral(x);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(literal).concat((Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(literal, y), CONCAT);
    }

    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<Integer> from) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).substring((Object)ExpressionImpl.currentNode(from)), CriteriaBuilderImpl.buildList(x, from), "subString");
    }

    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, int from) {
        return this.substring(x, this.internalLiteral(from));
    }

    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<Integer> from, jakarta.persistence.criteria.Expression<Integer> len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).substring((Object)ExpressionImpl.currentNode(from), (Object)ExpressionImpl.currentNode(len)), CriteriaBuilderImpl.buildList(x, from, len), "subString");
    }

    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, int from, int len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).substring(from, len), CriteriaBuilderImpl.buildList(x, this.internalLiteral(from), this.internalLiteral(len)), "subString");
    }

    public jakarta.persistence.criteria.Expression<String> trim(jakarta.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).trim(), CriteriaBuilderImpl.buildList(x), "trim");
    }

    public jakarta.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, jakarta.persistence.criteria.Expression<String> x) {
        if (ts == CriteriaBuilder.Trimspec.LEADING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).leftTrim(), CriteriaBuilderImpl.buildList(x), "leftTrim");
        }
        if (ts == CriteriaBuilder.Trimspec.TRAILING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).rightTrim(), CriteriaBuilderImpl.buildList(x), "rightTrim");
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).rightTrim().leftTrim(), CriteriaBuilderImpl.buildList(x), "bothTrim");
    }

    public jakarta.persistence.criteria.Expression<String> trim(jakarta.persistence.criteria.Expression<Character> t, jakarta.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).trim((Object)ExpressionImpl.currentNode(t)), CriteriaBuilderImpl.buildList(x, t), "trim");
    }

    public jakarta.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, jakarta.persistence.criteria.Expression<Character> t, jakarta.persistence.criteria.Expression<String> x) {
        if (ts == CriteriaBuilder.Trimspec.LEADING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).leftTrim((Object)ExpressionImpl.currentNode(t)), CriteriaBuilderImpl.buildList(x, t), "leftTrim");
        }
        if (ts == CriteriaBuilder.Trimspec.TRAILING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).rightTrim((Object)ExpressionImpl.currentNode(t)), CriteriaBuilderImpl.buildList(x, t), "rightTrim");
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).rightTrim((Object)ExpressionImpl.currentNode(t)).leftTrim((Object)ExpressionImpl.currentNode(t)), CriteriaBuilderImpl.buildList(x, t), "bothTrim");
    }

    public jakarta.persistence.criteria.Expression<String> trim(char t, jakarta.persistence.criteria.Expression<String> x) {
        return this.trim(this.internalLiteral(Character.valueOf(t)), x);
    }

    public jakarta.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, char t, jakarta.persistence.criteria.Expression<String> x) {
        return this.trim(ts, this.internalLiteral(Character.valueOf(t)), x);
    }

    public jakarta.persistence.criteria.Expression<String> lower(jakarta.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).toLowerCase(), CriteriaBuilderImpl.buildList(x), "lower");
    }

    public jakarta.persistence.criteria.Expression<String> upper(jakarta.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(x).toUpperCase(), CriteriaBuilderImpl.buildList(x), "upper");
    }

    public jakarta.persistence.criteria.Expression<Integer> length(jakarta.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionImpl.currentNode(x).length(), CriteriaBuilderImpl.buildList(x), "length");
    }

    public jakarta.persistence.criteria.Expression<String> left(jakarta.persistence.criteria.Expression<String> expression, int len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(expression).left(len), CriteriaBuilderImpl.buildList(expression), "left");
    }

    public jakarta.persistence.criteria.Expression<String> left(jakarta.persistence.criteria.Expression<String> expression, jakarta.persistence.criteria.Expression<Integer> len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(expression).left((Object)ExpressionImpl.currentNode(len)), CriteriaBuilderImpl.buildList(expression), "left");
    }

    public jakarta.persistence.criteria.Expression<String> right(jakarta.persistence.criteria.Expression<String> expression, int len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(expression).right(len), CriteriaBuilderImpl.buildList(expression), "right");
    }

    public jakarta.persistence.criteria.Expression<String> right(jakarta.persistence.criteria.Expression<String> expression, jakarta.persistence.criteria.Expression<Integer> len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(expression).right((Object)ExpressionImpl.currentNode(len)), CriteriaBuilderImpl.buildList(expression), "right");
    }

    public jakarta.persistence.criteria.Expression<String> replace(jakarta.persistence.criteria.Expression<String> expression, jakarta.persistence.criteria.Expression<String> substring, jakarta.persistence.criteria.Expression<String> replacement) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(expression).replace((Object)ExpressionImpl.currentNode(substring), (Object)ExpressionImpl.currentNode(replacement)), CriteriaBuilderImpl.buildList(expression), "replace");
    }

    public jakarta.persistence.criteria.Expression<String> replace(jakarta.persistence.criteria.Expression<String> expression, String substring, jakarta.persistence.criteria.Expression<String> replacement) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(expression).replace((Object)substring, (Object)ExpressionImpl.currentNode(replacement)), CriteriaBuilderImpl.buildList(expression), "replace");
    }

    public jakarta.persistence.criteria.Expression<String> replace(jakarta.persistence.criteria.Expression<String> expression, jakarta.persistence.criteria.Expression<String> substring, String replacement) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(expression).replace((Object)ExpressionImpl.currentNode(substring), (Object)replacement), CriteriaBuilderImpl.buildList(expression), "replace");
    }

    public jakarta.persistence.criteria.Expression<String> replace(jakarta.persistence.criteria.Expression<String> expression, String substring, String replacement) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ExpressionImpl.currentNode(expression).replace((Object)substring, (Object)replacement), CriteriaBuilderImpl.buildList(expression), "replace");
    }

    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionImpl.currentNode(x).locate((Object)ExpressionImpl.currentNode(pattern)), CriteriaBuilderImpl.buildList(x, pattern), "locate");
    }

    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, jakarta.persistence.criteria.Expression<Integer> from) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionImpl.currentNode(x).locate((Object)ExpressionImpl.currentNode(pattern), (Object)ExpressionImpl.currentNode(from)), CriteriaBuilderImpl.buildList(x, pattern, from), "locate");
    }

    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, String pattern) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionImpl.currentNode(x).locate((Object)pattern), CriteriaBuilderImpl.buildList(x, this.internalLiteral(pattern)), "locate");
    }

    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, String pattern, int from) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionImpl.currentNode(x).locate(pattern, from), CriteriaBuilderImpl.buildList(x, this.internalLiteral(pattern), this.internalLiteral(from)), "locate");
    }

    public jakarta.persistence.criteria.Expression<Date> currentDate() {
        return new ExpressionImpl<Date>(this.metamodel, ClassConstants.SQLDATE, new ExpressionBuilder().currentDateDate());
    }

    public jakarta.persistence.criteria.Expression<Timestamp> currentTimestamp() {
        return new ExpressionImpl<Timestamp>(this.metamodel, ClassConstants.TIMESTAMP, new ExpressionBuilder().currentTimeStamp());
    }

    public jakarta.persistence.criteria.Expression<Time> currentTime() {
        return new ExpressionImpl<Time>(this.metamodel, ClassConstants.TIME, new ExpressionBuilder().currentTime());
    }

    public jakarta.persistence.criteria.Expression<LocalDateTime> localDateTime() {
        return new ExpressionImpl<LocalDateTime>(this.metamodel, ClassConstants.LOCAL_DATETIME, new ExpressionBuilder().localDateTime());
    }

    public jakarta.persistence.criteria.Expression<LocalDate> localDate() {
        return new ExpressionImpl<LocalDate>(this.metamodel, ClassConstants.LOCAL_DATE, new ExpressionBuilder().localDate());
    }

    public jakarta.persistence.criteria.Expression<LocalTime> localTime() {
        return new ExpressionImpl<LocalTime>(this.metamodel, ClassConstants.LOCAL_TIME, new ExpressionBuilder().localTime());
    }

    public <N, T extends Temporal> jakarta.persistence.criteria.Expression<N> extract(TemporalField<N, T> field, jakarta.persistence.criteria.Expression<T> temporal) {
        return new FunctionExpressionImpl(this.metamodel, temporal.getJavaType(), ExpressionImpl.currentNode(temporal).extract(field.toString()), CriteriaBuilderImpl.buildList(temporal), "extract");
    }

    public <T> CriteriaBuilder.In<T> in(jakarta.persistence.criteria.Expression<? extends T> expression) {
        return new InImpl(this.metamodel, (ExpressionImpl)expression, new ArrayList(), CriteriaBuilderImpl.buildList(expression));
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> coalesce(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        ArgumentListFunctionExpression coalesce = ExpressionImpl.currentNode(x).coalesce();
        Expression expX = ExpressionImpl.currentNode(x);
        expX = Expression.from((Object)expX, (Expression)coalesce);
        coalesce.addChild(expX);
        Expression expY = ExpressionImpl.currentNode(y);
        expY = Expression.from((Object)expY, (Expression)coalesce);
        coalesce.addChild(expY);
        return new CoalesceImpl(this.metamodel, x.getJavaType(), (Expression)coalesce, CriteriaBuilderImpl.buildList(x, y), "coalesce");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> coalesce(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        ArgumentListFunctionExpression coalesce = ExpressionImpl.currentNode(x).coalesce();
        Expression expX = ExpressionImpl.currentNode(x);
        expX = Expression.from((Object)expX, (Expression)coalesce);
        coalesce.addChild(expX);
        Expression expY = Expression.from(y, (Expression)new ExpressionBuilder());
        coalesce.addChild(expY);
        return new CoalesceImpl(this.metamodel, x.getJavaType(), (Expression)coalesce, CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "coalesce");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> nullif(jakarta.persistence.criteria.Expression<Y> x, jakarta.persistence.criteria.Expression<?> y) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionImpl.currentNode(x).nullIf((Object)ExpressionImpl.currentNode(y)), CriteriaBuilderImpl.buildList(x, y), "nullIf");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> nullif(jakarta.persistence.criteria.Expression<Y> x, Y y) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionImpl.currentNode(x).nullIf(y), CriteriaBuilderImpl.buildList(x, this.internalLiteral(y)), "nullIf");
    }

    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        ArgumentListFunctionExpression coalesce = new ExpressionBuilder().coalesce();
        return new CoalesceImpl<Object>(this.metamodel, Object.class, (Expression)coalesce, new ArrayList());
    }

    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(jakarta.persistence.criteria.Expression<? extends C> expression) {
        ArgumentListFunctionExpression caseStatement = new ExpressionBuilder().caseStatement();
        return new SimpleCaseImpl<C, Object>(this.metamodel, Object.class, (FunctionExpression)caseStatement, new ArrayList(), expression);
    }

    public <R> CriteriaBuilder.Case<R> selectCase() {
        ArgumentListFunctionExpression caseStatement = new ExpressionBuilder().caseConditionStatement();
        return new CaseImpl<Object>(this.metamodel, Object.class, (Expression)caseStatement, new ArrayList());
    }

    public <T> jakarta.persistence.criteria.Expression<T> function(String name, Class<T> type, jakarta.persistence.criteria.Expression<?> ... args) {
        if (args != null && args.length > 0) {
            ArrayList<Expression> params = new ArrayList<Expression>();
            for (int index = 1; index < args.length; ++index) {
                jakarta.persistence.criteria.Expression<?> x = args[index];
                params.add(ExpressionImpl.currentNode(x));
            }
            return new FunctionExpressionImpl<T>(this.metamodel, type, ExpressionImpl.currentNode(args[0]).getFunctionWithArguments(name, params), CriteriaBuilderImpl.buildList(args), name);
        }
        return new FunctionExpressionImpl<T>(this.metamodel, type, new ExpressionBuilder().getFunction(name), new ArrayList(0), name);
    }

    @Override
    public <T> jakarta.persistence.criteria.Expression<T> fromExpression(Expression expression, Class<T> type) {
        return new FunctionExpressionImpl<T>(this.metamodel, type, expression, new ArrayList(0));
    }

    @Override
    public jakarta.persistence.criteria.Expression fromExpression(Expression expression) {
        return new FunctionExpressionImpl<Object>(this.metamodel, Object.class, expression, new ArrayList(0));
    }

    @Override
    public Expression toExpression(jakarta.persistence.criteria.Expression expression) {
        return ((SelectionImpl)expression).getCurrentNode();
    }

    public <T> CriteriaDelete<T> createCriteriaDelete(Class<T> targetEntity) {
        TypeImpl<T> type;
        if (targetEntity != null && (type = ((MetamodelImpl)this.metamodel).getType(targetEntity)) != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaDeleteImpl<T>(this.metamodel, this, targetEntity);
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_bean_class", (Object[])new Object[]{targetEntity}));
    }

    public <T> CriteriaUpdate<T> createCriteriaUpdate(Class<T> targetEntity) {
        TypeImpl<T> type;
        if (targetEntity != null && (type = ((MetamodelImpl)this.metamodel).getType(targetEntity)) != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaUpdateImpl<T>(this.metamodel, this, targetEntity);
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_bean_class", (Object[])new Object[]{targetEntity}));
    }

    public <X, T, V extends T> Join<X, V> treat(Join<X, T> join, Class<V> type) {
        JoinImpl parentJoin = (JoinImpl)join;
        JoinImpl joinImpl = new JoinImpl(parentJoin, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        joinImpl.isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    public <X, T, E extends T> CollectionJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        CollectionJoinImpl parentJoin = (CollectionJoinImpl)join;
        CollectionJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicCollectionJoinImpl ? new BasicCollectionJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new CollectionJoinImpl(join, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    public <X, T, E extends T> SetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        SetJoinImpl parentJoin = (SetJoinImpl)join;
        SetJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicSetJoinImpl ? new BasicSetJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new SetJoinImpl(join, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    public <X, T, E extends T> ListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        ListJoinImpl parentJoin = (ListJoinImpl)join;
        ListJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicListJoinImpl ? new BasicListJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new ListJoinImpl(join, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    public <X, K, T, V extends T> MapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type) {
        MapJoinImpl parentJoin = (MapJoinImpl)join;
        MapJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicMapJoinImpl ? new BasicMapJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new MapJoinImpl(join, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    public <X, T extends X> Path<T> treat(Path<X> path, Class<T> type) {
        PathImpl parentPath = (PathImpl)path;
        PathImpl newPath = (PathImpl)parentPath.clone();
        newPath.currentNode = newPath.currentNode.treat(type);
        newPath.pathParent = parentPath;
        newPath.javaType = type;
        newPath.modelArtifact = this.metamodel.managedType(type);
        return newPath;
    }

    public <X, T extends X> Root<T> treat(Root<X> root, Class<T> type) {
        RootImpl parentRoot = (RootImpl)root;
        EntityType entity = this.metamodel.entity(type);
        return new RootImpl<T>((ManagedType)entity, this.metamodel, type, parentRoot.currentNode.treat(type), (Bindable)entity);
    }

    public <T> CriteriaSelect<T> union(CriteriaSelect<? extends T> first, CriteriaSelect<? extends T> second) {
        return new CriteriaMultiSelectImpl<T>(first, second, CriteriaMultiSelectImpl.Union.UNION);
    }

    public <T> CriteriaSelect<T> unionAll(CriteriaSelect<? extends T> first, CriteriaSelect<? extends T> second) {
        return new CriteriaMultiSelectImpl<T>(first, second, CriteriaMultiSelectImpl.Union.UNION_ALL);
    }

    public <T> CriteriaSelect<T> intersect(CriteriaSelect<? super T> first, CriteriaSelect<? super T> second) {
        return new CriteriaMultiSelectImpl<T>(first, second, CriteriaMultiSelectImpl.Union.INTERSECT);
    }

    public <T> CriteriaSelect<T> intersectAll(CriteriaSelect<? super T> first, CriteriaSelect<? super T> second) {
        return new CriteriaMultiSelectImpl<T>(first, second, CriteriaMultiSelectImpl.Union.INTERSECT_ALL);
    }

    public <T> CriteriaSelect<T> except(CriteriaSelect<T> first, CriteriaSelect<?> second) {
        return new CriteriaMultiSelectImpl<T>(first, second, CriteriaMultiSelectImpl.Union.EXCEPT);
    }

    public <T> CriteriaSelect<T> exceptAll(CriteriaSelect<T> first, CriteriaSelect<?> second) {
        return new CriteriaMultiSelectImpl<T>(first, second, CriteriaMultiSelectImpl.Union.EXCEPT_ALL);
    }

    public class CoalesceImpl<X>
    extends FunctionExpressionImpl<X>
    implements CriteriaBuilder.Coalesce<X> {
        protected <T> CoalesceImpl(Metamodel metamodel, Class<? extends X> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions) {
            super(metamodel, resultClass, expressionNode, compoundExpressions);
        }

        protected <T> CoalesceImpl(Metamodel metamodel, Class<? extends X> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, String operator) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
        }

        public CriteriaBuilder.Coalesce<X> value(X value) {
            Expression exp = Expression.from(value, (Expression)new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(exp);
            jakarta.persistence.criteria.Expression<X> valueLiteral = CriteriaBuilderImpl.this.internalLiteral(value);
            this.expressions.add(valueLiteral);
            return this;
        }

        public CriteriaBuilder.Coalesce<X> value(jakarta.persistence.criteria.Expression<? extends X> value) {
            Expression exp = CoalesceImpl.currentNode(value);
            exp = Expression.from((Object)exp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(exp);
            this.expressions.add(value);
            return this;
        }
    }

    public class SimpleCaseImpl<C, R>
    extends FunctionExpressionImpl<R>
    implements CriteriaBuilder.SimpleCase<C, R> {
        private final jakarta.persistence.criteria.Expression<? extends C> expression;
        private jakarta.persistence.criteria.Expression<? extends R> elseExpression;

        protected SimpleCaseImpl(Metamodel metamodel, Class<? extends R> resultClass, FunctionExpression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, jakarta.persistence.criteria.Expression<? extends C> expression) {
            super(metamodel, resultClass, (Expression)expressionNode, compoundExpressions);
            this.expression = expression;
            expressionNode.addChild(SimpleCaseImpl.currentNode(expression));
        }

        protected SimpleCaseImpl(Metamodel metamodel, Class<? extends R> resultClass, FunctionExpression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, String operator, jakarta.persistence.criteria.Expression<? extends C> expression) {
            super(metamodel, resultClass, (Expression)expressionNode, compoundExpressions, operator);
            this.expression = expression;
            expressionNode.addChild(SimpleCaseImpl.currentNode(expression));
        }

        public jakarta.persistence.criteria.Expression<C> getExpression() {
            return this.expression;
        }

        public CriteriaBuilder.SimpleCase<C, R> when(C condition, R result) {
            Expression conditionExp = Expression.from(condition, (Expression)new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            jakarta.persistence.criteria.Expression<C> conditionLiteral = CriteriaBuilderImpl.this.internalLiteral(condition);
            this.expressions.add(conditionLiteral);
            Expression resultExp = Expression.from(result, (Expression)new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            jakarta.persistence.criteria.Expression<R> resultLiteral = CriteriaBuilderImpl.this.internalLiteral(result);
            this.expressions.add(resultLiteral);
            this.setJavaType(resultLiteral.getJavaType());
            return this;
        }

        public CriteriaBuilder.SimpleCase<C, R> when(C condition, jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = Expression.from(condition, (Expression)new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            jakarta.persistence.criteria.Expression<C> conditionLiteral = CriteriaBuilderImpl.this.internalLiteral(condition);
            this.expressions.add(conditionLiteral);
            Expression resultExp = SimpleCaseImpl.currentNode(result);
            resultExp = Expression.from((Object)resultExp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            this.expressions.add(result);
            this.setJavaType(result.getJavaType());
            return this;
        }

        public CriteriaBuilder.SimpleCase<C, R> when(jakarta.persistence.criteria.Expression<? extends C> condition, R result) {
            Expression conditionExp = SimpleCaseImpl.currentNode(condition);
            conditionExp = Expression.from((Object)conditionExp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            this.expressions.add(condition);
            Expression resultExp = Expression.from(result, (Expression)new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            jakarta.persistence.criteria.Expression<R> resultLiteral = CriteriaBuilderImpl.this.internalLiteral(result);
            this.expressions.add(resultLiteral);
            this.setJavaType(resultLiteral.getJavaType());
            return this;
        }

        public CriteriaBuilder.SimpleCase<C, R> when(jakarta.persistence.criteria.Expression<? extends C> condition, jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = SimpleCaseImpl.currentNode(condition);
            conditionExp = Expression.from((Object)conditionExp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            this.expressions.add(condition);
            Expression resultExp = SimpleCaseImpl.currentNode(result);
            resultExp = Expression.from((Object)resultExp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            this.expressions.add(result);
            this.setJavaType(result.getJavaType());
            return this;
        }

        public jakarta.persistence.criteria.Expression<R> otherwise(R result) {
            Expression resultExp = Expression.from(result, (Expression)new ExpressionBuilder());
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            jakarta.persistence.criteria.Expression<R> resultLiteral = CriteriaBuilderImpl.this.internalLiteral(result);
            this.elseExpression = resultLiteral;
            this.setJavaType(resultLiteral.getJavaType());
            return this;
        }

        public jakarta.persistence.criteria.Expression<R> otherwise(jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression resultExp = SimpleCaseImpl.currentNode(result);
            resultExp = Expression.from((Object)resultExp, (Expression)this.currentNode);
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            this.elseExpression = result;
            this.setJavaType(result.getJavaType());
            return this;
        }

        @Override
        public void findRootAndParameters(CommonAbstractCriteriaImpl<?> query) {
            super.findRootAndParameters(query);
            if (this.expression != null) {
                ((InternalSelection)this.expression).findRootAndParameters(query);
            }
            if (this.elseExpression != null) {
                ((InternalSelection)this.elseExpression).findRootAndParameters(query);
            }
        }
    }

    public class CaseImpl<R>
    extends FunctionExpressionImpl<R>
    implements CriteriaBuilder.Case<R> {
        private jakarta.persistence.criteria.Expression<? extends R> elseExpression;

        protected <T> CaseImpl(Metamodel metamodel, Class<R> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions) {
            super(metamodel, resultClass, expressionNode, compoundExpressions);
        }

        protected <T> CaseImpl(Metamodel metamodel, Class<R> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, String operator) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
        }

        public CriteriaBuilder.Case<R> when(jakarta.persistence.criteria.Expression<Boolean> condition, R result) {
            Expression conditionExp = CaseImpl.currentNode(condition);
            conditionExp = Expression.from((Object)conditionExp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            this.expressions.add(condition);
            Expression resultExp = Expression.from(result, (Expression)new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            jakarta.persistence.criteria.Expression<R> resultLiteral = CriteriaBuilderImpl.this.internalLiteral(result);
            this.expressions.add(resultLiteral);
            this.setJavaType(resultLiteral.getJavaType());
            return this;
        }

        public CriteriaBuilder.Case<R> when(jakarta.persistence.criteria.Expression<Boolean> condition, jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = CaseImpl.currentNode(condition);
            conditionExp = Expression.from((Object)conditionExp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            this.expressions.add(condition);
            Expression resultExp = CaseImpl.currentNode(result);
            resultExp = Expression.from((Object)resultExp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            this.expressions.add(result);
            this.setJavaType(result.getJavaType());
            return this;
        }

        public jakarta.persistence.criteria.Expression<R> otherwise(R result) {
            Expression resultExp = Expression.from(result, (Expression)new ExpressionBuilder());
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            jakarta.persistence.criteria.Expression<R> resultLiteral = CriteriaBuilderImpl.this.internalLiteral(result);
            this.elseExpression = resultLiteral;
            this.setJavaType(resultLiteral.getJavaType());
            return this;
        }

        public jakarta.persistence.criteria.Expression<R> otherwise(jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression resultExp = CaseImpl.currentNode(result);
            resultExp = Expression.from((Object)resultExp, (Expression)this.currentNode);
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            this.elseExpression = result;
            this.setJavaType(result.getJavaType());
            return this;
        }

        @Override
        public void findRootAndParameters(CommonAbstractCriteriaImpl<?> query) {
            super.findRootAndParameters(query);
            if (this.elseExpression != null) {
                ((InternalSelection)this.elseExpression).findRootAndParameters(query);
            }
        }
    }
}

