/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.mbeans.drda.NetworkServerMBean;
import org.apache.derby.shared.common.security.SystemPermission;

class NetworkServerMBeanImpl
implements NetworkServerMBean {
    private NetworkServerControlImpl server;
    private final long startTime;
    private static final SystemPermission CONTROL = new SystemPermission("server", "control");
    private static final SystemPermission MONITOR = new SystemPermission("server", "monitor");
    private long lastReceiveTime = System.currentTimeMillis();
    private long lastReceiveBytes = 0L;
    private int receiveResult = 0;
    private long lastSentTime = System.currentTimeMillis();
    private long lastSentBytes = 0L;
    private int sentResult = 0;

    NetworkServerMBeanImpl(NetworkServerControlImpl networkServerControlImpl) {
        this.server = networkServerControlImpl;
        this.startTime = System.currentTimeMillis();
    }

    private static void checkControl() {
        NetworkServerMBeanImpl.checkPermission(CONTROL);
    }

    private static void checkMonitor() {
        NetworkServerMBeanImpl.checkPermission(MONITOR);
    }

    private static void checkPermission(SystemPermission systemPermission) {
    }

    @Override
    public String getDrdaHost() {
        NetworkServerMBeanImpl.checkControl();
        String string = this.getServerProperty("derby.drda.host");
        return string;
    }

    @Override
    public boolean getDrdaKeepAlive() {
        NetworkServerMBeanImpl.checkMonitor();
        String string = this.getServerProperty("derby.drda.keepAlive");
        return "true".equals(string);
    }

    @Override
    public int getDrdaMaxThreads() {
        NetworkServerMBeanImpl.checkMonitor();
        int n = 0;
        String string = this.getServerProperty("derby.drda.maxThreads");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public int getDrdaPortNumber() {
        NetworkServerMBeanImpl.checkControl();
        int n = 1527;
        String string = this.getServerProperty("derby.drda.portNumber");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public String getDrdaSecurityMechanism() {
        NetworkServerMBeanImpl.checkControl();
        String string = this.getServerProperty("derby.drda.securityMechanism");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public String getDrdaSslMode() {
        NetworkServerMBeanImpl.checkControl();
        String string = this.getServerProperty("derby.drda.sslMode");
        return string;
    }

    @Override
    public int getDrdaStreamOutBufferSize() {
        NetworkServerMBeanImpl.checkMonitor();
        int n = PropertyUtil.getSystemInt("derby.drda.streamOutBufferSize", 0);
        return n;
    }

    @Override
    public int getDrdaTimeSlice() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getTimeSlice();
    }

    @Override
    public boolean getDrdaTraceAll() {
        NetworkServerMBeanImpl.checkMonitor();
        String string = this.getServerProperty("derby.drda.traceAll");
        return "true".equals(string);
    }

    @Override
    public String getDrdaTraceDirectory() {
        NetworkServerMBeanImpl.checkControl();
        String string = null;
        string = this.getServerProperty("derby.drda.traceDirectory");
        if (string == null) {
            string = this.getServerProperty("derby.system.home");
        }
        if (string == null) {
            string = PropertyUtil.getSystemProperty("user.dir");
        }
        return string;
    }

    @Override
    public int getConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.getActiveConnectionCount() + this.getWaitingConnectionCount();
    }

    @Override
    public int getActiveConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getActiveSessions();
    }

    @Override
    public int getWaitingConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getRunQueueSize();
    }

    @Override
    public int getConnectionThreadPoolSize() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getThreadListSize();
    }

    @Override
    public int getAccumulatedConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getConnectionNumber();
    }

    @Override
    public long getBytesReceived() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getBytesRead();
    }

    @Override
    public long getBytesSent() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getBytesWritten();
    }

    @Override
    public synchronized int getBytesReceivedPerSecond() {
        NetworkServerMBeanImpl.checkMonitor();
        long l = System.currentTimeMillis();
        if (l - this.lastReceiveTime >= 1000L) {
            long l2 = this.getBytesReceived();
            this.receiveResult = (int)((l2 - this.lastReceiveBytes) * 1000L / (l - this.lastReceiveTime));
            this.lastReceiveTime = l;
            this.lastReceiveBytes = l2;
        }
        return this.receiveResult;
    }

    @Override
    public synchronized int getBytesSentPerSecond() {
        NetworkServerMBeanImpl.checkMonitor();
        long l = System.currentTimeMillis();
        if (l - this.lastSentTime >= 1000L) {
            long l2 = this.getBytesSent();
            this.sentResult = (int)((l2 - this.lastSentBytes) * 1000L / (l - this.lastSentTime));
            this.lastSentTime = l;
            this.lastSentBytes = l2;
        }
        return this.sentResult;
    }

    @Override
    public long getStartTime() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.startTime;
    }

    @Override
    public long getUptime() {
        NetworkServerMBeanImpl.checkMonitor();
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public void ping() throws Exception {
        NetworkServerMBeanImpl.checkMonitor();
        try {
            this.server.ping();
        }
        catch (Exception exception) {
            Monitor.logThrowable(exception);
            throw exception;
        }
    }

    private String getServerProperty(String string) {
        return this.server.getPropertyValues().getProperty(string);
    }
}

