/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import java.util.HashMap;
import java.util.Map;

class MethodOverridingChecker {
    private Map methodSignatures = new HashMap();
    private Erasurator erasurator;

    public MethodOverridingChecker(Erasurator er) {
        this.erasurator = er;
    }

    public void addMethod(MethodDescr m) {
        MethodDescr cloned_m = (MethodDescr)this.erasurator.processMember(m);
        assert (cloned_m.getSignature().indexOf("%") < 0) : "wrong member after erasure: " + m;
        this.methodSignatures.put(cloned_m.getSignature(), cloned_m);
    }

    public MethodDescr getOverridingMethod(MethodDescr m, boolean autoAdd) {
        MethodDescr cloned_m = (MethodDescr)this.erasurator.processMember(m);
        String signature = cloned_m.getSignature();
        MethodDescr isOverriding = (MethodDescr)this.methodSignatures.get(signature);
        if (isOverriding == null && autoAdd) {
            this.methodSignatures.put(signature, cloned_m);
        }
        return isOverriding;
    }

    public void addMethods(MemberDescription[] methods, String name) {
        for (int i = 0; i < methods.length; ++i) {
            MethodDescr md = (MethodDescr)methods[i];
            if (!name.equals(md.getName())) continue;
            this.addMethod(md);
        }
    }

    public void addMethods(MemberDescription[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            MethodDescr md = (MethodDescr)methods[i];
            this.addMethod(md);
        }
    }
}

