/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AccountUsableResponseControl
extends Control
implements DecodeableControl {
    public static final String ACCOUNT_USABLE_RESPONSE_OID = "1.3.6.1.4.1.42.2.27.9.5.8";
    private static final byte TYPE_SECONDS_UNTIL_EXPIRATION = -128;
    private static final byte TYPE_MORE_INFO = -95;
    private static final byte TYPE_IS_INACTIVE = -128;
    private static final byte TYPE_MUST_CHANGE = -127;
    private static final byte TYPE_IS_EXPIRED = -126;
    private static final byte TYPE_REMAINING_GRACE_LOGINS = -125;
    private static final byte TYPE_SECONDS_UNTIL_UNLOCK = -124;
    private static final long serialVersionUID = -9150988495337467770L;
    private final boolean isInactive;
    private final boolean isUsable;
    private final boolean mustChangePassword;
    private final boolean passwordIsExpired;
    private final List<String> unusableReasons;
    private final int remainingGraceLogins;
    private final int secondsUntilExpiration;
    private final int secondsUntilUnlock;

    AccountUsableResponseControl() {
        this.isUsable = false;
        this.secondsUntilExpiration = 0;
        this.isInactive = false;
        this.mustChangePassword = false;
        this.passwordIsExpired = false;
        this.remainingGraceLogins = 0;
        this.secondsUntilUnlock = 0;
        this.unusableReasons = Collections.emptyList();
    }

    public AccountUsableResponseControl(int secondsUntilExpiration) {
        super(ACCOUNT_USABLE_RESPONSE_OID, false, AccountUsableResponseControl.encodeValue(secondsUntilExpiration));
        this.isUsable = true;
        this.secondsUntilExpiration = secondsUntilExpiration;
        this.isInactive = false;
        this.mustChangePassword = false;
        this.passwordIsExpired = false;
        this.remainingGraceLogins = -1;
        this.secondsUntilUnlock = -1;
        this.unusableReasons = Collections.emptyList();
    }

    public AccountUsableResponseControl(boolean isInactive, boolean mustChangePassword, boolean passwordIsExpired, int remainingGraceLogins, int secondsUntilUnlock) {
        super(ACCOUNT_USABLE_RESPONSE_OID, false, AccountUsableResponseControl.encodeValue(isInactive, mustChangePassword, passwordIsExpired, remainingGraceLogins, secondsUntilUnlock));
        this.isUsable = false;
        this.secondsUntilExpiration = -1;
        this.isInactive = isInactive;
        this.mustChangePassword = mustChangePassword;
        this.passwordIsExpired = passwordIsExpired;
        this.remainingGraceLogins = remainingGraceLogins;
        this.secondsUntilUnlock = secondsUntilUnlock;
        ArrayList<String> unusableList = new ArrayList<String>(5);
        if (isInactive) {
            unusableList.add(ControlMessages.ERR_ACCT_UNUSABLE_INACTIVE.get());
        }
        if (mustChangePassword) {
            unusableList.add(ControlMessages.ERR_ACCT_UNUSABLE_MUST_CHANGE_PW.get());
        }
        if (passwordIsExpired) {
            unusableList.add(ControlMessages.ERR_ACCT_UNUSABLE_PW_EXPIRED.get());
        }
        if (remainingGraceLogins >= 0) {
            switch (remainingGraceLogins) {
                case 0: {
                    unusableList.add(ControlMessages.ERR_ACCT_UNUSABLE_REMAINING_GRACE_NONE.get());
                    break;
                }
                case 1: {
                    unusableList.add(ControlMessages.ERR_ACCT_UNUSABLE_REMAINING_GRACE_ONE.get());
                    break;
                }
                default: {
                    unusableList.add(ControlMessages.ERR_ACCT_UNUSABLE_REMAINING_GRACE_MULTIPLE.get(remainingGraceLogins));
                }
            }
        }
        if (secondsUntilUnlock > 0) {
            unusableList.add(ControlMessages.ERR_ACCT_UNUSABLE_SECONDS_UNTIL_UNLOCK.get(secondsUntilUnlock));
        }
        this.unusableReasons = Collections.unmodifiableList(unusableList);
    }

    /*
     * Unable to fully structure code
     */
    public AccountUsableResponseControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCOUNT_USABLE_RESPONSE_NO_VALUE.get());
        }
        try {
            valueElement = ASN1Element.decode(value.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCOUNT_USABLE_RESPONSE_VALUE_NOT_ELEMENT.get(new Object[]{e}), e);
        }
        decodedIsInactive = false;
        decodedMustChangePassword = false;
        decodedPasswordIsExpired = false;
        decodedRemainingGraceLogins = -1;
        decodedSecondsUntilExpiration = -1;
        decodedSecondsUntilUnlock = -1;
        decodedUnusableReasons = new ArrayList<String>(5);
        type = valueElement.getType();
        if (type == -128) {
            decodedIsUsable = true;
            try {
                decodedSecondsUntilExpiration = ASN1Integer.decodeAsInteger(valueElement).intValue();
                if (decodedSecondsUntilExpiration >= 0) ** GOTO lbl103
                decodedSecondsUntilExpiration = -1;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCOUNT_USABLE_RESPONSE_STE_NOT_INT.get(new Object[]{e}), e);
            }
        } else if (type == -95) {
            decodedIsUsable = false;
            try {
                elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCOUNT_USABLE_RESPONSE_VALUE_NOT_SEQUENCE.get(new Object[]{e}), e);
            }
            block27: for (ASN1Element element : elements) {
                switch (element.getType()) {
                    case -128: {
                        try {
                            decodedIsInactive = ASN1Boolean.decodeAsBoolean(element).booleanValue();
                            decodedUnusableReasons.add(ControlMessages.ERR_ACCT_UNUSABLE_INACTIVE.get());
                            continue block27;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCOUNT_USABLE_RESPONSE_INACTIVE_NOT_BOOLEAN.get(new Object[]{e}), e);
                        }
                    }
                    case -127: {
                        try {
                            decodedMustChangePassword = ASN1Boolean.decodeAsBoolean(element).booleanValue();
                            decodedUnusableReasons.add(ControlMessages.ERR_ACCT_UNUSABLE_MUST_CHANGE_PW.get());
                            continue block27;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCOUNT_USABLE_RESPONSE_MUST_CHANGE_NOT_BOOLEAN.get(new Object[]{e}), e);
                        }
                    }
                    case -126: {
                        try {
                            decodedPasswordIsExpired = ASN1Boolean.decodeAsBoolean(element).booleanValue();
                            decodedUnusableReasons.add(ControlMessages.ERR_ACCT_UNUSABLE_PW_EXPIRED.get());
                            continue block27;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCOUNT_USABLE_RESPONSE_IS_EXP_NOT_BOOLEAN.get(new Object[]{e}), e);
                        }
                    }
                    case -125: {
                        try {
                            decodedRemainingGraceLogins = ASN1Integer.decodeAsInteger(element).intValue();
                            if (decodedRemainingGraceLogins < 0) {
                                decodedRemainingGraceLogins = -1;
                                continue block27;
                            }
                            switch (decodedRemainingGraceLogins) {
                                case 0: {
                                    decodedUnusableReasons.add(ControlMessages.ERR_ACCT_UNUSABLE_REMAINING_GRACE_NONE.get());
                                    continue block27;
                                }
                                case 1: {
                                    decodedUnusableReasons.add(ControlMessages.ERR_ACCT_UNUSABLE_REMAINING_GRACE_ONE.get());
                                    continue block27;
                                }
                            }
                            decodedUnusableReasons.add(ControlMessages.ERR_ACCT_UNUSABLE_REMAINING_GRACE_MULTIPLE.get(new Object[]{decodedRemainingGraceLogins}));
                            continue block27;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCOUNT_USABLE_RESPONSE_GRACE_LOGINS_NOT_INT.get(new Object[]{e}), e);
                        }
                    }
                    case -124: {
                        try {
                            decodedSecondsUntilUnlock = ASN1Integer.decodeAsInteger(element).intValue();
                            if (decodedSecondsUntilUnlock < 0) {
                                decodedSecondsUntilUnlock = -1;
                                continue block27;
                            }
                            if (decodedSecondsUntilUnlock <= 0) continue block27;
                            decodedUnusableReasons.add(ControlMessages.ERR_ACCT_UNUSABLE_SECONDS_UNTIL_UNLOCK.get(new Object[]{decodedSecondsUntilUnlock}));
                            continue block27;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCOUNT_USABLE_RESPONSE_STU_NOT_INT.get(new Object[]{e}), e);
                        }
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCOUNT_USABLE_RESPONSE_MORE_INFO_INVALID_TYPE.get(new Object[]{StaticUtils.toHex(element.getType())}));
                    }
                }
            }
        } else {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCOUNT_USABLE_RESPONSE_INVALID_TYPE.get(new Object[]{StaticUtils.toHex(type)}));
        }
lbl103:
        // 3 sources

        this.isUsable = decodedIsUsable;
        this.secondsUntilExpiration = decodedSecondsUntilExpiration;
        this.isInactive = decodedIsInactive;
        this.mustChangePassword = decodedMustChangePassword;
        this.passwordIsExpired = decodedPasswordIsExpired;
        this.remainingGraceLogins = decodedRemainingGraceLogins;
        this.secondsUntilUnlock = decodedSecondsUntilUnlock;
        this.unusableReasons = Collections.unmodifiableList(decodedUnusableReasons);
    }

    private static ASN1OctetString encodeValue(int secondsUntilExpiration) {
        ASN1Integer sueInteger = new ASN1Integer(-128, secondsUntilExpiration);
        return new ASN1OctetString(sueInteger.encode());
    }

    private static ASN1OctetString encodeValue(boolean isInactive, boolean mustChangePassword, boolean passwordIsExpired, int remainingGraceLogins, int secondsUntilUnlock) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(5);
        if (isInactive) {
            elements.add(new ASN1Boolean(-128, true));
        }
        if (mustChangePassword) {
            elements.add(new ASN1Boolean(-127, true));
        }
        if (passwordIsExpired) {
            elements.add(new ASN1Boolean(-126, true));
        }
        if (remainingGraceLogins >= 0) {
            elements.add(new ASN1Integer(-125, remainingGraceLogins));
        }
        if (secondsUntilUnlock >= 0) {
            elements.add(new ASN1Integer(-124, secondsUntilUnlock));
        }
        ASN1Sequence valueSequence = new ASN1Sequence(-95, elements);
        return new ASN1OctetString(valueSequence.encode());
    }

    @Override
    public AccountUsableResponseControl decodeControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        return new AccountUsableResponseControl(oid, isCritical, value);
    }

    public static AccountUsableResponseControl get(SearchResultEntry entry) throws LDAPException {
        Control c = entry.getControl(ACCOUNT_USABLE_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof AccountUsableResponseControl) {
            return (AccountUsableResponseControl)c;
        }
        return new AccountUsableResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    public boolean isUsable() {
        return this.isUsable;
    }

    public List<String> getUnusableReasons() {
        return this.unusableReasons;
    }

    public int getSecondsUntilExpiration() {
        return this.secondsUntilExpiration;
    }

    public boolean isInactive() {
        return this.isInactive;
    }

    public boolean mustChangePassword() {
        return this.mustChangePassword;
    }

    public boolean passwordIsExpired() {
        return this.passwordIsExpired;
    }

    public int getRemainingGraceLogins() {
        return this.remainingGraceLogins;
    }

    public int getSecondsUntilUnlock() {
        return this.secondsUntilUnlock;
    }

    @Override
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_ACCOUNT_USABLE_RESPONSE.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("AccountUsableResponseControl(isUsable=");
        buffer.append(this.isUsable);
        if (this.isUsable) {
            if (this.secondsUntilExpiration >= 0) {
                buffer.append(", secondsUntilExpiration=");
                buffer.append(this.secondsUntilExpiration);
            }
        } else {
            buffer.append(", isInactive=");
            buffer.append(this.isInactive);
            buffer.append(", mustChangePassword=");
            buffer.append(this.mustChangePassword);
            buffer.append(", passwordIsExpired=");
            buffer.append(this.passwordIsExpired);
            if (this.remainingGraceLogins >= 0) {
                buffer.append(", remainingGraceLogins=");
                buffer.append(this.remainingGraceLogins);
            }
            if (this.secondsUntilUnlock >= 0) {
                buffer.append(", secondsUntilUnlock=");
                buffer.append(this.secondsUntilUnlock);
            }
        }
        buffer.append(')');
    }
}

