/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.serializers;

import ee.jakarta.tck.json.bind.customizedmapping.serializers.model.Animal;
import ee.jakarta.tck.json.bind.customizedmapping.serializers.model.AnimalShelter;
import ee.jakarta.tck.json.bind.customizedmapping.serializers.model.AnimalShelterWithSerializer;
import ee.jakarta.tck.json.bind.customizedmapping.serializers.model.Cat;
import ee.jakarta.tck.json.bind.customizedmapping.serializers.model.Dog;
import ee.jakarta.tck.json.bind.customizedmapping.serializers.model.serializer.AnimalDeserializer;
import ee.jakarta.tck.json.bind.customizedmapping.serializers.model.serializer.AnimalSerializer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class SerializersCustomizationTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testSerializerConfiguration() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withSerializers(new JsonbSerializer[]{new AnimalSerializer()}).withDeserializers(new JsonbDeserializer[]{new AnimalDeserializer()}));
        AnimalShelter animalShelter = new AnimalShelter();
        animalShelter.addAnimal(new Cat(5, "Garfield", 10.5f, true, true));
        animalShelter.addAnimal(new Dog(3, "Milo", 5.5f, false, true));
        animalShelter.addAnimal(new Animal(6, "Tweety", 0.5f, false));
        String jsonString = jsonb.toJson((Object)animalShelter);
        String validationRegexp = "\\{\\s*\"animals\"\\s*:\\s*\\[\\s*\\{\\s*\"type\"\\s*:\\s*\"cat\"\\s*,\\s*\"cuddly\"\\s*:\\s*true\\s*,\\s*\"age\"\\s*:\\s*5\\s*,\\s*\"furry\"\\s*:\\s*true\\s*,\\s*\"name\"\\s*:\\s*\"Garfield\"\\s*,\\s*\"weight\"\\s*:\\s*10.5\\s*}\\s*,\\s*\\{\\s*\"type\"\\s*:\\s*\"dog\"\\s*,\\s*\"barking\"\\s*:\\s*true\\s*,\\s*\"age\"\\s*:\\s*3\\s*,\\s*\"furry\"\\s*:\\s*false\\s*,\\s*\"name\"\\s*:\\s*\"Milo\"\\s*,\\s*\"weight\"\\s*:\\s*5.5\\s*}\\s*,\\s*\\{\\s*\"type\"\\s*:\\s*\"animal\"\\s*,\\s*\"age\"\\s*:\\s*6\\s*,\\s*\"furry\"\\s*:\\s*false\\s*,\\s*\"name\"\\s*:\\s*\"Tweety\"\\s*,\\s*\"weight\"\\s*:\\s*0.5\\s*}\\s*]\\s*}";
        MatcherAssert.assertThat((String)"Failed to correctly marshall complex type hierarchy using a serializer configured using JsonbConfig.withSerializers and a deserializer configured using JsonbConfig.withDeserializers.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationRegexp));
        String toDeserialize = "{ \"animals\" : [ { \"type\" : \"cat\", \"cuddly\" : true, \"age\" : 5, \"furry\" : true, \"name\" : \"Garfield\" , \"weight\" : 10.5}, { \"type\" : \"dog\", \"barking\" : true, \"age\" : 3, \"furry\" : false, \"name\" : \"Milo\", \"weight\" : 5.5}, { \"type\" : \"animal\", \"age\" : 6, \"furry\" : false, \"name\" : \"Tweety\", \"weight\" : 0.5} ] }";
        AnimalShelter unmarshalledObject = (AnimalShelter)jsonb.fromJson(toDeserialize, AnimalShelter.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshall complex type hierarchy using a serializer configured using JsonbConfig.withSerializers and a deserializer configured using JsonbConfig.withDeserializers.", (Object)unmarshalledObject, (Matcher)Matchers.is((Object)animalShelter));
    }

    @Test
    public void testSerializerAnnotation() {
        AnimalShelterWithSerializer animalShelter = new AnimalShelterWithSerializer();
        animalShelter.addAnimal(new Cat(5, "Garfield", 10.5f, true, true));
        animalShelter.addAnimal(new Dog(3, "Milo", 5.5f, false, true));
        animalShelter.addAnimal(new Animal(6, "Tweety", 0.5f, false));
        String jsonString = this.jsonb.toJson((Object)animalShelter);
        String validationRegexp = "\\{\\s*\"animals\"\\s*:\\s*\\[\\s*\\{\\s*\"type\"\\s*:\\s*\"cat\"\\s*,\\s*\"cuddly\"\\s*:\\s*true\\s*,\\s*\"age\"\\s*:\\s*5\\s*,\\s*\"furry\"\\s*:\\s*true\\s*,\\s*\"name\"\\s*:\\s*\"Garfield\"\\s*,\\s*\"weight\"\\s*:\\s*10.5\\s*}\\s*,\\s*\\{\\s*\"type\"\\s*:\\s*\"dog\"\\s*,\\s*\"barking\"\\s*:\\s*true\\s*,\\s*\"age\"\\s*:\\s*3\\s*,\\s*\"furry\"\\s*:\\s*false\\s*,\\s*\"name\"\\s*:\\s*\"Milo\"\\s*,\\s*\"weight\"\\s*:\\s*5.5\\s*}\\s*,\\s*\\{\\s*\"type\"\\s*:\\s*\"animal\"\\s*,\\s*\"age\"\\s*:\\s*6\\s*,\\s*\"furry\"\\s*:\\s*false\\s*,\\s*\"name\"\\s*:\\s*\"Tweety\"\\s*,\\s*\"weight\"\\s*:\\s*0.5\\s*}\\s*]\\s*}";
        MatcherAssert.assertThat((String)"Failed to correctly marshall complex type hierarchy using a serializer configured using JsonbTypeSerializer annotation and a deserializer configured using JsonbTypeDeserializer annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationRegexp));
        String toDeserialize = "{ \"animals\" : [ { \"type\" : \"cat\", \"cuddly\" : true, \"age\" : 5, \"furry\" : true, \"name\" : \"Garfield\" , \"weight\" : 10.5}, { \"type\" : \"dog\", \"barking\" : true, \"age\" : 3, \"furry\" : false, \"name\" : \"Milo\", \"weight\" : 5.5}, { \"type\" : \"animal\", \"age\" : 6, \"furry\" : false, \"name\" : \"Tweety\", \"weight\" : 0.5} ] }";
        AnimalShelterWithSerializer unmarshalledObject = (AnimalShelterWithSerializer)this.jsonb.fromJson(toDeserialize, AnimalShelterWithSerializer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshall complex type hierarchy using a serializer configured using JsonbTypeSerializer annotation and a deserializer configured using JsonbTypeDeserializer annotation.", (Object)unmarshalledObject, (Matcher)Matchers.is((Object)animalShelter));
    }
}

