/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonobjecttests;

import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.jsonobjecttests.CreateObjectBuilder;
import ee.jakarta.tck.jsonp.api.jsonobjecttests.ObjectBuild;
import ee.jakarta.tck.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonObjectTest1() {
        try {
            JsonObject myJsonObject;
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Create the expected map of JsonObject values");
            HashMap<String, Object> expMap = new HashMap<String, Object>();
            expMap.put("false", JsonValue.FALSE);
            expMap.put("true", JsonValue.TRUE);
            expMap.put("null", JsonValue.NULL);
            expMap.put("doublemin", JSONP_Util.createJsonNumber((double)Double.MIN_VALUE));
            expMap.put("doublemax", JSONP_Util.createJsonNumber((double)Double.MAX_VALUE));
            expMap.put("intmin", JSONP_Util.createJsonNumber((int)Integer.MIN_VALUE));
            expMap.put("intmax", JSONP_Util.createJsonNumber((int)Integer.MAX_VALUE));
            expMap.put("longmin", JSONP_Util.createJsonNumber((long)Long.MIN_VALUE));
            expMap.put("longmax", JSONP_Util.createJsonNumber((long)Long.MAX_VALUE));
            expMap.put("bigdecimal", JSONP_Util.createJsonNumber((BigDecimal)BigDecimal.valueOf(1.2345678912345679E8)));
            expMap.put("biginteger", JSONP_Util.createJsonNumber((BigInteger)new BigInteger("123456789")));
            expMap.put("string", JSONP_Util.createJsonString((String)"string1"));
            expMap.put("false2", JsonValue.FALSE);
            expMap.put("true2", JsonValue.TRUE);
            expMap.put("null2", JsonValue.NULL);
            expMap.put("object", object);
            expMap.put("array", array);
            JSONP_Util.dumpMap(expMap, (String)"Expected Map");
            LOGGER.info("Create JsonObject using all JsonObjectBuilder API's");
            JsonObject actMap = myJsonObject = Json.createObjectBuilder().add("false", JsonValue.FALSE).add("true", JsonValue.TRUE).add("null", JsonValue.NULL).add("doublemin", Double.MIN_VALUE).add("doublemax", Double.MAX_VALUE).add("intmin", Integer.MIN_VALUE).add("intmax", Integer.MAX_VALUE).add("longmin", Long.MIN_VALUE).add("longmax", Long.MAX_VALUE).add("bigdecimal", BigDecimal.valueOf(1.2345678912345679E8)).add("biginteger", new BigInteger("123456789")).add("string", "string1").add("false2", false).add("true2", true).addNull("null2").add("object", (JsonValue)object).add("array", (JsonValue)array).build();
            JSONP_Util.dumpMap((Map)actMap, (String)"Actual Map");
            LOGGER.info("Compare actual Map of JsonObject values with expected Map of JsonObject values");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsMap(expMap, (Map)actMap), (String)"jsonObjectTest1 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonObjectTest1 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonObjectTest2() {
        try {
            JsonObject myJsonObject2;
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Create JsonObject 'myJsonObject1' using all JsonObjectBuilder API's");
            JsonObject myJsonObject1 = Json.createObjectBuilder().add("false", JsonValue.FALSE).add("true", JsonValue.TRUE).add("null", JsonValue.NULL).add("doublemin", Double.MIN_VALUE).add("doublemax", Double.MAX_VALUE).add("intmin", Integer.MIN_VALUE).add("intmax", Integer.MAX_VALUE).add("longmin", Long.MIN_VALUE).add("longmax", Long.MAX_VALUE).add("bigdecimal", BigDecimal.valueOf(1.2345678912345679E8)).add("biginteger", new BigInteger("123456789")).add("string", "string1").add("false2", false).add("true2", true).addNull("null2").add("object", (JsonValue)object).add("array", (JsonValue)array).build();
            LOGGER.info("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            StringWriter sw = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sw);){
                writer.writeObject(myJsonObject1);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String contents = sw.toString();
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + contents);
            LOGGER.info("Read the JsonObject back into 'myJsonObject2' using a JsonReader");
            try (JsonReader reader = Json.createReader((Reader)new StringReader(contents));){
                myJsonObject2 = reader.readObject();
                LOGGER.info("Save contents of the JsonReader as a String");
                contents = reader.toString();
            }
            LOGGER.info("Dump contents of JsonReader as a String");
            LOGGER.info("JsonReaderContents=" + contents);
            LOGGER.info("Compare myJsonObject1 and myJsonObject2 for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonObjects((JsonObject)myJsonObject1, (JsonObject)myJsonObject2), (String)"jsonObjectTest2 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonObjectTest2 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonObjectTest3() {
        boolean pass = true;
        try {
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Create myObject JsonObject with 22 name/value pairs");
            JsonObject myObject = Json.createObjectBuilder().add("key0", -1).add("key1", 1).add("key2", 1).add("key3", -1000.0).add("key4", 1000.0).add("key5", 1000.0).add("key6", -2000.0).add("key7", 2000.0).add("key8", 2000.0).add("key9", Long.MAX_VALUE).add("key10", Long.MIN_VALUE).add("key11", Integer.MAX_VALUE).add("key12", Integer.MIN_VALUE).add("key13", Double.MAX_VALUE).add("key14", Double.MIN_VALUE).add("key15", BigDecimal.valueOf(1.2345678912345679E8)).add("key16", new BigInteger("123456789")).add("key17", JsonValue.TRUE).add("key18", JsonValue.FALSE).add("key19", JsonValue.NULL).add("key20", "!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").add("key21", false).add("key22", true).addNull("key23").add("key24", (JsonValue)object).add("key25", (JsonValue)array).build();
            LOGGER.info("Checking intValue of key0 for correctness");
            if (!JSONP_Util.assertEquals((int)-1, (int)myObject.getJsonNumber("key0").intValue())) {
                pass = false;
            }
            LOGGER.info("key0 via JsonNumber.toString()=" + myObject.getJsonNumber("key0").toString());
            LOGGER.info("Checking intValue of key1 for correctness");
            if (!JSONP_Util.assertEquals((int)1, (int)myObject.getInt("key1"))) {
                pass = false;
            }
            LOGGER.info("key1 via JsonNumber.toString()=" + myObject.getInt("key1"));
            LOGGER.info("Checking intValue of key2 for correctness");
            if (!JSONP_Util.assertEquals((int)1, (int)myObject.getJsonNumber("key2").intValue())) {
                pass = false;
            }
            LOGGER.info("key2 via JsonNumber.toString()=" + myObject.getJsonNumber("key2").toString());
            LOGGER.info("Checking intValue of key3 for correctness");
            if (!JSONP_Util.assertEquals((int)-1000, (int)myObject.getInt("key3"))) {
                pass = false;
            }
            LOGGER.info("key3 via JsonNumber.toString()=" + myObject.getJsonNumber("key3").toString());
            LOGGER.info("Checking intValue of key4 for correctness");
            if (!JSONP_Util.assertEquals((int)1000, (int)myObject.getJsonNumber("key4").intValue())) {
                pass = false;
            }
            LOGGER.info("key4 via JsonNumber.toString()=" + myObject.getJsonNumber("key4").toString());
            LOGGER.info("Checking intValue of key5 for correctness");
            if (!JSONP_Util.assertEquals((int)1000, (int)myObject.getJsonNumber("key5").intValue())) {
                pass = false;
            }
            LOGGER.info("key5 via JsonNumber.toString()=" + myObject.getJsonNumber("key5").toString());
            LOGGER.info("Checking intValue of key6 for correctness");
            if (!JSONP_Util.assertEquals((int)-2000, (int)myObject.getJsonNumber("key6").intValue())) {
                pass = false;
            }
            LOGGER.info("key6 via JsonNumber.toString()=" + myObject.getJsonNumber("key6").toString());
            LOGGER.info("Checking intValue of key7 for correctness");
            if (!JSONP_Util.assertEquals((int)2000, (int)myObject.getJsonNumber("key7").intValue())) {
                pass = false;
            }
            LOGGER.info("key7 via JsonNumber.toString()=" + myObject.getJsonNumber("key7").toString());
            LOGGER.info("Checking intValue of key8 for correctness");
            if (!JSONP_Util.assertEquals((int)2000, (int)myObject.getJsonNumber("key8").intValue())) {
                pass = false;
            }
            LOGGER.info("key8 via JsonNumber.toString()=" + myObject.getJsonNumber("key8").toString());
            LOGGER.info("Checking longValue of key9 for correctness");
            if (!JSONP_Util.assertEquals((long)Long.MAX_VALUE, (long)myObject.getJsonNumber("key9").longValue())) {
                pass = false;
            }
            LOGGER.info("LongMax via JsonNumber.toString()=" + myObject.getJsonNumber("key9").toString());
            if (!JSONP_Util.assertEquals((String)"9223372036854775807", (String)myObject.getJsonNumber("key9").toString())) {
                pass = false;
            }
            LOGGER.info("Checking longValue of key10 for correctness");
            if (!JSONP_Util.assertEquals((long)Long.MIN_VALUE, (long)myObject.getJsonNumber("key10").longValue())) {
                pass = false;
            }
            LOGGER.info("LongMin via JsonNumber.toString()=" + myObject.getJsonNumber("key10").toString());
            if (!JSONP_Util.assertEquals((String)"-9223372036854775808", (String)myObject.getJsonNumber("key10").toString())) {
                pass = false;
            }
            LOGGER.info("Checking intValue of key11 for correctness");
            if (!JSONP_Util.assertEquals((int)Integer.MAX_VALUE, (int)myObject.getJsonNumber("key11").intValue())) {
                pass = false;
            }
            LOGGER.info("IntMax via JsonNumber.toString()=" + myObject.getJsonNumber("key11").toString());
            if (!JSONP_Util.assertEquals((String)"2147483647", (String)myObject.getJsonNumber("key11").toString())) {
                pass = false;
            }
            LOGGER.info("Checking intValue of key12 for correctness");
            if (!JSONP_Util.assertEquals((int)Integer.MIN_VALUE, (int)myObject.getJsonNumber("key12").intValue())) {
                pass = false;
            }
            LOGGER.info("IntMin via JsonNumber.toString()=" + myObject.getJsonNumber("key12").toString());
            if (!JSONP_Util.assertEquals((String)"-2147483648", (String)myObject.getJsonNumber("key12").toString())) {
                pass = false;
            }
            LOGGER.info("Checking doubleValue of key13 for correctness");
            if (!JSONP_Util.assertEquals((double)Double.MAX_VALUE, (double)myObject.getJsonNumber("key13").doubleValue())) {
                pass = false;
            }
            LOGGER.info("Checking doubleValue of key14 for correctness");
            if (!JSONP_Util.assertEquals((double)Double.MIN_VALUE, (double)myObject.getJsonNumber("key14").doubleValue())) {
                pass = false;
            }
            LOGGER.info("Checking bigDecimalValue of key15 for correctness");
            if (!JSONP_Util.assertEquals((BigDecimal)BigDecimal.valueOf(1.2345678912345679E8), (BigDecimal)myObject.getJsonNumber("key15").bigDecimalValue())) {
                pass = false;
            }
            LOGGER.info("Checking bigIntegerValue of key16 for correctness");
            if (!JSONP_Util.assertEquals((BigInteger)new BigInteger("123456789"), (BigInteger)myObject.getJsonNumber("key16").bigIntegerValue())) {
                pass = false;
            }
            LOGGER.info("Checking getBoolean of key17 for correctness");
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myObject.getBoolean("key17"))) {
                pass = false;
            }
            LOGGER.info("Checking getBoolean of key18 for correctness");
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myObject.getBoolean("key18"))) {
                pass = false;
            }
            LOGGER.info("Checking isNull of key19 for correctness");
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myObject.isNull("key19"))) {
                pass = false;
            }
            LOGGER.info("Checking getJsonString of key20 for correctness");
            if (!JSONP_Util.assertEquals((String)"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", (String)myObject.getJsonString("key20").getString())) {
                pass = false;
            }
            LOGGER.info("Checking getString of key20 for correctness");
            if (!JSONP_Util.assertEquals((String)"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", (String)myObject.getString("key20"))) {
                pass = false;
            }
            LOGGER.info("Checking getBoolean of key21 for correctness");
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myObject.getBoolean("key21"))) {
                pass = false;
            }
            LOGGER.info("Checking getBoolean of key22 for correctness");
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myObject.getBoolean("key22"))) {
                pass = false;
            }
            LOGGER.info("Checking isNull of key23 for correctness");
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myObject.isNull("key23"))) {
                pass = false;
            }
            LOGGER.info("Checking getJsonObject of key24 for correctness");
            if (!JSONP_Util.assertEqualsJsonObjects((JsonObject)object, (JsonObject)myObject.getJsonObject("key24"))) {
                pass = false;
            }
            LOGGER.info("Checking getJsonArray of key25 for correctness");
            if (!JSONP_Util.assertEqualsJsonArrays((JsonArray)array, (JsonArray)myObject.getJsonArray("key25"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myObject.getBoolean("key17"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myObject.getBoolean("key18"))) {
                pass = false;
            }
            LOGGER.info("Testing JsonObject.getBoolean(String, boolean) with/without default value setting.");
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myObject.getBoolean("key17", false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)false, (boolean)myObject.getBoolean("key18", true))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myObject.getBoolean("key0", true))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myObject.getBoolean("key19", true))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myObject.getBoolean("key20", true))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myObject.getBoolean("key24", true))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((boolean)true, (boolean)myObject.getBoolean("key25", true))) {
                pass = false;
            }
            LOGGER.info("Testing JsonObject.getInt(String, int) with/without default value setting.");
            if (!JSONP_Util.assertEquals((int)-1, (int)myObject.getInt("key0", 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((int)10, (int)myObject.getInt("key18", 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((int)10, (int)myObject.getInt("key19", 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((int)10, (int)myObject.getInt("key20", 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((int)10, (int)myObject.getInt("key24", 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((int)10, (int)myObject.getInt("key25", 10))) {
                pass = false;
            }
            LOGGER.info("Testing JsonObject.getString(String, String) with/without default value setting.");
            if (!JSONP_Util.assertEquals((String)"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", (String)myObject.getString("key20", "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((String)"foo", (String)myObject.getString("key0", "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((String)"foo", (String)myObject.getString("key18", "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((String)"foo", (String)myObject.getString("key19", "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((String)"foo", (String)myObject.getString("key24", "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals((String)"foo", (String)myObject.getString("key25", "foo"))) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonObjectTest3 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonObjectTest3 Failed");
    }

    @Test
    public void jsonObjectTest4() {
        try {
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            StringWriter sw = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sw);){
                writer.writeObject(myJsonObject1);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String contents = sw.toString();
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + contents);
            LOGGER.info("Remove whitespace from contents.");
            String actJsonText = JSONP_Util.removeWhitespace((String)contents);
            LOGGER.info("Compare expected JsonObject text with actual JsonObject text for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)"{\"firstName\":\"John\",\"lastName\":\"Smith\",\"age\":25,\"elderly\":false,\"patriot\":true,\"address\":{\"streetAddress\":\"21 2nd Street\",\"city\":\"New York\",\"state\":\"NY\",\"postalCode\":\"10021\"},\"phoneNumber\":[{\"type\":\"home\",\"number\":\"212 555-1234\"},{\"type\":\"cell\",\"number\":\"646 555-4567\"}],\"objectOfFooBar\":{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},\"arrayOfFooBar\":[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]}", (String)actJsonText), (String)"jsonObjectTest4 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonObjectTest4 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonObjectExceptionTests() {
        JsonObject object;
        JsonObject value;
        JsonObject value2;
        Object value3;
        boolean pass = true;
        JsonObject testObject = null;
        JsonArray testArray = null;
        try {
            LOGGER.info("Create sample JsonObject for testing");
            testObject = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create sample JsonArray for testing");
            testArray = JSONP_Util.createSampleJsonArray();
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonObject to JsonNumber via getJsonNumber(String)");
            value3 = testObject.getJsonNumber("address");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonObject to JsonString via getJsonString(String)");
            value3 = testObject.getJsonString("address");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonObject to JsonArray via getJsonArray(String)");
            value3 = testObject.getJsonArray("address");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonArray to JsonNumber via getNumber(String)");
            value3 = testObject.getJsonNumber("phoneNumber");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonArray to JsonString via getJsonString(String)");
            value3 = testObject.getJsonString("phoneNumber");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonObject to String via getString(String)");
            value3 = testObject.getString("address");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonArray to String via getString(String)");
            value3 = testObject.getString("phoneNumber");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonObject to int via getInt(String)");
            int value4 = testObject.getInt("address");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonArray to int via getInt(String)");
            int value5 = testObject.getInt("phoneNumber");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonArray to JsonObject via getJsonObject(String)");
            value2 = testObject.getJsonObject("phoneNumber");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonNumber to JsonString via getJsonString(String)");
            value2 = testObject.getJsonString("age");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonNumber to JsonObject via getJsonNumber(String)");
            value2 = testObject.getJsonObject("age");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonNumber to JsonArray via getJsonArray(String)");
            value2 = testObject.getJsonArray("age");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonString to JsonNumber via getJsonNumber(String)");
            value2 = testObject.getJsonNumber("firstName");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonString to int via getInt(String)");
            int value6 = testObject.getInt("firstName");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonString to JsonObject via getJsonString(String)");
            value = testObject.getJsonObject("firstName");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonString to JsonArray via getJsonArray(String)");
            value = testObject.getJsonArray("firstName");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonValue.FALSE to JsonNumber via getJsonNumber(String)");
            value = testObject.getJsonNumber("elderly");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonValue.FALSE to JsonString via getJsonString(String)");
            value = testObject.getJsonString("elderly");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonValue.FALSE to JsonObject via getJsonObject(String)");
            value = testObject.getJsonObject("elderly");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a JsonValue.FALSE to JsonArray via getJsonArray(String)");
            value = testObject.getJsonArray("elderly");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a non JsonValue.FALSE|JsonValue.TRUE to boolean via getBoolean(String)");
            boolean value7 = testObject.getBoolean("firstName");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a non JsonValue.FALSE|JsonValue.TRUE to boolean via getBoolean(String)");
            boolean value8 = testObject.getBoolean("age");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a non JsonValue.FALSE|JsonValue.TRUE to boolean via getBoolean(String)");
            boolean value9 = testObject.getBoolean("objectOfFooBar");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ClassCastException trying to cast a non JsonValue.FALSE|JsonValue.TRUE to boolean via getBoolean(String)");
            boolean value10 = testObject.getBoolean("arrayOfFooBar");
            pass = false;
            LOGGER.warning("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            LOGGER.info("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NumberFormatException calling add(String, Double.NaN)");
            object = Json.createObjectBuilder().add("double", Double.NaN).build();
            pass = false;
            LOGGER.warning("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            LOGGER.info("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NumberFormatException calling add(String, Double.NEGATIVE_INFINITY)");
            object = Json.createObjectBuilder().add("double", Double.NEGATIVE_INFINITY).build();
            pass = false;
            LOGGER.warning("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            LOGGER.info("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NumberFormatException calling add(String, Double.POSITIVE_INFINITY)");
            object = Json.createObjectBuilder().add("double", Double.POSITIVE_INFINITY).build();
            pass = false;
            LOGGER.warning("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            LOGGER.info("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ArithmeticException calling add(\"number\", 12345.12345) and attempting to extract as an exact integer value");
            object = Json.createObjectBuilder().add("number", 12345.12345).build();
            LOGGER.info("Call JsonObject.getJsonNumber(\"number\").intValueExact()");
            int value11 = object.getJsonNumber("number").intValueExact();
            pass = false;
            LOGGER.warning("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            LOGGER.info("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ArithmeticException calling add(\"number\", 12345.12345) and attempting to extract as an exact long value");
            object = Json.createObjectBuilder().add("number", 12345.12345).build();
            LOGGER.info("Call JsonObject.getJsonNumber(\"number\").longValueExact()");
            long value12 = object.getJsonNumber("number").longValueExact();
            pass = false;
            LOGGER.warning("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            LOGGER.info("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip ArithmeticException calling add(\"number\", 12345.12345) and attempting to extract as an exact biginteger value");
            object = Json.createObjectBuilder().add("number", 12345.12345).build();
            LOGGER.info("Call JsonObject.getJsonNumber(\"number\").bigIntegerValueExact()");
            BigInteger value13 = object.getJsonNumber("number").bigIntegerValueExact();
            pass = false;
            LOGGER.warning("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            LOGGER.info("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException JsonObject.put(K,V) trying to modify JsonObject map which should be immutable");
            testObject.put((Object)"foo", (Object)JsonValue.FALSE);
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException JsonObject.putAll(Map) trying to modify JsonObject map which should be immutable");
            testObject.putAll((Map)testObject);
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException JsonObject.clear() trying to modify JsonObject map which should be immutable");
            testObject.clear();
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip UnsupportedOperationException JsonObject.remove(K) trying to modify JsonObject map which should be immutable");
            testObject.remove((Object)"firstName");
            pass = false;
            LOGGER.warning("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObject.getBoolean(String) when no mapping exists for name.");
            boolean value14 = testObject.getBoolean("foo");
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObject.getInt(String) when no mapping exists for name.");
            int value15 = testObject.getInt("foo");
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObject.getString(String) when no mapping exists for name.");
            String value16 = testObject.getString("foo");
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObject.isNull(String) when no mapping exists for name.");
            boolean value17 = testObject.isNull("foo");
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonObjectExceptionTests Failed");
    }

    @Test
    public void jsonObjectNullNameValueExceptionTests() {
        boolean pass = true;
        JsonObjectBuilder job = Json.createObjectBuilder();
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, JsonValue) when name is null.");
            job.add(null, JsonValue.TRUE);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, JsonValue) when value is null.");
            job.add("name", (JsonValue)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, String) when name is null.");
            job.add(null, "value");
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, String) when value is null.");
            job.add("name", (String)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, BigInteger) when name is null.");
            job.add(null, new BigInteger("123456789"));
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, BigInteger) when value is null.");
            job.add("name", (BigInteger)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, BigDecimal) when name is null.");
            job.add(null, new BigDecimal("123456789"));
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, BigDecimal) when value is null.");
            job.add("name", (BigDecimal)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, int) when name is null.");
            job.add(null, 123456789);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, long) when name is null.");
            job.add(null, 123456789L);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, double) when name is null.");
            job.add(null, 123456.789);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObject.add(String, boolean) when name is null.");
            job.add(null, true);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObject.addNull(String) when name is null.");
            job.addNull(null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, JsonObjectBuilder) when name is null.");
            job.add(null, Json.createObjectBuilder());
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonObjectBuilder.add(String, JsonObjectBuilder) when value is null.");
            job.add("name", (JsonObjectBuilder)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonArrayBuilder.add(String, JsonArrayBuilder) when name is null.");
            job.add(null, Json.createArrayBuilder());
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip NullPointerException for JsonArrayBuilder.add(String, JsonArrayBuilder) when value is null.");
            job.add("name", (JsonArrayBuilder)null);
            pass = false;
            LOGGER.warning("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            LOGGER.info("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonObjectNullNameValueExceptionTests Failed");
    }

    @Test
    public void jsonCreateObjectBuilder11Test() {
        CreateObjectBuilder createTest = new CreateObjectBuilder();
        TestResult result = createTest.test();
        result.eval();
    }

    @Test
    public void jsonObjectBuilder11Test() {
        ObjectBuild buildTest = new ObjectBuild();
        TestResult result = buildTest.test();
        result.eval();
    }

    @Test
    public void jsonObjectBuilderBuildTest() {
        JsonObjectBuilder builder = Json.createObjectBuilder().add("test", "value");
        JsonObject jsonObj = builder.build();
        Assertions.assertEquals((Object)"\"value\"", (Object)((JsonValue)jsonObj.get((Object)"test")).toString());
        jsonObj = builder.build();
        Assertions.assertNull((Object)jsonObj.get((Object)"test"));
    }
}

