/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.patchtests;

import ee.jakarta.tck.jsonp.api.common.TestResult;
import jakarta.json.JsonPatch;
import java.util.logging.Logger;

public class PatchOperationEnum {
    private static final Logger LOGGER = Logger.getLogger(PatchOperationEnum.class.getName());

    PatchOperationEnum() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonPatch.Operation enumeration test");
        LOGGER.info("JsonPatch.Operation enumeration test");
        this.testOperationName(result);
        this.testOperationValueOf(result);
        return result;
    }

    private void testOperationName(TestResult result) {
        LOGGER.info(" - fromOperationName(String) and operationName(String)");
        for (JsonPatch.Operation op : JsonPatch.Operation.values()) {
            String opName = op.operationName();
            JsonPatch.Operation opOut = JsonPatch.Operation.fromOperationName((String)opName);
            int opNameLen = opName.length();
            boolean opNameLc = true;
            for (int i = 0; opNameLc && i < opNameLen; ++i) {
                opNameLc = Character.isLowerCase(opName.charAt(i));
            }
            if (!opNameLc) {
                result.fail("operationName(String)", "Returned value " + opName + " is not lower case String");
            }
            if (op == opOut) continue;
            result.fail("fromOperationName(String) and operationName(String)", "Returned operation " + opOut.name() + " shall be " + op.name());
        }
    }

    private void testOperationValueOf(TestResult result) {
        LOGGER.info(" - valueOf(String)");
        for (JsonPatch.Operation op : JsonPatch.Operation.values()) {
            String opName = op.name();
            JsonPatch.Operation opOut = JsonPatch.Operation.valueOf((String)opName);
            if (op == opOut) continue;
            result.fail("valueOf(String)", "Returned operation " + opOut.name() + " shall be " + op.name());
        }
    }
}

