/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.web;

import com.sun.ts.lib.util.TestUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;

public class WebUtil {
    public static final String RESULT_PROP = "ctsWebTestResult";
    public static final String TEST_NAME_PROP = "ctsWebTestName";

    public static void logMsg(String msg) {
        TestUtil.logMsg(msg);
        System.out.println(msg);
    }

    public static void logTrace(String msg) {
        TestUtil.logTrace(msg);
        System.out.println(msg);
    }

    public static void logErr(String msg) {
        TestUtil.logErr(msg);
        System.out.println(msg);
    }

    public static void logErr(String msg, Exception e) {
        TestUtil.logErr(msg, e);
        System.out.println(msg + " : " + String.valueOf(e));
        e.printStackTrace();
    }

    public static Properties executeTest(Object testDriver, HttpServletRequest req) throws ServletException {
        String testName;
        Boolean pass = Boolean.FALSE;
        Properties webProps = null;
        Class[] params = new Class[]{Properties.class};
        Object[] args = new Object[1];
        WebUtil.logTrace("[WebUtil] executeTestOnInstance()");
        try {
            WebUtil.logTrace("[WebUtil] Retrieving harness props...");
            webProps = new Properties();
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = req.getParameter(name);
                webProps.setProperty(name, value);
            }
            WebUtil.logTrace("[WebUtil] Initializing Remote Logging...");
            TestUtil.init(webProps);
        }
        catch (Exception e) {
            System.out.println("Exception: " + String.valueOf(e));
            e.printStackTrace();
            throw new ServletException("Cannot Initialize CST Logging");
        }
        try {
            WebUtil.logTrace("[WebUtil] Getting test name...");
            testName = TestUtil.getProperty(webProps, TEST_NAME_PROP);
        }
        catch (Exception e) {
            WebUtil.logErr("[WebUtil] Unexpected exception", e);
            throw new ServletException("Cannot get test name");
        }
        if (null == testName || testName.equals("")) {
            WebUtil.logErr("[WebUtil] Invalid test name : " + testName);
            throw new ServletException("Invalid test name");
        }
        try {
            WebUtil.logTrace("[WebUtil] Invoke test '" + testName + "'");
            Class<?> testDriverClass = testDriver.getClass();
            Method testMethod = testDriverClass.getMethod(testName, params);
            args[0] = webProps;
            pass = (Boolean)testMethod.invoke(testDriver, args);
        }
        catch (NoSuchMethodException e) {
            WebUtil.logErr("[WebUtil] Cannot find method '" + testName + "' make sure it is defined in sub-class", e);
            throw new ServletException("Test method is not defined");
        }
        catch (InvocationTargetException e) {
            WebUtil.logErr("[WebUtil] InvocationTargetException '" + testName + "' caused by " + String.valueOf(e.getTargetException()));
            throw new ServletException("Test method is not defined");
        }
        catch (Exception e) {
            WebUtil.logErr("[WebUtil] Unexpected exception", e);
            throw new ServletException("Cannot Invoke test method");
        }
        webProps.setProperty(RESULT_PROP, pass.toString());
        return webProps;
    }

    public static String propsToString(Properties props) {
        StringBuffer sb = new StringBuffer(1000);
        if (null == props) {
            throw new IllegalArgumentException("null props!");
        }
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            sb.append(name + "=" + props.getProperty(name) + "\n");
        }
        return sb.toString();
    }
}

