/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.packaging.war.enventry;

import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteClientBase;
import com.sun.ts.tests.ejb30.lite.packaging.war.enventry.BeanBase;
import com.sun.ts.tests.ejb30.lite.packaging.war.enventry.OneBean;
import com.sun.ts.tests.ejb30.lite.packaging.war.enventry.ThreeBean;
import com.sun.ts.tests.ejb30.lite.packaging.war.enventry.TwoBean;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;

public class Client
extends EJBLiteClientBase {
    @EJB
    private OneBean one;
    @EJB
    private TwoBean two;
    @EJB
    private ThreeBean three;
    @Resource(description="declared in web.xml")
    private String myString;
    @Resource(name="myChar")
    private char myChar;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.OneBean/myString", description="declared in ejb-jar.xml#OneBean")
    private String myStringFromOne;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.OneBean/myChar")
    private char myCharFromOne;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.TwoBean/myString", description="declared in ejb-jar.xml#TwoBean")
    private String myStringFromTwo;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.TwoBean/myChar")
    private char myCharFromTwo;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.ThreeBean/myString", description="declared in ejb-jar.xml#ThreeBean")
    private String myStringFromThree;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.ThreeBean/myChar")
    private char myCharFromThree;
    @Resource(lookup="java:module/ModuleName")
    private String moduleNameInjected;
    @Resource(lookup="java:app/AppName")
    private String appNameInjected;
    private boolean myBooleanTrue2;

    public void injectedIntoClient() {
        this.verify();
    }

    public void injectedIntoOneBean() {
        this.appendReason(this.one.getInjectionRecords());
        this.assertEquals("", true, this.one.getInjectionStatus());
    }

    public void injectedIntoTwoBean() {
        this.appendReason(this.two.getInjectionRecords());
        this.assertEquals("", true, this.two.getInjectionStatus());
    }

    public void injectedIntoThreeBean() {
        this.appendReason(this.three.getInjectionRecords());
        this.assertEquals("", true, this.three.getInjectionStatus());
    }

    public void injectedIntoOneBeanInterceptors() {
        this.injectedIntoInterceptors(this.one);
    }

    public void injectedIntoTwoBeanInterceptors() {
        this.injectedIntoInterceptors(this.two);
    }

    public void injectedIntoThreeBeanInterceptors() {
        this.injectedIntoInterceptors(this.three);
    }

    public void appNameModuleName() {
        String lookup = "java:module/ModuleName";
        String expected = this.getModuleName();
        String actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
        this.assertEquals("Check " + lookup, expected, actual);
        this.assertEquals("Check moduleNameInjected ", expected, this.moduleNameInjected);
        lookup = "java:app/AppName";
        actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
        this.assertEquals("Check " + lookup, expected, actual);
        this.assertEquals("Check appNameInjected ", expected, this.appNameInjected);
    }

    public void appNameModuleNameFromEJB() {
        BeanBase[] beans;
        for (BeanBase b : beans = new BeanBase[]{this.one, this.two, this.three}) {
            this.appendReason(b.appNameModuleName(this.getModuleName()));
        }
    }

    private void verify() {
        this.assertEquals("Check myString from web.xml: ", " web.xml ${java.home} ", this.myString);
        this.assertEquals("Check myString from OneBean: ", " OneBean ${java.home} ", this.myStringFromOne);
        this.assertEquals("Check myString from TwoBean: ", " TwoBean ${java.home} ", this.myStringFromTwo);
        this.assertEquals("Check myString from  ThreeBean: ", " ThreeBean ${java.home} ", this.myStringFromThree);
        this.assertEquals("Check myChar from web.xml: ", Character.valueOf(' '), Character.valueOf(this.myChar));
        this.assertEquals("Check myChar from OneBean: ", Character.valueOf(' '), Character.valueOf(this.myCharFromOne));
        this.assertEquals("Check myChar from TwoBean: ", Character.valueOf('2'), Character.valueOf(this.myCharFromTwo));
        this.assertEquals("Check myChar from ThreeBean: ", Character.valueOf('3'), Character.valueOf(this.myCharFromThree));
        this.assertEquals("Check myBooleanTrue2 from web.xml: ", true, this.myBooleanTrue2);
    }

    private void injectedIntoInterceptors(BeanBase b) {
        ArrayList<List<String>> records = new ArrayList<List<String>>();
        b.getInjectionRecordsForInterceptors(records);
        this.appendReason(records);
        this.assertEquals("4 record-lists for 4 interceptors ", 4, records.size());
        for (List list : records) {
            this.assertEquals("2 records for each interceptor ", 2, list.size());
        }
    }
}

