/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.common;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class fnSchema
extends ServiceEETest {
    public void createTable(Properties props, Connection conn) throws RemoteException {
        String insertString1 = null;
        String insertString2 = null;
        TestUtil.logTrace((String)"createTable");
        try {
            this.dropTable(props, conn);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"SQLException encountered while deleting rows from tables", (Throwable)e);
        }
        try {
            Statement stmt = conn.createStatement();
            insertString1 = props.getProperty("Fnschema_Tab1_Insert", "");
            TestUtil.logTrace((String)("insertString1: " + insertString1));
            TestUtil.logTrace((String)("Executed: '" + insertString1 + "' successfully"));
            stmt.executeUpdate(insertString1);
            insertString2 = props.getProperty("Fnschema_Tab2_Insert", "");
            TestUtil.logTrace((String)("insertString2: " + insertString2));
            TestUtil.logTrace((String)("Executed: '" + insertString2 + "' successfully"));
            stmt.executeUpdate(insertString2);
            stmt.close();
        }
        catch (SQLException e) {
            TestUtil.logErr((String)"SQLException while inserting data", (Throwable)e);
            this.dropTable(props, conn);
            throw new RemoteException(e.getMessage());
        }
    }

    public void dropTable(Properties props, Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"dropTable");
        String dropString1 = props.getProperty("Fnschema_Tab1_Delete", "");
        String dropString2 = props.getProperty("Fnschema_Tab2_Delete", "");
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(dropString1);
            TestUtil.logTrace((String)("Executed: '" + dropString1 + "' successfully"));
            stmt.executeUpdate(dropString2);
            TestUtil.logTrace((String)("Executed: '" + dropString2 + "' successfully"));
            stmt.close();
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public void dbUnConnect(Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"dbUnConnect");
        try {
            conn.close();
            TestUtil.logMsg((String)"Closed the Database connection");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured while trying to close the DB connection", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean isStringFuncFound(String funcName, Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"isStringFuncFound");
        try {
            DatabaseMetaData dbmd = null;
            dbmd = conn.getMetaData();
            String strFuncList = dbmd.getStringFunctions();
            String formatStrFuncList = "," + strFuncList + ",";
            String formatFuncName = "," + funcName + ",";
            int index = formatStrFuncList.indexOf(formatFuncName);
            return index >= 0;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception thrown while trying to check the presence of the string func.", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean isSystemFuncFound(String funcName, Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"isSystemFuncFound");
        try {
            DatabaseMetaData dbmd = null;
            dbmd = conn.getMetaData();
            String systemFuncList = dbmd.getSystemFunctions();
            String formatSystemFuncList = "," + systemFuncList + ",";
            String formatFuncName = "," + funcName + ",";
            int index = formatSystemFuncList.indexOf(formatFuncName);
            return index >= 0;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception thrown while trying to check the presence of the system func.", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean isNumericFuncFound(String funcName, Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"isNumericFuncFound");
        try {
            DatabaseMetaData dbmd = null;
            dbmd = conn.getMetaData();
            String numericFuncList = dbmd.getNumericFunctions();
            String formatNumericFuncList = "," + numericFuncList + ",";
            String formatFuncName = "," + funcName + ",";
            int index = formatNumericFuncList.indexOf(formatFuncName);
            return index >= 0;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception thrown while trying to check the presence of the Numeric func.", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean isTimeDateFuncFound(String funcName, Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"isTimeDateFuncFound");
        try {
            DatabaseMetaData dbmd = null;
            dbmd = conn.getMetaData();
            String timeDateFuncList = dbmd.getTimeDateFunctions();
            String formatTimeDateFuncList = "," + timeDateFuncList + ",";
            String formatFuncName = "," + funcName + ",";
            int index = formatTimeDateFuncList.indexOf(formatFuncName);
            return index >= 0;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception thrown while trying to check the presence of the Time & Date func.", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

