/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.uuid;

import java.net.InetAddress;
import java.rmi.server.UID;
import java.security.SecureRandom;

public class UuidUtil {
    static final String _inetAddr = UuidUtil.initInetAddr();
    private static SecureRandom _seeder = new SecureRandom();

    public static String generateUuidMM() {
        return new StringBuffer(new UID().toString()).reverse().append(':').append(_inetAddr).toString();
    }

    public static String generateUuid() {
        return UuidUtil.generateUuid(new Object());
    }

    public static String generateUuid(Object obj) {
        long presentTime = System.currentTimeMillis();
        int presentTimeLow = (int)presentTime;
        String presentTimeStringLow = UuidUtil.formatHexString(presentTimeLow);
        StringBuilder sb = new StringBuilder(50);
        sb.append(presentTimeStringLow);
        sb.append(UuidUtil.getIdentityHashCode(obj));
        sb.append(UuidUtil.addRandomTo(_inetAddr));
        sb.append(UuidUtil.getNextRandomString());
        return sb.toString();
    }

    private static String initInetAddr() {
        try {
            byte[] bytes = InetAddress.getLocalHost().getAddress();
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                String s = Integer.toHexString(bytes[i]);
                if (bytes[i] < 0) {
                    b.append(s.substring(s.length() - 2));
                    continue;
                }
                b.append(s);
            }
            return b.toString();
        }
        catch (Exception ex) {
            return "a48eb993";
        }
    }

    private static String addRandomTo(String hexString) {
        int nextRandom;
        long hexAsLong = UuidUtil.convertToLong(hexString);
        long resultInt = hexAsLong + (long)(nextRandom = UuidUtil.getNextInt());
        String result = Long.toHexString(resultInt);
        int len = result.length();
        result = len < 7 ? UuidUtil.padto7(result) : result.substring(len - 7, len);
        return result;
    }

    private static String getIdentityHashCode(Object obj) {
        Object result = null;
        try {
            int hc = System.identityHashCode(obj);
            return UuidUtil.formatHexString(hc);
        }
        catch (Exception ex) {
            return "8AF5182";
        }
    }

    private static String formatHexString(int inputInt) {
        String s = Integer.toHexString(inputInt);
        int len = s.length();
        String result = len < 7 ? UuidUtil.padto7(s) : s.substring(len - 7, len);
        return result;
    }

    private static synchronized int getNextInt() {
        return _seeder.nextInt();
    }

    private static String getNextRandomString() {
        int nextInt = UuidUtil.getNextInt();
        return UuidUtil.formatHexString(nextInt);
    }

    private static long convertToLong(String hexString) {
        long result = 0L;
        try {
            result = Long.valueOf(hexString, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(UuidUtil.generateUuidMM());
        System.out.println(UuidUtil.generateUuid());
        System.out.println(UuidUtil.generateUuid(new Object()));
    }

    private static String padto7(String s) {
        int i;
        char[] chars = new char[7];
        int len = s.length();
        for (i = 0; i < len; ++i) {
            chars[i] = s.charAt(i);
        }
        while (i < 7) {
            chars[i++] = 48;
        }
        return new String(chars);
    }
}

