/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.threadpool;

import java.util.Queue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.monitoring.DefaultMonitoringConfig;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.glassfish.grizzly.utils.DelayedExecutor;

public final class ThreadPoolConfig {
    private static final ThreadPoolConfig DEFAULT = new ThreadPoolConfig("Grizzly", AbstractThreadPool.DEFAULT_MIN_THREAD_COUNT, AbstractThreadPool.DEFAULT_MAX_THREAD_COUNT, null, -1, 30000L, TimeUnit.MILLISECONDS, null, 5, true, null, null, -1L, null);
    protected String poolName;
    protected int corePoolSize;
    protected int maxPoolSize;
    protected Queue<Runnable> queue;
    protected int queueLimit = -1;
    protected long keepAliveTimeMillis;
    protected ThreadFactory threadFactory;
    protected int priority = 10;
    protected boolean isDaemon;
    protected MemoryManager mm;
    protected DelayedExecutor transactionMonitor;
    protected long transactionTimeoutMillis;
    protected ClassLoader initialClassLoader;
    protected final DefaultMonitoringConfig<ThreadPoolProbe> threadPoolMonitoringConfig;

    public static ThreadPoolConfig defaultConfig() {
        return DEFAULT.copy();
    }

    private ThreadPoolConfig(String poolName, int corePoolSize, int maxPoolSize, Queue<Runnable> queue, int queueLimit, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory, int priority, boolean isDaemon, MemoryManager mm, DelayedExecutor transactionMonitor, long transactionTimeoutMillis, ClassLoader initialClassLoader) {
        this.poolName = poolName;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.queue = queue;
        this.queueLimit = queueLimit;
        this.keepAliveTimeMillis = keepAliveTime > 0L ? TimeUnit.MILLISECONDS.convert(keepAliveTime, timeUnit) : keepAliveTime;
        this.threadFactory = threadFactory;
        this.priority = priority;
        this.isDaemon = isDaemon;
        this.mm = mm;
        this.transactionMonitor = transactionMonitor;
        this.transactionTimeoutMillis = transactionTimeoutMillis;
        this.initialClassLoader = initialClassLoader;
        this.threadPoolMonitoringConfig = new DefaultMonitoringConfig<ThreadPoolProbe>(ThreadPoolProbe.class);
    }

    private ThreadPoolConfig(ThreadPoolConfig cfg) {
        this.queue = cfg.queue;
        this.threadFactory = cfg.threadFactory;
        this.poolName = cfg.poolName;
        this.priority = cfg.priority;
        this.isDaemon = cfg.isDaemon;
        this.maxPoolSize = cfg.maxPoolSize;
        this.queueLimit = cfg.queueLimit;
        this.corePoolSize = cfg.corePoolSize;
        this.keepAliveTimeMillis = cfg.keepAliveTimeMillis;
        this.mm = cfg.mm;
        this.initialClassLoader = cfg.initialClassLoader;
        this.threadPoolMonitoringConfig = new DefaultMonitoringConfig<ThreadPoolProbe>(ThreadPoolProbe.class);
        ThreadPoolProbe[] srcProbes = cfg.threadPoolMonitoringConfig.getProbesUnsafe();
        if (srcProbes != null) {
            this.threadPoolMonitoringConfig.addProbes((ThreadPoolProbe[])srcProbes);
        }
        this.transactionMonitor = cfg.transactionMonitor;
        this.transactionTimeoutMillis = cfg.transactionTimeoutMillis;
    }

    public ThreadPoolConfig copy() {
        return new ThreadPoolConfig(this);
    }

    public Queue<Runnable> getQueue() {
        return this.queue;
    }

    public ThreadPoolConfig setQueue(Queue<Runnable> queue) {
        this.queue = queue;
        return this;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public ThreadPoolConfig setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public ThreadPoolConfig setPoolName(String poolname) {
        this.poolName = poolname;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public ThreadPoolConfig setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public ThreadPoolConfig setDaemon(boolean isDaemon) {
        this.isDaemon = isDaemon;
        return this;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public ThreadPoolConfig setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public ThreadPoolConfig setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
        return this;
    }

    public int getQueueLimit() {
        return this.queueLimit;
    }

    public ThreadPoolConfig setQueueLimit(int queueLimit) {
        this.queueLimit = queueLimit;
        return this;
    }

    public ThreadPoolConfig setKeepAliveTime(long time, TimeUnit unit) {
        this.keepAliveTimeMillis = time < 0L ? -1L : TimeUnit.MILLISECONDS.convert(time, unit);
        return this;
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        if (this.keepAliveTimeMillis == -1L) {
            return -1L;
        }
        return timeUnit.convert(this.keepAliveTimeMillis, TimeUnit.MILLISECONDS);
    }

    public MemoryManager getMemoryManager() {
        return this.mm;
    }

    public ThreadPoolConfig setMemoryManager(MemoryManager mm) {
        this.mm = mm;
        return this;
    }

    public DefaultMonitoringConfig<ThreadPoolProbe> getInitialMonitoringConfig() {
        return this.threadPoolMonitoringConfig;
    }

    public DelayedExecutor getTransactionMonitor() {
        return this.transactionMonitor;
    }

    public ThreadPoolConfig setTransactionMonitor(DelayedExecutor transactionMonitor) {
        this.transactionMonitor = transactionMonitor;
        return this;
    }

    public long getTransactionTimeout(TimeUnit timeUnit) {
        if (this.transactionTimeoutMillis > 0L) {
            return timeUnit.convert(this.transactionTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        return 0L;
    }

    public ThreadPoolConfig setTransactionTimeout(long transactionTimeout, TimeUnit timeunit) {
        this.transactionTimeoutMillis = transactionTimeout > 0L ? TimeUnit.MILLISECONDS.convert(transactionTimeout, timeunit) : 0L;
        return this;
    }

    public ThreadPoolConfig setTransactionTimeout(DelayedExecutor transactionMonitor, long transactionTimeout, TimeUnit timeunit) {
        this.transactionMonitor = transactionMonitor;
        return this.setTransactionTimeout(transactionTimeout, timeunit);
    }

    public ClassLoader getInitialClassLoader() {
        return this.initialClassLoader;
    }

    public ThreadPoolConfig setInitialClassLoader(ClassLoader initialClassLoader) {
        this.initialClassLoader = initialClassLoader;
        return this;
    }

    public String toString() {
        return ThreadPoolConfig.class.getSimpleName() + " :\r\n  poolName: " + this.poolName + "\r\n  corePoolSize: " + this.corePoolSize + "\r\n  maxPoolSize: " + this.maxPoolSize + "\r\n  queue: " + (this.queue != null ? this.queue.getClass() : "undefined") + "\r\n  queueLimit: " + this.queueLimit + "\r\n  keepAliveTime (millis): " + this.keepAliveTimeMillis + "\r\n  threadFactory: " + this.threadFactory + "\r\n  transactionMonitor: " + this.transactionMonitor + "\r\n  transactionTimeoutMillis: " + this.transactionTimeoutMillis + "\r\n  priority: " + this.priority + "\r\n  isDaemon: " + this.isDaemon + "\r\n  initialClassLoader: " + this.initialClassLoader;
    }
}

