/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.appclient.server.core.jws.servedcontent.Content;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.StaticHttpHandler;

public class FixedContent
extends Content.Adapter
implements StaticContent {
    private final File file;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");

    public FixedContent(File file) {
        this.file = file;
    }

    public FixedContent() {
        this.file = null;
    }

    @Override
    public File file() throws IOException {
        return this.file;
    }

    @Override
    public void process(String relativeURIString, Request gReq, Response gResp) throws IOException {
        gResp.setDateHeader("Last-Modified", this.file().lastModified());
        gResp.setDateHeader("Date", System.currentTimeMillis());
        StaticHttpHandler.sendFile((Response)gResp, (File)this.file());
        int status = gResp.getStatus();
        if (status != 200) {
            logger.log(Level.FINE, "Could not serve content for {0} - status = {1}", new Object[]{relativeURIString, status});
        } else {
            logger.log(Level.FINE, "Served fixed content for {0}:{1}", new Object[]{gReq.getMethod(), this.toString()});
        }
    }

    public String toString() {
        return "FixedContent: " + this.file.getAbsolutePath();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedContent other = (FixedContent)obj;
        return this.file == other.file || this.file != null && this.file.equals(other.file);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.file != null ? this.file.hashCode() : 0);
        return hash;
    }
}

