/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.json.bind.config.PropertyNamingStrategy;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.model.customization.ClassCustomization;
import org.eclipse.yasson.internal.model.customization.naming.CaseInsensitiveStrategy;

public class ClassModel {
    private final Class<?> clazz;
    private final ClassCustomization classCustomization;
    private final ClassModel parentClassModel;
    private Map<String, PropertyModel> properties;
    private PropertyModel[] sortedProperties;
    private final PropertyNamingStrategy propertyNamingStrategy;

    public PropertyModel getPropertyModel(String name) {
        return this.properties.get(name);
    }

    public ClassModel(Class<?> clazz, ClassCustomization customization, ClassModel parentClassModel, PropertyNamingStrategy propertyNamingStrategy) {
        this.clazz = clazz;
        this.classCustomization = customization;
        this.parentClassModel = parentClassModel;
        this.propertyNamingStrategy = propertyNamingStrategy;
        this.setProperties(new ArrayList<PropertyModel>());
    }

    public PropertyModel findPropertyModelByJsonReadName(String jsonReadName) {
        Objects.requireNonNull(jsonReadName);
        return this.searchProperty(this, jsonReadName);
    }

    private PropertyModel searchProperty(ClassModel classModel, String jsonReadName) {
        PropertyModel result = classModel.getPropertyModel(jsonReadName);
        if (result != null && result.getPropertyName().equals(result.getReadName())) {
            return result;
        }
        for (PropertyModel propertyModel : this.properties.values()) {
            if (!this.equalsReadName(jsonReadName, propertyModel)) continue;
            return propertyModel;
        }
        return null;
    }

    private boolean equalsReadName(String jsonName, PropertyModel propertyModel) {
        String propertyReadName = propertyModel.getReadName();
        if (this.propertyNamingStrategy instanceof CaseInsensitiveStrategy) {
            return jsonName.equalsIgnoreCase(propertyReadName);
        }
        return jsonName.equals(propertyReadName);
    }

    public ClassCustomization getCustomization() {
        return this.classCustomization;
    }

    public Class<?> getType() {
        return this.clazz;
    }

    public ClassCustomization getClassCustomization() {
        return this.classCustomization;
    }

    public ClassModel getParentClassModel() {
        return this.parentClassModel;
    }

    public PropertyModel[] getSortedProperties() {
        return this.sortedProperties;
    }

    public void setProperties(List<PropertyModel> parsedProperties) {
        this.sortedProperties = parsedProperties.toArray(new PropertyModel[0]);
        this.properties = parsedProperties.stream().collect(Collectors.toMap(PropertyModel::getPropertyName, mod -> mod));
    }

    public Map<String, PropertyModel> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }
}

