/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.injection;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.jms.injection.JMSContextEntry;
import org.glassfish.jms.injection.JMSContextMetadata;

public abstract class AbstractJMSContextManager
implements Serializable {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.jms.injection");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbstractJMSContextManager.class);
    protected final Map<String, JMSContextEntry> contexts = new HashMap<String, JMSContextEntry>();

    protected JMSContext createContext(String ipId, JMSContextMetadata metadata, ConnectionFactory connectionFactory) {
        int sessionMode = metadata.getSessionMode();
        String userName = metadata.getUserName();
        JMSContext context = null;
        if (userName == null) {
            context = connectionFactory.createContext(sessionMode);
        } else {
            String password = metadata.getPassword();
            context = connectionFactory.createContext(userName, password, sessionMode);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, localStrings.getLocalString("JMSContext.impl.create", "Created new JMSContext instance associated with id {0}: {1}.", new Object[]{ipId, context.toString()}));
        }
        return context;
    }

    public synchronized JMSContext getContext(String ipId, String id, JMSContextMetadata metadata, ConnectionFactory connectionFactory) {
        JMSContextEntry contextEntry = this.contexts.get(id);
        JMSContext context = null;
        if (contextEntry == null) {
            context = this.createContext(ipId, metadata, connectionFactory);
            ServiceLocator serviceLocator = (ServiceLocator)Globals.get(ServiceLocator.class);
            InvocationManager invMgr = (InvocationManager)serviceLocator.getService(InvocationManager.class, new Annotation[0]);
            this.contexts.put(id, new JMSContextEntry(ipId, context, invMgr.getCurrentInvocation()));
        } else {
            context = contextEntry.getCtx();
        }
        return context;
    }

    public JMSContext getContext(String id) {
        JMSContextEntry entry = this.contexts.get(id);
        JMSContext context = null;
        if (entry != null) {
            context = entry.getCtx();
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public synchronized void cleanup() {
        ServiceLocator serviceLocator = (ServiceLocator)Globals.get(ServiceLocator.class);
        InvocationManager invMgr = (InvocationManager)serviceLocator.getService(InvocationManager.class, new Annotation[0]);
        ComponentInvocation currentInv = invMgr.getCurrentInvocation();
        for (Map.Entry<String, JMSContextEntry> entry : this.contexts.entrySet()) {
            JMSContextEntry contextEntry = entry.getValue();
            String ipId = contextEntry.getInjectionPointId();
            JMSContext context = contextEntry.getCtx();
            if (context == null) continue;
            ComponentInvocation inv = contextEntry.getComponentInvocation();
            if (inv != null && currentInv != inv) {
                invMgr.preInvoke(inv);
            }
            try {
                context.close();
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, localStrings.getLocalString("JMSContext.impl.close", "Closed JMSContext instance associated with id {0}: {1}.", new Object[]{ipId, context.toString()}));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, localStrings.getLocalString("JMSContext.impl.close.failure", "Failed to close JMSContext instance associated with id {0}: {1}.", new Object[]{ipId, context.toString()}), e);
            }
            finally {
                if (inv == null || currentInv == inv) continue;
                invMgr.postInvoke(inv);
            }
        }
        this.contexts.clear();
    }

    public abstract String getType();
}

