/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReflectionUtil {
    private static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static <T> T invoke(Object target, String methodName, Class<T> resultClass, Object ... parameters) throws XWSSecurityRuntimeException {
        Class[] parameterTypes;
        if (parameters != null && parameters.length > 0) {
            parameterTypes = new Class[parameters.length];
            int i = 0;
            for (Object parameter : parameters) {
                parameterTypes[i++] = parameter.getClass();
            }
        } else {
            parameterTypes = null;
        }
        return ReflectionUtil.invoke(target, methodName, resultClass, parameters, parameterTypes);
    }

    public static <T> T invoke(Object target, String methodName, Class<T> resultClass, Object[] parameters, Class[] parameterTypes) throws XWSSecurityRuntimeException {
        try {
            Method method = target.getClass().getMethod(methodName, parameterTypes);
            Object result = method.invoke(target, parameters);
            return resultClass.cast(result);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0810_METHOD_INVOCATION_FAILED(), e);
            throw e;
        }
        catch (InvocationTargetException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0810_METHOD_INVOCATION_FAILED(), e);
            throw new XWSSecurityRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0810_METHOD_INVOCATION_FAILED(), e);
            throw new XWSSecurityRuntimeException(e);
        }
        catch (SecurityException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0810_METHOD_INVOCATION_FAILED(), e);
            throw e;
        }
        catch (NoSuchMethodException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0810_METHOD_INVOCATION_FAILED(), e);
            throw new XWSSecurityRuntimeException(e);
        }
    }
}

