/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.stream.XMLStreamException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.ACCModulesManager;
import org.glassfish.appclient.client.acc.FacadeLaunchable;
import org.glassfish.appclient.client.acc.JWSFacadeLaunchable;
import org.glassfish.appclient.client.acc.MainClassLaunchable;
import org.glassfish.appclient.client.acc.UndeployedLaunchable;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.hk2.api.ServiceLocator;
import org.xml.sax.SAXException;

interface Launchable {
    public Class getMainClass() throws ClassNotFoundException;

    public ApplicationClientDescriptor getDescriptor(URLClassLoader var1) throws IOException, SAXException;

    public void validateDescriptor();

    public URI getURI();

    public String getAnchorDir();

    public static class LaunchableUtil {
        private static final LocalStringManager localStrings = new LocalStringManagerImpl(LaunchableUtil.class);

        static Launchable newLaunchable(URI uri, String callerSuppliedMainClassName, String callerSuppliedAppName, ServiceLocator habitat) throws IOException, BootException, URISyntaxException, XMLStreamException, SAXException, UserError {
            ArchiveFactory af = ACCModulesManager.getService(ArchiveFactory.class);
            ReadableArchive ra = null;
            try {
                ra = af.openArchive(uri);
            }
            catch (IOException e) {
                String msg = localStrings.getLocalString(Launchable.class, "appclient.cannotFindJarFile", "Could not locate the requested client JAR file {0}; please try again with an existing, valid client JAR", new Object[]{uri});
                throw new UserError(msg);
            }
            Launchable result = FacadeLaunchable.newFacade(habitat, ra, callerSuppliedMainClassName, callerSuppliedAppName);
            if (result == null) {
                result = UndeployedLaunchable.newUndeployedLaunchable(habitat, ra, callerSuppliedMainClassName, callerSuppliedAppName, Thread.currentThread().getContextClassLoader());
            }
            if (!(result instanceof JWSFacadeLaunchable)) {
                URL clientOrFacadeURL = new URL("file:" + result.getURI().getSchemeSpecificPart());
                ACCClassLoader cl = ACCClassLoader.instance();
                if (cl == null) {
                    cl = ACCClassLoader.newInstance(Thread.currentThread().getContextClassLoader(), false);
                }
                cl.appendURL(clientOrFacadeURL);
            }
            return result;
        }

        static Launchable newLaunchable(ServiceLocator habitat, Class mainClass) {
            return new MainClassLaunchable(habitat, mainClass);
        }

        static ApplicationClientDescriptor openWithAnnoProcessingAndTempLoader(AppClientArchivist archivist, final URLClassLoader loader, ReadableArchive facadeRA, ReadableArchive clientRA) throws IOException, SAXException {
            archivist.setAnnotationProcessingRequested(true);
            ACCClassLoader tempLoader = AccessController.doPrivileged(new PrivilegedAction<ACCClassLoader>(){

                @Override
                public ACCClassLoader run() {
                    return new ACCClassLoader(loader.getURLs(), loader.getParent());
                }
            });
            archivist.setClassLoader((ClassLoader)tempLoader);
            ApplicationClientDescriptor acDesc = (ApplicationClientDescriptor)archivist.open(facadeRA, clientRA);
            archivist.setDescriptor((BundleDescriptor)acDesc);
            return acDesc;
        }

        static boolean matchesAnyClass(ReadableArchive archive, String callerSpecifiedMainClassName) throws IOException {
            return callerSpecifiedMainClassName != null && archive.exists(LaunchableUtil.classNameToArchivePath(callerSpecifiedMainClassName));
        }

        static String moduleID(URI groupFacadeURI, URI clientURI, ApplicationClientDescriptor clientFacadeDescriptor) {
            String moduleID = clientFacadeDescriptor.getModuleID();
            if (moduleID.endsWith(".jar")) {
                moduleID = LaunchableUtil.deriveModuleID(groupFacadeURI, clientURI);
            }
            return moduleID;
        }

        static boolean matchesName(String moduleID, URI groupFacadeURI, ApplicationClientDescriptor clientFacadeDescriptor, String appClientName) throws IOException {
            String displayName = clientFacadeDescriptor.getDisplayName();
            return moduleID != null && moduleID.equals(appClientName) || displayName != null && displayName.equals(appClientName);
        }

        private static String classNameToArchivePath(String className) {
            return className.replace('.', '/') + ".class";
        }

        private static String deriveModuleID(URI groupFacadeURI, URI clientArchiveURI) {
            URI dirURI = LaunchableUtil.stripDotJar(groupFacadeURI);
            URI clientArchiveRelativeURI = LaunchableUtil.stripDotJar(dirURI.relativize(URI.create("file:" + clientArchiveURI.getRawSchemeSpecificPart())));
            return clientArchiveRelativeURI.getRawSchemeSpecificPart();
        }

        private static URI stripDotJar(URI uri) {
            String pathWithoutDotJar = uri.getRawSchemeSpecificPart();
            pathWithoutDotJar = pathWithoutDotJar.substring(0, pathWithoutDotJar.length() - ".jar".length());
            return URI.create("file:" + pathWithoutDotJar);
        }
    }
}

