/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.allocator;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ConnectorXAResource;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.AbstractConnectorAllocator;
import com.sun.enterprise.resource.listener.LocalTxConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;

public class LocalTxConnectorAllocator
extends AbstractConnectorAllocator {
    protected boolean shareable = true;
    private static String transactionCompletionMode = System.getProperty("com.sun.enterprise.in-progress-local-transaction.completion-mode");
    private static final String COMMIT = "COMMIT";
    private static final String ROLLBACK = "ROLLBACK";

    public LocalTxConnectorAllocator(PoolManager poolMgr, ManagedConnectionFactory mcf, ResourceSpec spec, Subject subject, ConnectionRequestInfo reqInfo, ClientSecurityInfo info, ConnectorDescriptor desc, boolean shareable) {
        super(poolMgr, mcf, spec, subject, reqInfo, info, desc);
        this.shareable = shareable;
    }

    @Override
    public ResourceHandle createResource() throws PoolingException {
        try {
            ManagedConnection mc = this.mcf.createManagedConnection(this.subject, this.reqInfo);
            ResourceHandle resource = this.createResourceHandle(mc, this.spec, this, this.info);
            LocalTxConnectionEventListener l = new LocalTxConnectionEventListener(resource);
            mc.addConnectionEventListener((ConnectionEventListener)l);
            resource.setListener(l);
            ConnectorXAResource xares = new ConnectorXAResource(resource, this.spec, this, this.info);
            resource.fillInResourceObjects(null, xares);
            return resource;
        }
        catch (ResourceException ex) {
            Object[] params = new Object[]{this.spec.getPoolInfo(), ex.toString()};
            _logger.log(Level.WARNING, "poolmgr.create_resource_error", params);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Resource Exception while creating resource", ex);
            }
            if (ex.getLinkedException() != null) {
                _logger.log(Level.WARNING, "poolmgr.create_resource_linked_error", ex.getLinkedException().toString());
            }
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    @Override
    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            Object con = mc.getConnection(this.subject, this.reqInfo);
            ConnectorXAResource xares = (ConnectorXAResource)resource.getXAResource();
            xares.setUserHandle(con);
            resource.fillInResourceObjects(con, xares);
        }
        catch (ResourceException ex) {
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    @Override
    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            ConnectorXAResource.freeListener(mc);
            XAResource xares = resource.getXAResource();
            this.forceTransactionCompletion(xares);
            mc.destroy();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("destroyResource for LocalTxConnectorAllocator done");
            }
        }
        catch (Exception ex) {
            throw new PoolingException(ex);
        }
    }

    private void forceTransactionCompletion(XAResource xares) throws SystemException {
        ConnectorXAResource connectorXARes;
        JavaEETransaction j2eetran;
        if (transactionCompletionMode != null && xares instanceof ConnectorXAResource && (j2eetran = (connectorXARes = (ConnectorXAResource)xares).getAssociatedTransaction()) != null && j2eetran.isLocalTx() && j2eetran.getStatus() == 0) {
            try {
                if (transactionCompletionMode.equalsIgnoreCase(COMMIT)) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Transaction Completion Mode for LocalTx resource is set as COMMIT, committing transaction");
                    }
                    j2eetran.commit();
                } else if (transactionCompletionMode.equalsIgnoreCase(ROLLBACK)) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Transaction Completion Mode for LocalTx resource is set as ROLLBACK, rolling back transaction");
                    }
                    j2eetran.rollback();
                } else {
                    _logger.log(Level.WARNING, "Unknown transaction completion mode, no action made");
                }
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Failure while forcibily completing an incomplete, local transaction ", e);
            }
        }
    }

    @Override
    public boolean shareableWithinComponent() {
        return this.shareable;
    }
}

