/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.Arrays;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-admin-object-class-names")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-admin-object-class-names", description="Get Admin Object Class Names", params={@RestParam(name="id", value="$parent")})})
public class GetAdminObjectClassNames
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Param
    private String rarName;
    @Param
    private String adminObjectInterface;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            String[] adminObjectClassNames = this.connectorRuntime.getAdminObjectClassNames(this.rarName, this.adminObjectInterface);
            Properties extraProperties = new Properties();
            if (adminObjectClassNames != null) {
                extraProperties.put("adminObjectClassNames", Arrays.asList(adminObjectClassNames));
            }
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-admin-object-class-names failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

