/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class SendMailFactory
implements ObjectFactory {
    protected static final String DataSourceClassName = "javax.mail.internet.MimePartDataSource";

    @Override
    public Object getObjectInstance(Object RefObj, Name Nm, Context Ctx, Hashtable<?, ?> Env) throws Exception {
        final Reference Ref = (Reference)RefObj;
        if (Ref.getClassName().equals(DataSourceClassName)) {
            return AccessController.doPrivileged(new PrivilegedAction<MimePartDataSource>(){

                @Override
                public MimePartDataSource run() {
                    Properties props = new Properties();
                    Enumeration<RefAddr> list = Ref.getAll();
                    props.put("mail.transport.protocol", "smtp");
                    while (list.hasMoreElements()) {
                        RefAddr refaddr = list.nextElement();
                        props.put(refaddr.getType(), refaddr.getContent());
                    }
                    try {
                        MimeMessage message = new MimeMessage(Session.getInstance((Properties)props));
                        String from = (String)Ref.get("mail.from").getContent();
                        message.setFrom((Address)new InternetAddress(from));
                        message.setSubject("");
                        MimePartDataSource mds = new MimePartDataSource((MimePart)message);
                        return mds;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        }
        return null;
    }
}

