/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.ProxyHandler;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;

public class ProxyHandlerImpl
extends ProxyHandler {
    public X509Certificate[] getSSLClientCertificateChain(HttpServletRequest request) throws CertificateException {
        X509Certificate[] certs = null;
        String clientCert = request.getHeader("Proxy-auth-cert");
        if (clientCert != null) {
            clientCert = clientCert.replaceAll("% d% a", "\n");
            clientCert = "-----BEGIN CERTIFICATE-----\n" + clientCert + "\n-----END CERTIFICATE-----";
            byte[] certBytes = clientCert.getBytes(Charset.defaultCharset());
            ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            certs = new X509Certificate[]{(X509Certificate)cf.generateCertificate(bais)};
        }
        return certs;
    }

    public int getSSLKeysize(HttpServletRequest request) {
        int keySize = -1;
        String header = request.getHeader("Proxy-keysize");
        if (header != null) {
            keySize = Integer.parseInt(header);
        }
        return keySize;
    }

    public String getRemoteAddress(HttpServletRequest request) {
        return request.getHeader("Proxy-ip");
    }
}

